/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

public final class MathUtilsd {
    public static final double nanoToSec = 0.0;
    public static final double FLOAT_ROUNDING_ERROR = 1.0E-6;
    public static final double PI = 3.1415927;
    public static final double PI2 = 6.2831854;
    public static final double E = 2.7182818;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final int ACOS_RESOLUTION = 50;
    private static final int ACOS_COUNT = 18000;
    private static final int ACOS_COUNT_1 = 17999;
    private static final double radFull = 6.2831854;
    private static final double degFull = 360.0;
    private static final double radToIndex = 2607.5945490960685;
    private static final double degToIndex = 45.51111111111111;
    public static final double radiansToDegrees = 57.29577866666166;
    public static final double radDeg = 57.29577866666166;
    public static final double degreesToRadians = 0.01745329277777778;
    public static final double degRad = 0.01745329277777778;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    static final int ATAN2_DIM = (int)Math.sqrt(16384.0);
    private static final double INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static void initialize() {
        double i = Sin.table[0];
        i = Acos.table[0];
    }

    public static final double sin(double radians) {
        return Sin.table[(int)(radians * 2607.5945490960685) & 0x3FFF];
    }

    public static final double cos(double radians) {
        return Sin.table[(int)((radians + 1.57079635) * 2607.5945490960685) & 0x3FFF];
    }

    public static final double acos(double x) {
        return Acos.table[(int)((x + 1.0) / 2.0 * 17999.0)];
    }

    public static final double acos_v1(double x) {
        return (-0.6981317007977321 * x * x - 0.8726646259971648) * x + 1.5707963267948966;
    }

    public static final double sinDeg(double degrees) {
        return Sin.table[(int)(degrees * 45.51111111111111) & 0x3FFF];
    }

    public static final double cosDeg(double degrees) {
        return Sin.table[(int)((degrees + 90.0) * 45.51111111111111) & 0x3FFF];
    }

    public static final double atan2(double y, double x) {
        double add;
        double mul;
        if (x < 0.0) {
            if (y < 0.0) {
                y = -y;
                mul = 1.0;
            } else {
                mul = -1.0;
            }
            x = -x;
            add = -3.1415927;
        } else {
            if (y < 0.0) {
                y = -y;
                mul = -1.0;
            } else {
                mul = 1.0;
            }
            add = 0.0;
        }
        double invDiv = 1.0 / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        if (invDiv == Double.POSITIVE_INFINITY) {
            return (Math.atan2(y, x) + add) * mul;
        }
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (Atan2.table[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int floor(double x) {
        return (int)(x + 16384.0) - 16384;
    }

    public static int floorPositive(double x) {
        return (int)x;
    }

    public static int ceil(double x) {
        return (int)(x + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(double x) {
        return (int)(x + 0.9999999);
    }

    public static int round(double x) {
        return (int)(x + 16384.5) - 16384;
    }

    public static int roundPositive(double x) {
        return (int)(x + 0.5);
    }

    public static boolean isZero(double value) {
        return Math.abs(value) <= 1.0E-6;
    }

    public static boolean isZero(double value, double tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) <= 1.0E-6;
    }

    public static boolean isEqual(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static double sqrt(double value) {
        double sqrt = Double.longBitsToDouble((Double.doubleToLongBits(value) - 0x10000000000000L >> 1) + 0x2000000000000000L);
        return (sqrt + value / sqrt) / 2.0;
    }

    public static double rint_v2(double x) {
        double t = MathUtilsd.floor(Math.abs(x) + 0.5);
        return x < 0.0 ? -t : t;
    }

    public static double cos_core(double x) {
        double x2 = x * x;
        double x4 = x2 * x2;
        double x8 = x4 * x4;
        return (-2.723637043978771E-7 * x2 + 2.4799852696610628E-5) * x8 + (-0.0013888885054799695 * x2 + 0.04166666663694368) * x4 + (-0.49999999999963024 * x2 + 1.0);
    }

    public static double sin_core(double x) {
        double x2 = x * x;
        double x4 = x2 * x2;
        return ((2.718121627547973E-6 * x2 - 1.9839312269456257E-4) * x4 + (0.008333329304842563 * x2 - 0.16666666640797048)) * x2 * x + x;
    }

    public static double asin_core(double x) {
        double x2 = x * x;
        double x4 = x2 * x2;
        double x8 = x4 * x4;
        return (((0.04533422054713205 * x2 - 0.0112262167625766) * x4 + (0.026334281471361822 * x2 + 0.020596336163223834)) * x8 + (0.030582043602875735 * x2 + 0.044630538556294605) * x4 + (0.07500036403413413 * x2 + 0.16666666300567365)) * x2 * x + x;
    }

    public static double sin_v2(double x) {
        double q = MathUtilsd.rint_v2(x * 0.6366197723675814);
        int quadrant = (int)q;
        double t = x - q * 1.5707963267923333;
        t -= q * 2.563344151594519E-12;
        t = (quadrant & 1) != 0 ? MathUtilsd.cos_core(t) : MathUtilsd.sin_core(t);
        return (quadrant & 2) != 0 ? -t : t;
    }

    public static double acos_v2(double x) {
        double xa = Math.abs(x);
        double t = xa > 0.5625 ? 2.0 * MathUtilsd.asin_core(MathUtilsd.sqrt(0.5 * (1.0 - xa))) : 1.5707963267948966 - MathUtilsd.asin_core(xa);
        return x < 0.0 ? Math.PI - t : t;
    }

    public static double lint(double x, double x0, double x1, double y0, double y1) {
        double rx0 = x0;
        double rx1 = x1;
        if (x0 > x1) {
            rx0 = x1;
            rx1 = x0;
        }
        if (x < rx0) {
            return y0;
        }
        if (x > rx1) {
            return y1;
        }
        return y0 + (y1 - y0) * (x - rx0) / (rx1 - rx0);
    }

    public static float lint(float x, float x0, float x1, float y0, float y1) {
        float rx0 = x0;
        float rx1 = x1;
        if (x0 > x1) {
            rx0 = x1;
            rx1 = x0;
        }
        if (x < rx0) {
            return y0;
        }
        if (x > rx1) {
            return y1;
        }
        return y0 + (y1 - y0) * (x - rx0) / (rx1 - rx0);
    }

    private static class Sin {
        static final double[] table;

        private Sin() {
        }

        static {
            int i;
            table = new double[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = Math.sin((double)(((float)i + 0.5f) / 16384.0f) * 6.2831854);
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((double)i * 45.51111111111111) & 0x3FFF] = Math.sin((double)i * 0.01745329277777778);
            }
        }
    }

    private static class Acos {
        static final double[] table = new double[18000];

        private Acos() {
        }

        static {
            for (int i = 0; i < 18000; ++i) {
                Acos.table[i] = Math.acos((double)i * 2.0 / 17999.0 - 1.0);
            }
        }
    }

    private static class Atan2 {
        static final double[] table = new double[16384];

        private Atan2() {
        }

        static {
            for (int i = 0; i < ATAN2_DIM; ++i) {
                for (int j = 0; j < ATAN2_DIM; ++j) {
                    double x0 = i / ATAN2_DIM;
                    double y0 = j / ATAN2_DIM;
                    Atan2.table[j * MathUtilsd.ATAN2_DIM + i] = Math.atan2(y0, x0);
                }
            }
        }
    }
}

