/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;

public class Serialized {
    private static final long serialVersionUID = 1L;

    public static int write(Object o, String name, boolean compressed) {
        try {
            FileOutputStream outFile = new FileOutputStream(name);
            ObjectOutputStream outStream = compressed ? new ObjectOutputStream(new GZIPOutputStream(outFile)) : new ObjectOutputStream(outFile);
            outStream.writeObject(o);
            outStream.close();
            outFile.close();
        }
        catch (FileNotFoundException e) {
            Serialized.ErrorMessage(e.toString());
            return 2;
        }
        catch (IOException e) {
            Serialized.ErrorMessage(e.toString());
            return 1;
        }
        return 0;
    }

    public static int write(Object o, String name) {
        return Serialized.write(o, name, true);
    }

    public static int writeXML(Object o, String name) {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            ObjectOutputStream out = xstream.createObjectOutputStream((OutputStream)new FileOutputStream(name));
            out.writeObject(o);
            out.close();
        }
        catch (IOException e) {
            Serialized.ErrorMessage(e.toString());
            return 1;
        }
        return 0;
    }

    private static Object read(String sfile, boolean compressed) {
        if ((sfile = sfile.trim()).startsWith("http") || sfile.startsWith("ftp")) {
            try {
                return Serialized.read(new URL(sfile), compressed);
            }
            catch (MalformedURLException e) {
                Serialized.ErrorMessage(e.toString());
            }
        } else {
            return Serialized.read(new File(sfile), compressed);
        }
        return null;
    }

    public static Object read(File file, boolean compressed) {
        Object p0 = null;
        try {
            FileInputStream fileIn = new FileInputStream(file);
            ObjectInputStream in = compressed ? new ObjectInputStream(new GZIPInputStream(fileIn)) : new ObjectInputStream(fileIn);
            p0 = in.readObject();
            in.close();
            fileIn.close();
        }
        catch (ClassNotFoundException e) {
            Serialized.ErrorMessage(e.toString());
        }
        catch (FileNotFoundException e) {
            Serialized.ErrorMessage(e.toString());
        }
        catch (IOException e) {
            Serialized.ErrorMessage(e.toString());
        }
        return p0;
    }

    public static Object read(URL url, boolean compressed) {
        Object p0 = null;
        try {
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            ObjectInputStream in = compressed ? new ObjectInputStream(new GZIPInputStream(urlConn.getInputStream())) : new ObjectInputStream(urlConn.getInputStream());
            p0 = in.readObject();
            in.close();
        }
        catch (ClassNotFoundException e) {
            Serialized.ErrorMessage(e.toString());
        }
        catch (IOException e) {
            Serialized.ErrorMessage(e.toString());
        }
        return p0;
    }

    public static Object read(String name) {
        return Serialized.read(name, true);
    }

    public static Object readXML(String name) {
        Object p0 = null;
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            FileInputStream fileIn = new FileInputStream(name);
            ObjectInputStream ino = xstream.createObjectInputStream((InputStream)fileIn);
            try {
                p0 = ino.readObject();
            }
            catch (ClassNotFoundException e) {
                Serialized.ErrorMessage(e.toString());
                return 2;
            }
            ino.close();
        }
        catch (IOException e) {
            Serialized.ErrorMessage(e.toString());
            return 1;
        }
        return p0;
    }

    public static String toXML(Object ob) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        String xml = xstream.toXML(ob);
        return xml;
    }

    public static Object fromXML(String xml) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        return xstream.fromXML(xml);
    }

    private static void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

