/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import jhplot.DProxy;
import jhplot.F1D;
import jhplot.F2D;
import jhplot.F3D;
import jhplot.FND;
import jhplot.FProxy;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import org.yaml.snakeyaml.Yaml;

public class HFileYAML {
    private FileInputStream iif;
    private ObjectInputStream iis;
    private int nev = 0;
    private Map<String, Object> hmap;
    private final int version = 2;
    private Yaml yaml = new Yaml();
    private String file;
    private String option;

    public HFileYAML(String file, String option) {
        this.file = file;
        this.option = option;
        if (option.equalsIgnoreCase("r")) {
            try {
                this.hmap = (Map)this.yaml.load((InputStream)new FileInputStream(new File(file)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("w")) {
            this.file = file;
            this.hmap = new HashMap<String, Object>();
        } else {
            this.ErrorMessage("Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public boolean write(String key, Object ob) {
        if (ob instanceof F1D) {
            ob = ((F1D)ob).get();
        } else if (ob instanceof F2D) {
            ob = ((F2D)ob).get();
        } else if (ob instanceof F3D) {
            ob = ((F3D)ob).get();
        } else if (ob instanceof FND) {
            ob = ((FND)ob).get();
        } else if (ob instanceof P1D) {
            ob = new DProxy((P1D)ob);
        } else if (ob instanceof P2D) {
            ob = new DProxy((P2D)ob);
        } else if (ob instanceof P0D) {
            ob = new DProxy((P0D)ob);
        } else if (ob instanceof P0I) {
            ob = new DProxy((P0I)ob);
        } else if (ob instanceof H1D) {
            ob = new DProxy((H1D)ob);
        }
        if (!this.hmap.containsKey(key)) {
            ++this.nev;
            this.hmap.put(key, ob);
            return true;
        }
        return false;
    }

    public Map<String, Object> getObjectMap() {
        return this.hmap;
    }

    public HFileYAML(String file) {
        this(file, "r");
    }

    public Object read(String key) {
        Object ob = null;
        if (this.hmap.containsKey(key)) {
            ob = this.hmap.get(key);
            if (ob instanceof FProxy) {
                if (((FProxy)ob).getType() == 1) {
                    ob = new F1D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 2) {
                    ob = new F2D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 3) {
                    ob = new F3D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 4) {
                    ob = new FND((FProxy)ob);
                }
                return ob;
            }
            if (ob instanceof DProxy) {
                if (((DProxy)ob).getType().equals("p1d")) {
                    ob = (P1D)((DProxy)ob).get();
                } else if (((DProxy)ob).getType().equals("p2d")) {
                    ob = (P2D)((DProxy)ob).get();
                } else if (((DProxy)ob).getType().equals("p0d")) {
                    ob = (P0D)((DProxy)ob).get();
                } else if (((DProxy)ob).getType().equals("p0i")) {
                    ob = (P0I)((DProxy)ob).get();
                } else if (((DProxy)ob).getType().equals("h1d")) {
                    ob = (H1D)((DProxy)ob).get();
                }
                return ob;
            }
        }
        return ob;
    }

    public boolean close() {
        boolean success = true;
        if (this.option.equalsIgnoreCase("w")) {
            try {
                new File(this.file).delete();
                FileWriter writer = new FileWriter(this.file);
                this.yaml.dump(this.hmap, (Writer)writer);
                ((Writer)writer).close();
                return success;
            }
            catch (IOException e) {
                e.printStackTrace();
                success = false;
                return success;
            }
        }
        return success;
    }

    public int getEntries() {
        return this.nev;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

