/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import jhplot.F1D;
import jhplot.F2D;
import jhplot.F3D;
import jhplot.FND;
import jhplot.FProxy;
import jhplot.gui.HelpBrowser;
import jhplot.io.HFileMap;
import jhplot.utils.Util;

public class HFileXML {
    public File recordsFile;
    public FileOutputStream oof;
    public ObjectOutputStream oos;
    private FileInputStream iif;
    private ObjectInputStream iis;
    private XStream xstream;
    private int reset = 100;
    private int nev = 0;
    private int buffer;
    private Map<String, Object> hmap;
    private final int version = 2;

    public HFileXML(String file, String option, int bufferSize) {
        this.buffer = bufferSize;
        this.nev = 0;
        this.hmap = new HFileMap(2);
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
                this.oof = new FileOutputStream(file);
                this.oos = this.xstream.createObjectOutputStream((OutputStream)new BufferedOutputStream(this.oof, this.buffer));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("r")) {
            try {
                this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
                this.iif = new FileInputStream(file);
                this.iis = this.xstream.createObjectInputStream((InputStream)new BufferedInputStream(this.iif, this.buffer));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.ErrorMessage("Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    public HFileXML(String file, String option) {
        this(file, option, 12288);
    }

    public boolean write(String key, Object ob) {
        if (!this.hmap.containsKey(key)) {
            this.hmap.put(key, ob);
            return true;
        }
        return false;
    }

    public Map<String, Object> getObjectMap() {
        if (this.hmap.size() == 0 && this.iis != null) {
            try {
                Object obj = null;
                while ((obj = this.iis.readObject()) != null) {
                    if (!(obj instanceof HFileMap)) continue;
                    this.hmap = (HFileMap)obj;
                    return this.hmap;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                return null;
            }
        }
        return this.hmap;
    }

    public int getBufferSize() {
        return this.buffer;
    }

    public HFileXML(String file) {
        this(file, "r");
    }

    public boolean write(Object ob) {
        boolean success = true;
        if (ob instanceof F1D) {
            ob = ((F1D)ob).get();
        } else if (ob instanceof F2D) {
            ob = ((F2D)ob).get();
        } else if (ob instanceof F3D) {
            ob = ((F3D)ob).get();
        } else if (ob instanceof FND) {
            ob = ((FND)ob).get();
        }
        try {
            this.oos.writeObject(ob);
            ++this.nev;
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public Object read() {
        Object ob = null;
        try {
            ob = this.iis.readObject();
            if (ob instanceof FProxy) {
                if (((FProxy)ob).getType() == 1) {
                    ob = new F1D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 2) {
                    ob = new F2D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 3) {
                    ob = new F3D((FProxy)ob);
                } else if (((FProxy)ob).getType() == 4) {
                    ob = new FND((FProxy)ob);
                }
            }
            if (ob instanceof HFileMap) {
                this.hmap = (HFileMap)ob;
                return null;
            }
            ++this.nev;
        }
        catch (IOException | ClassNotFoundException ex) {
            return null;
        }
        return ob;
    }

    public Object read(String key) {
        Object ob;
        Object obj = null;
        if (this.hmap.size() == 0 && this.iis != null) {
            try {
                while ((obj = this.iis.readObject()) != null) {
                    if (!(obj instanceof HFileMap)) continue;
                    this.hmap = (HFileMap)obj;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                return null;
            }
        }
        if (this.hmap.containsKey(key) && (ob = this.hmap.get(key)) instanceof FProxy) {
            if (((FProxy)ob).getType() == 1) {
                ob = new F1D((FProxy)ob);
            } else if (((FProxy)ob).getType() == 2) {
                ob = new F2D((FProxy)ob);
            } else if (((FProxy)ob).getType() == 3) {
                ob = new F3D((FProxy)ob);
            } else if (((FProxy)ob).getType() == 4) {
                ob = new FND((FProxy)ob);
            }
            return ob;
        }
        return null;
    }

    public boolean close() {
        boolean success = true;
        try {
            if (this.oos != null) {
                this.oos.writeObject(this.hmap);
                this.oof.flush();
                this.oos.close();
                this.oof.close();
                this.oos = null;
            }
            if (this.iis != null) {
                this.iis.close();
                this.iif.close();
                this.iis = null;
            }
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public int getEntries() {
        return this.nev;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

