/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ArrayReaderWriter {
    public static void write(double[] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            long value = Double.doubleToLongBits(array[i]);
            for (int n = 0; n < 8; ++n) {
                file.write((byte)(value & 0xFFL));
                value >>= 8;
            }
        }
        file.close();
    }

    public static void write(double[][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                long value = Double.doubleToLongBits(array[i][j]);
                for (int n = 0; n < 8; ++n) {
                    file.write((byte)(value & 0xFFL));
                    value >>= 8;
                }
            }
        }
        file.close();
    }

    public static void write(double[][][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = Double.doubleToLongBits(array[i][j][k]);
                    for (int n = 0; n < 8; ++n) {
                        file.write((byte)(value & 0xFFL));
                        value >>= 8;
                    }
                }
            }
        }
        file.close();
    }

    public static void write(double[][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = Double.doubleToLongBits(array[t][i2][j][k]);
                        for (int n = 0; n < 8; ++n) {
                            file.write((byte)(value & 0xFFL));
                            value >>= 8;
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static void write(double[][][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length, array[0][0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = Double.doubleToLongBits(array[t][i2][j][k][m]);
                            for (int n = 0; n < 8; ++n) {
                                file.write((byte)(value & 0xFFL));
                                value >>= 8;
                            }
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static double[] read1DArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        double[] array = null;
        int[] size = new int[1];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new double[size[0]];
        for (i = 0; i < array.length; ++i) {
            long value = 0L;
            for (int n = 0; n < 8; ++n) {
                value |= (long)(file.read() & 0xFF) << 8 * n;
            }
            array[i] = Double.longBitsToDouble(value);
        }
        file.close();
        return array;
    }

    public static double[][] read2DArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        double[][] array = null;
        int[] size = new int[2];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new double[size[0]][size[1]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                long value = 0L;
                for (int n = 0; n < 8; ++n) {
                    value |= (long)(file.read() & 0xFF) << 8 * n;
                }
                array[i][j] = Double.longBitsToDouble(value);
            }
        }
        file.close();
        return array;
    }

    public static double[][][] read3DArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        double[][][] array = null;
        int[] size = new int[3];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new double[size[0]][size[1]][size[2]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = 0L;
                    for (int n = 0; n < 8; ++n) {
                        value |= (long)(file.read() & 0xFF) << 8 * n;
                    }
                    array[i][j][k] = Double.longBitsToDouble(value);
                }
            }
        }
        file.close();
        return array;
    }

    public static double[][][][] read4DArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        double[][][][] array = null;
        int[] size = new int[4];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new double[size[0]][size[1]][size[2]][size[3]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = 0L;
                        for (int n = 0; n < 8; ++n) {
                            value |= (long)(file.read() & 0xFF) << 8 * n;
                        }
                        array[t][i][j][k] = Double.longBitsToDouble(value);
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static double[][][][][] read5DArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        double[][][][][] array = null;
        int[] size = new int[5];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new double[size[0]][size[1]][size[2]][size[3]][size[4]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = 0L;
                            for (int n = 0; n < 8; ++n) {
                                value |= (long)(file.read() & 0xFF) << 8 * n;
                            }
                            array[t][i][j][k][m] = Double.longBitsToDouble(value);
                        }
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static void write(float[] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            long value = Double.doubleToLongBits(array[i]);
            for (int n = 0; n < 8; ++n) {
                file.write((byte)(value & 0xFFL));
                value >>= 8;
            }
        }
        file.close();
    }

    public static void write(float[][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                long value = Double.doubleToLongBits(array[i][j]);
                for (int n = 0; n < 8; ++n) {
                    file.write((byte)(value & 0xFFL));
                    value >>= 8;
                }
            }
        }
        file.close();
    }

    public static void write(float[][][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = Double.doubleToLongBits(array[i][j][k]);
                    for (int n = 0; n < 8; ++n) {
                        file.write((byte)(value & 0xFFL));
                        value >>= 8;
                    }
                }
            }
        }
        file.close();
    }

    public static void write(float[][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = Double.doubleToLongBits(array[t][i2][j][k]);
                        for (int n = 0; n < 8; ++n) {
                            file.write((byte)(value & 0xFFL));
                            value >>= 8;
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static void write(float[][][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length, array[0][0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = Double.doubleToLongBits(array[t][i2][j][k][m]);
                            for (int n = 0; n < 8; ++n) {
                                file.write((byte)(value & 0xFFL));
                                value >>= 8;
                            }
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static float[] read1DFloatArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        float[] array = null;
        int[] size = new int[1];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new float[size[0]];
        for (i = 0; i < array.length; ++i) {
            long value = 0L;
            for (int n = 0; n < 8; ++n) {
                value |= (long)(file.read() & 0xFF) << 8 * n;
            }
            array[i] = (float)Double.longBitsToDouble(value);
        }
        file.close();
        return array;
    }

    public static float[][] read2DFloatArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        float[][] array = null;
        int[] size = new int[2];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new float[size[0]][size[1]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                long value = 0L;
                for (int n = 0; n < 8; ++n) {
                    value |= (long)(file.read() & 0xFF) << 8 * n;
                }
                array[i][j] = (float)Double.longBitsToDouble(value);
            }
        }
        file.close();
        return array;
    }

    public static float[][][] read3DFloatArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        float[][][] array = null;
        int[] size = new int[3];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new float[size[0]][size[1]][size[2]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = 0L;
                    for (int n = 0; n < 8; ++n) {
                        value |= (long)(file.read() & 0xFF) << 8 * n;
                    }
                    array[i][j][k] = (float)Double.longBitsToDouble(value);
                }
            }
        }
        file.close();
        return array;
    }

    public static float[][][][] read4DFloatArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        float[][][][] array = null;
        int[] size = new int[4];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new float[size[0]][size[1]][size[2]][size[3]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = 0L;
                        for (int n = 0; n < 8; ++n) {
                            value |= (long)(file.read() & 0xFF) << 8 * n;
                        }
                        array[t][i][j][k] = (float)Double.longBitsToDouble(value);
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static float[][][][][] read5DFloatArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        float[][][][][] array = null;
        int[] size = new int[5];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new float[size[0]][size[1]][size[2]][size[3]][size[4]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = 0L;
                            for (int n = 0; n < 8; ++n) {
                                value |= (long)(file.read() & 0xFF) << 8 * n;
                            }
                            array[t][i][j][k][m] = (float)Double.longBitsToDouble(value);
                        }
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static void write(int[] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            long value = Double.doubleToLongBits(array[i]);
            for (int n = 0; n < 8; ++n) {
                file.write((byte)(value & 0xFFL));
                value >>= 8;
            }
        }
        file.close();
    }

    public static void write(int[][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                long value = Double.doubleToLongBits(array[i][j]);
                for (int n = 0; n < 8; ++n) {
                    file.write((byte)(value & 0xFFL));
                    value >>= 8;
                }
            }
        }
        file.close();
    }

    public static void write(int[][][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = Double.doubleToLongBits(array[i][j][k]);
                    for (int n = 0; n < 8; ++n) {
                        file.write((byte)(value & 0xFFL));
                        value >>= 8;
                    }
                }
            }
        }
        file.close();
    }

    public static void write(int[][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = Double.doubleToLongBits(array[t][i2][j][k]);
                        for (int n = 0; n < 8; ++n) {
                            file.write((byte)(value & 0xFFL));
                            value >>= 8;
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static void write(int[][][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length, array[0][0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = Double.doubleToLongBits(array[t][i2][j][k][m]);
                            for (int n = 0; n < 8; ++n) {
                                file.write((byte)(value & 0xFFL));
                                value >>= 8;
                            }
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static int[] read1DIntArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        int[] array = null;
        int[] size = new int[1];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new int[size[0]];
        for (i = 0; i < array.length; ++i) {
            long value = 0L;
            for (int n = 0; n < 8; ++n) {
                value |= (long)(file.read() & 0xFF) << 8 * n;
            }
            array[i] = (int)Double.longBitsToDouble(value);
        }
        file.close();
        return array;
    }

    public static int[][] read2DIntArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        int[][] array = null;
        int[] size = new int[2];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new int[size[0]][size[1]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                long value = 0L;
                for (int n = 0; n < 8; ++n) {
                    value |= (long)(file.read() & 0xFF) << 8 * n;
                }
                array[i][j] = (int)Double.longBitsToDouble(value);
            }
        }
        file.close();
        return array;
    }

    public static int[][][] read3DIntArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        int[][][] array = null;
        int[] size = new int[3];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new int[size[0]][size[1]][size[2]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = 0L;
                    for (int n = 0; n < 8; ++n) {
                        value |= (long)(file.read() & 0xFF) << 8 * n;
                    }
                    array[i][j][k] = (int)Double.longBitsToDouble(value);
                }
            }
        }
        file.close();
        return array;
    }

    public static int[][][][] read4DIntArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        int[][][][] array = null;
        int[] size = new int[4];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new int[size[0]][size[1]][size[2]][size[3]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = 0L;
                        for (int n = 0; n < 8; ++n) {
                            value |= (long)(file.read() & 0xFF) << 8 * n;
                        }
                        array[t][i][j][k] = (int)Double.longBitsToDouble(value);
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static int[][][][][] read5DIntArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        int[][][][][] array = null;
        int[] size = new int[5];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new int[size[0]][size[1]][size[2]][size[3]][size[4]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = 0L;
                            for (int n = 0; n < 8; ++n) {
                                value |= (long)(file.read() & 0xFF) << 8 * n;
                            }
                            array[t][i][j][k][m] = (int)Double.longBitsToDouble(value);
                        }
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static void write(boolean[] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            long value = Double.doubleToLongBits(array[i] ? 1.0 : 0.0);
            for (int n = 0; n < 8; ++n) {
                file.write((byte)(value & 0xFFL));
                value >>= 8;
            }
        }
        file.close();
    }

    public static void write(boolean[][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                long value = Double.doubleToLongBits(array[i][j] ? 1.0 : 0.0);
                for (int n = 0; n < 8; ++n) {
                    file.write((byte)(value & 0xFFL));
                    value >>= 8;
                }
            }
        }
        file.close();
    }

    public static void write(boolean[][][] array, String filename) throws IOException {
        int j;
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (i = 0; i < array.length; ++i) {
            for (j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = Double.doubleToLongBits(array[i][j][k] ? 1.0 : 0.0);
                    for (int n = 0; n < 8; ++n) {
                        file.write((byte)(value & 0xFFL));
                        value >>= 8;
                    }
                }
            }
        }
        file.close();
    }

    public static void write(boolean[][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = Double.doubleToLongBits(array[t][i2][j][k] ? 1.0 : 0.0);
                        for (int n = 0; n < 8; ++n) {
                            file.write((byte)(value & 0xFFL));
                            value >>= 8;
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static void write(boolean[][][][][] array, String filename) throws IOException {
        int i;
        int[] size = new int[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length, array[0][0][0][0].length};
        BufferedOutputStream file = ArrayReaderWriter.getStream(filename);
        int temp = size.length;
        for (i = 0; i < 4; ++i) {
            file.write((byte)(temp & 0xFF));
            temp >>= 8;
        }
        for (i = 0; i < size.length; ++i) {
            temp = size[i];
            for (int j = 0; j < 4; ++j) {
                file.write((byte)(temp & 0xFF));
                temp >>= 8;
            }
        }
        for (int t = 0; t < array.length; ++t) {
            for (int i2 = 0; i2 < array[0].length; ++i2) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = Double.doubleToLongBits(array[t][i2][j][k][m] ? 1.0 : 0.0);
                            for (int n = 0; n < 8; ++n) {
                                file.write((byte)(value & 0xFFL));
                                value >>= 8;
                            }
                        }
                    }
                }
            }
        }
        file.close();
    }

    public static boolean[] read1DBooleanArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        boolean[] array = null;
        int[] size = new int[1];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new boolean[size[0]];
        for (i = 0; i < array.length; ++i) {
            long value = 0L;
            for (int n = 0; n < 8; ++n) {
                value |= (long)(file.read() & 0xFF) << 8 * n;
            }
            array[i] = Double.longBitsToDouble(value) == 1.0;
        }
        file.close();
        return array;
    }

    public static boolean[][] read2DBooleanArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        boolean[][] array = null;
        int[] size = new int[2];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new boolean[size[0]][size[1]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                long value = 0L;
                for (int n = 0; n < 8; ++n) {
                    value |= (long)(file.read() & 0xFF) << 8 * n;
                }
                array[i][j] = Double.longBitsToDouble(value) == 1.0;
            }
        }
        file.close();
        return array;
    }

    public static boolean[][][] read3DBooleanArray(String filename) throws IOException {
        int i;
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        boolean[][][] array = null;
        int[] size = new int[3];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new boolean[size[0]][size[1]][size[2]];
        for (i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                for (int k = 0; k < array[0][0].length; ++k) {
                    long value = 0L;
                    for (int n = 0; n < 8; ++n) {
                        value |= (long)(file.read() & 0xFF) << 8 * n;
                    }
                    array[i][j][k] = Double.longBitsToDouble(value) == 1.0;
                }
            }
        }
        file.close();
        return array;
    }

    public static boolean[][][][] read4DBooleanArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        boolean[][][][] array = null;
        int[] size = new int[4];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new boolean[size[0]][size[1]][size[2]][size[3]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        long value = 0L;
                        for (int n = 0; n < 8; ++n) {
                            value |= (long)(file.read() & 0xFF) << 8 * n;
                        }
                        array[t][i][j][k] = Double.longBitsToDouble(value) == 1.0;
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static boolean[][][][][] read5DBooleanArray(String filename) throws IOException {
        BufferedInputStream file = new BufferedInputStream(new FileInputStream(filename));
        boolean[][][][][] array = null;
        int[] size = new int[5];
        int temp = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        if (temp != size.length) {
            throw new IOException("File doesn't contain a " + size.length + " dimensional array");
        }
        for (int i = 0; i < size.length; ++i) {
            size[i] = file.read() & 0xFF | (file.read() & 0xFF) << 8 | (file.read() & 0xFF) << 16 | (file.read() & 0xFF) << 24;
        }
        array = new boolean[size[0]][size[1]][size[2]][size[3]][size[4]];
        for (int t = 0; t < array.length; ++t) {
            for (int i = 0; i < array[0].length; ++i) {
                for (int j = 0; j < array[0][0].length; ++j) {
                    for (int k = 0; k < array[0][0][0].length; ++k) {
                        for (int m = 0; m < array[0][0][0][0].length; ++m) {
                            long value = 0L;
                            for (int n = 0; n < 8; ++n) {
                                value |= (long)(file.read() & 0xFF) << 8 * n;
                            }
                            array[t][i][j][k][m] = Double.longBitsToDouble(value) == 1.0;
                        }
                    }
                }
            }
        }
        file.close();
        return array;
    }

    public static BufferedOutputStream getStream(String filename) throws IOException {
        File file = new File(filename);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(filename));
    }

    public static void main(String[] args) {
        int i;
        Object x = new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, {10, 11, 12}};
        double[] y = new double[]{Math.PI, Math.E, Double.MAX_VALUE, Double.MIN_VALUE, -1.23};
        String filename1 = "intArray.dat";
        String filename2 = "Results/doubleArray.dat";
        try {
            ArrayReaderWriter.write(x, filename1);
            ArrayReaderWriter.write(y, filename2);
            x = ArrayReaderWriter.read2DIntArray(filename1);
            y = ArrayReaderWriter.read1DArray(filename2);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        for (i = 0; i < ((int[][])x).length; ++i) {
            for (int j = 0; j < x[0].length; ++j) {
                System.out.print(x[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println();
        for (i = 0; i < y.length; ++i) {
            System.out.print(y[i] + " ");
        }
        System.out.println();
    }
}

