/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.util.Random;
import jhplot.bsom.Bsom;

public class Matrix {
    static final double small = 1.0E-8;
    int row;
    int col;
    double[][] value;

    public Matrix(int n) {
        this(n, n);
    }

    public Matrix(int row, int col) {
        this.row = row;
        this.col = col;
        this.value = new double[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.value[i][j] = 0.0;
            }
        }
    }

    public static Matrix identity(int n) {
        Matrix ret = new Matrix(n);
        for (int i = 0; i < n; ++i) {
            ret.value[i][i] = 1.0;
        }
        return ret;
    }

    public static Matrix random(int row, int col, int seed) {
        int j;
        int i;
        Random rnd = new Random(seed);
        Matrix ret = new Matrix(row, col);
        if (Bsom.INIT == 0) {
            for (i = 0; i < row; ++i) {
                for (j = 0; j < col; ++j) {
                    ret.value[i][j] = rnd.nextGaussian();
                }
            }
        }
        if (Bsom.INIT == 1) {
            for (i = 0; i < row; ++i) {
                for (j = 0; j < col; ++j) {
                    ret.value[i][j] = Bsom.value[i][j];
                }
            }
        }
        return ret;
    }

    public static Matrix random(int row, int col) {
        return Matrix.random(row, col, 1);
    }

    public Matrix copy() {
        Matrix ret = new Matrix(this.row, this.col);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                ret.value[i][j] = this.value[i][j];
            }
        }
        return ret;
    }

    public Matrix transpose() {
        Matrix ret = new Matrix(this.col, this.row);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                ret.value[j][i] = this.value[i][j];
            }
        }
        return ret;
    }

    public Matrix linearConv(double a, double b, Matrix Y) {
        int Y_row = Y.row;
        int Y_col = Y.col;
        if (this.row == Y_row && this.col == Y_col) {
            Matrix ret = new Matrix(this.row, this.col);
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    ret.value[i][j] = a * this.value[i][j] + b * Y.value[i][j];
                }
            }
            return ret;
        }
        return null;
    }

    public void updateLinearConv(double a, double b, Matrix Y) {
        int Y_row = Y.row;
        int Y_col = Y.col;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.value[i][j] = a * this.value[i][j] + b * Y.value[i][j];
            }
        }
    }

    public Matrix multipliedBy(double a) {
        Matrix ret = new Matrix(this.row, this.col);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                ret.value[i][j] = a * this.value[i][j];
            }
        }
        return ret;
    }

    public Matrix multipliedBy(Matrix Y) {
        int Y_row = Y.row;
        int Y_col = Y.col;
        if (this.col != Y_row) {
            return null;
        }
        Matrix ret = new Matrix(this.row, Y_col);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < Y_col; ++j) {
                double s = 0.0;
                for (int k = 0; k < this.col; ++k) {
                    s += this.value[i][k] * Y.value[k][j];
                }
                ret.value[i][j] = s;
            }
        }
        return ret;
    }

    public Matrix dividedBy(Matrix Y) {
        return this.dividedBy(Y, 2 * this.col - 1);
    }

    public Matrix dividedBy(Matrix Y, int bw) {
        int i;
        int j;
        double w;
        int k;
        Matrix L = this.copy();
        Matrix U = Y.copy();
        int m = L.row;
        int n = U.col;
        bw = bw / 2 + 1;
        for (k = 0; k < m; ++k) {
            double s;
            double pp = L.value[k][k];
            if (Math.abs(pp) < 1.0E-8) {
                return null;
            }
            w = 1.0 / pp;
            for (j = k + 1; j < k + bw && j < m; ++j) {
                L.value[k][j] = s = w * L.value[k][j];
                for (i = k + 1; i < k + bw + 1 && i < m; ++i) {
                    L.value[i][j] = s = L.value[i][j] - L.value[i][k] * L.value[k][j];
                }
            }
            for (j = 0; j < n; ++j) {
                U.value[k][j] = s = w * U.value[k][j];
                for (i = k + 1; i < k + bw && i < m; ++i) {
                    U.value[i][j] = s = U.value[i][j] - L.value[i][k] * U.value[k][j];
                }
            }
        }
        Matrix ret = new Matrix(m, n);
        i = m;
        while (--i >= 0) {
            for (j = 0; j < n; ++j) {
                w = U.value[i][j];
                for (k = i + 1; i < k + bw && k < m; ++k) {
                    w -= L.value[i][k] * ret.value[k][j];
                }
                ret.value[i][j] = w;
            }
        }
        return ret;
    }

    public Matrix crossSqDistance(Matrix Y) {
        int Y_row = Y.row;
        int Y_col = Y.col;
        if (this.col != Y_col) {
            return null;
        }
        Matrix ret = new Matrix(this.row, Y_row);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < Y_row; ++j) {
                double s = 0.0;
                for (int k = 0; k < this.col; ++k) {
                    double d = this.value[i][k] - Y.value[j][k];
                    s += d * d;
                }
                ret.value[i][j] = s;
            }
        }
        return ret;
    }

    public void updateExp() {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.value[i][j] = Math.exp(this.value[i][j]);
            }
        }
    }

    public Matrix horizontalSum() {
        Matrix ret = new Matrix(this.row, 1);
        for (int i = 0; i < this.row; ++i) {
            double s = 0.0;
            for (int j = 0; j < this.col; ++j) {
                s += this.value[i][j];
            }
            ret.value[i][0] = s;
        }
        return ret;
    }

    public Matrix verticalSum() {
        Matrix ret = new Matrix(1, this.col);
        for (int j = 0; j < this.col; ++j) {
            double s = 0.0;
            for (int i = 0; i < this.row; ++i) {
                s += this.value[i][j];
            }
            ret.value[0][j] = s;
        }
        return ret;
    }

    public double sumEntries() {
        double s = 0.0;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                s += this.value[i][j];
            }
        }
        return s;
    }

    public double sumSqrEntries() {
        double s = 0.0;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                s += this.value[i][j] * this.value[i][j];
            }
        }
        return s;
    }

    public Matrix mulipliedEntriesWith(Matrix Y) {
        Matrix ret = new Matrix(this.row, this.col);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                ret.value[i][j] = this.value[i][j] * Y.value[i][j];
            }
        }
        return ret;
    }

    public void updateDivideByRowVector(Matrix vec) {
        for (int j = 0; j < this.col; ++j) {
            for (int i = 0; i < this.row; ++i) {
                this.value[i][j] = this.value[i][j] / vec.value[0][j];
            }
        }
    }

    public Matrix diagonal() {
        Matrix ret;
        if (this.row == 1) {
            ret = new Matrix(this.col, this.col);
            for (int i = 0; i < this.col; ++i) {
                ret.value[i][i] = this.value[0][i];
            }
        } else if (this.col == 1) {
            ret = new Matrix(this.row, this.row);
            for (int i = 0; i < this.row; ++i) {
                ret.value[i][i] = this.value[i][0];
            }
        } else {
            int n = Math.min(this.row, this.col);
            ret = new Matrix(1, n);
            for (int i = 0; i < n; ++i) {
                ret.value[0][i] = this.value[i][i];
            }
        }
        return ret;
    }

    public Matrix eigenvalues(double eps, int lmax) {
        int im = 0;
        int jm = 0;
        Matrix px = this.copy();
        int n = px.row;
        Matrix qx = Matrix.identity(n);
        int ll = 0;
        do {
            double p2;
            double p1;
            int i;
            double pmax = Math.abs(px.value[0][1]);
            ++ll;
            for (i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    if (!(pmax <= Math.abs(px.value[i][j]))) continue;
                    pmax = Math.abs(px.value[i][j]);
                    im = i;
                    jm = j;
                }
            }
            if (pmax <= eps) break;
            double pii = px.value[im][im];
            double pjj = px.value[jm][jm];
            double pij = px.value[im][jm];
            double d = pii - pjj;
            double dd = d * d + 4.0 * pij * pij;
            double tn = 2.0 * pij / (d + Math.sqrt(dd) * (double)(d > 0.0 ? 1 : -1));
            double a = 1.0 / Math.sqrt(1.0 + tn * tn);
            double b = a * tn;
            for (i = 0; i < n; ++i) {
                p1 = px.value[i][im];
                p2 = px.value[i][jm];
                px.value[i][im] = p1 * a + p2 * b;
                px.value[i][jm] = -p1 * b + p2 * a;
                double q1 = qx.value[i][im];
                double q2 = qx.value[i][jm];
                qx.value[i][im] = q1 * a + q2 * b;
                qx.value[i][jm] = -q1 * b + q2 * a;
            }
            for (i = 0; i < n; ++i) {
                p1 = px.value[im][i];
                p2 = px.value[jm][i];
                px.value[im][i] = p1 * a + p2 * b;
                px.value[jm][i] = -p1 * b + p2 * a;
            }
        } while (ll < lmax);
        Matrix lmd = px.diagonal();
        return lmd;
    }
}

