/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import jhplot.bsom.BsomDemo;
import jhplot.bsom.Data;
import jhplot.bsom.Matrix;
import jhplot.bsom.Weight;

class DrawArea
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    BsomDemo demo;
    int xd;
    int yd;
    double scale;
    int ntot = 0;
    int n_data;
    int n_unit;
    double alpha;
    double beta;
    double width;
    double height;
    double noise_level;
    double phase;
    double initial_weight_level;
    int dstep;
    boolean density_mode = false;
    Data X;
    Weight W;
    Matrix D;
    Matrix M;
    Matrix lmd;
    Thread thread;
    int wait_time = 100;
    boolean learn = false;
    boolean auto_learn = false;
    int grabed_unit = -1;
    Graphics offgraphics;
    Dimension offscreensize;
    Image offscreen;

    public DrawArea(BsomDemo demo, int xd, int yd, double scale) {
        this.demo = demo;
        this.xd = xd;
        this.yd = yd;
        this.scale = scale;
    }

    public void init() {
        this.initWeight();
        this.initData();
    }

    void initWeight() {
        this.W = new Weight(this.n_unit, this.scale, 2, this.xd, this.yd, this.initial_weight_level);
        this.makePriorHessian(this.n_unit);
    }

    void initData() {
        this.X = new Data(this.n_data, this.scale, 0, this.xd, this.yd, this.width, this.height, this.phase, this.noise_level);
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.thread.stop();
    }

    public void runNoThread() {
        double ini_gam = 0.0;
        this.grabed_unit = -1;
        this.ntot = 0;
        while (true) {
            if (this.learn) {
                this.W.update(this.X, this.M, this.alpha, this.beta, this.grabed_unit);
                if (this.auto_learn) {
                    double gamma = this.W.ngp(this.n_data, this.alpha, this.beta, this.lmd);
                    this.alpha = this.W.updateAlpha(this.D, gamma);
                    this.beta = this.W.updateBeta(this.n_data, gamma);
                    if (Math.abs(gamma - ini_gam) < BsomDemo.delta) break;
                    ini_gam = gamma;
                }
            }
            ++this.ntot;
        }
    }

    @Override
    public void run() {
        this.ntot = 0;
        try {
            while (true) {
                Thread.sleep(this.wait_time);
                if (this.learn) {
                    this.W.update(this.X, this.M, this.alpha, this.beta, this.grabed_unit);
                    if (this.auto_learn) {
                        double gamma = this.W.ngp(this.n_data, this.alpha, this.beta, this.lmd);
                        this.alpha = this.W.updateAlpha(this.D, gamma);
                        this.beta = this.W.updateBeta(this.n_data, gamma);
                        this.alpha = this.demo.alphaSlider.setValueOfSlider(this.alpha);
                        this.beta = this.demo.betaSlider.setValueOfSlider(this.beta);
                    }
                }
                this.repaint();
                ++this.ntot;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public synchronized void update(Graphics g) {
        Dimension d = this.size();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
        }
        if (!this.density_mode) {
            this.offgraphics.setColor(this.getBackground());
            this.offgraphics.fillRect(0, 0, d.width, d.height);
            this.offgraphics.setColor(Color.black);
        } else {
            g.drawString("Now, density is calculated.", 0, 10);
            this.drawDensity(this.offgraphics);
            this.offgraphics.setColor(Color.red);
            this.offgraphics.drawString("a=" + this.alpha, 0, 10);
            this.offgraphics.drawString("b=" + this.beta, 0, 20);
            this.offgraphics.setColor(Color.green);
        }
        this.X.draw(this.offgraphics);
        this.offgraphics.setColor(Color.blue);
        this.W.draw(this.offgraphics);
        this.W.drawCurve(this.offgraphics);
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.offscreen != null) {
            g.drawImage(this.offscreen, 0, 0, null);
        }
    }

    @Override
    public synchronized boolean mouseDown(Event evt, int ix, int iy) {
        this.grabed_unit = this.W.index(ix, iy);
        return true;
    }

    @Override
    public synchronized boolean mouseDrag(Event evt, int ix, int iy) {
        if (this.grabed_unit >= 0) {
            this.W.move(this.grabed_unit, ix, iy);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean mouseUp(Event evt, int ix, int iy) {
        this.grabed_unit = -1;
        return true;
    }

    void makePriorHessian(int r) {
        double lmd_max;
        int i;
        int rep_limit = 1000;
        double eps = 1.0E-5;
        this.D = new Matrix(r - 2, r);
        for (i = 0; i < r - 2; ++i) {
            for (int j = 0; j < r; ++j) {
                if (j == i + 1) {
                    this.D.value[i][j] = -2.0;
                }
                if (j != i && j != i + 2) continue;
                this.D.value[i][j] = 1.0;
            }
        }
        Matrix Dt = this.D.transpose();
        this.M = Dt.multipliedBy(this.D);
        this.lmd = this.M.eigenvalues(eps, rep_limit);
        int i1 = 0;
        int i2 = 0;
        double lmd_min1 = lmd_max = this.lmd.value[0][0];
        for (i = 1; i < r; ++i) {
            if (this.lmd.value[0][i] < lmd_min1) {
                lmd_min1 = this.lmd.value[0][i];
                i1 = i;
            }
            if (!(this.lmd.value[0][i] > lmd_max)) continue;
            lmd_max = this.lmd.value[0][i];
        }
        this.lmd.value[0][i1] = 0.0;
        double lmd_min2 = lmd_max;
        for (i = 0; i < r; ++i) {
            if (!(this.lmd.value[0][i] > 0.0) || !(this.lmd.value[0][i] < lmd_min2)) continue;
            lmd_min2 = this.lmd.value[0][i];
            i2 = i;
        }
        this.lmd.value[0][i2] = 0.0;
    }

    public void drawDensity(Graphics g) {
        int j;
        int i;
        Dimension s = this.size();
        int nx = s.width / this.dstep;
        int ny = s.height / this.dstep;
        Matrix pos = new Matrix(nx * ny, 2);
        int k = 0;
        for (i = 0; i < nx; ++i) {
            for (j = 0; j < ny; ++j) {
                double x = ((double)i + 0.5) * (double)this.dstep;
                double y = ((double)j + 0.5) * (double)this.dstep;
                pos.value[k][0] = (x - (double)this.xd) / this.scale;
                pos.value[k][1] = -(y - (double)this.yd) / this.scale;
                ++k;
            }
        }
        Matrix density = this.W.makeDensity(pos, this.beta);
        k = 0;
        for (i = 0; i < nx; ++i) {
            for (j = 0; j < ny; ++j) {
                float c = (float)density.value[0][k];
                g.setColor(new Color(c, c, c));
                g.fillRect(i * this.dstep, j * this.dstep, this.dstep, this.dstep);
                ++k;
            }
        }
    }
}

