/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jhplot.P1D;
import jhplot.bsom.AlphaSlider;
import jhplot.bsom.BetaSlider;
import jhplot.bsom.BsomDemo;
import jhplot.bsom.BsomDrawArea;
import jhplot.bsom.UserData;
import jhplot.bsom.Weight;

public class Bsom
extends BsomDemo {
    private static final long serialVersionUID = 1L;
    private BsomDrawArea bsomDrawArea;
    private JTextField inputText;
    private JTextField dstepText;
    private String input_file;
    private JButton outputButton;
    private P1D p1d = null;
    private Vector<Double> buf;
    static int INIT = 0;
    static double[][] value;

    public int getNiterations() {
        return this.bsomDrawArea.ntot;
    }

    public double getAlpha() {
        return this.bsomDrawArea.alpha;
    }

    public double getBeta() {
        return this.bsomDrawArea.beta;
    }

    public void initPar(double alpha, double beta, int units) {
        INIT = 0;
        this.n_data = 100;
        this.n_unit = units;
        this.alpha_min_power = 0.0;
        this.alpha_max_power = 5.0;
        this.beta_min_power = 0.0;
        this.beta_max_power = 5.0;
        this.xd = 250;
        this.yd = 175;
        this.scale = 80.0;
        this.dstep = 10;
        this.initial_weight_level = 0.1;
        this.input_file = "p1d";
        this.initial_alpha = alpha;
        this.initial_beta = beta;
        if (this.buf != null) {
            this.n_data = this.buf.size() / 2;
        } else {
            this.showStatus("Input is data are required.");
            this.stop();
        }
        this.bsomDrawArea = new BsomDrawArea(this, this.xd, this.yd, this.scale);
        this.bsomDrawArea.n_data = this.n_data;
        this.bsomDrawArea.n_unit = this.n_unit;
        this.bsomDrawArea.dstep = this.dstep;
        this.bsomDrawArea.initial_weight_level = this.initial_weight_level;
        this.bsomDrawArea.alpha = this.initial_alpha;
        this.bsomDrawArea.beta = this.initial_beta;
        this.bsomDrawArea.buf = this.buf;
        P1D init = this.p1d.copy();
        int n = this.p1d.size();
        if (units == n) {
            INIT = 1;
            double mx = init.meanX();
            double my = init.meanY();
            value = new double[n][2];
            for (int i = 0; i < n; ++i) {
                Bsom.value[i][0] = init.getX(i);
                Bsom.value[i][1] = init.getY(i);
            }
            double dmax = 0.0;
            for (int i = 0; i < n; ++i) {
                double[] dArray = value[i];
                dArray[0] = dArray[0] - mx;
                double[] dArray2 = value[i];
                dArray2[1] = dArray2[1] - my;
                if (Math.abs(value[i][0]) > dmax) {
                    dmax = Math.abs(value[i][0]);
                }
                if (!(Math.abs(value[i][1]) > dmax)) continue;
                dmax = Math.abs(value[i][1]);
            }
            double dscale = 2.0 / dmax;
            for (int i = 0; i < n; ++i) {
                double[] dArray = value[i];
                dArray[0] = dArray[0] * dscale;
                double[] dArray3 = value[i];
                dArray3[1] = dArray3[1] * dscale;
            }
        }
        this.bsomDrawArea.init();
        UserData UX = (UserData)this.bsomDrawArea.X;
        double dscale = UX.dscale;
        this.drawArea = this.bsomDrawArea;
        this.drawArea.W.init();
    }

    public void init(int units) {
        this.alpha_min_power = 0.0;
        this.alpha_max_power = 5.0;
        this.beta_min_power = 0.0;
        this.beta_max_power = 5.0;
        this.initial_alpha = Math.pow(10.0, this.alpha_max_power);
        this.initial_beta = Math.pow(10.0, this.beta_min_power);
        this.initPar(this.initial_alpha, this.initial_beta, units);
        if (this.p1d != null) {
            this.input_file = this.p1d.getTitle();
        }
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.bsomDrawArea.setBackground(Color.white);
        this.bsomDrawArea.setSize(new Dimension(600, 400));
        this.drawArea = this.bsomDrawArea;
        this.add("Center", this.bsomDrawArea);
        JPanel controlPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1));
        this.learnButton = new JCheckBox("learn");
        this.learnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Bsom.this.drawArea.learn = Bsom.this.learnButton.isSelected();
                if (!Bsom.this.drawArea.learn && Bsom.this.drawArea.auto_learn) {
                    Bsom.this.drawArea.auto_learn = false;
                    Bsom.this.autoButton.setSelected(false);
                }
            }
        });
        this.autoButton = new JCheckBox("auto");
        this.autoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Bsom.this.drawArea.auto_learn = Bsom.this.autoButton.isSelected();
                if (!Bsom.this.drawArea.learn && Bsom.this.drawArea.auto_learn) {
                    Bsom.this.drawArea.learn = true;
                    Bsom.this.learnButton.setSelected(true);
                }
            }
        });
        this.densityButton = new JCheckBox("density");
        this.densityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (Bsom.this.densityButton.isSelected()) {
                    Bsom.this.drawArea.stop();
                    Bsom.this.drawArea.density_mode = true;
                    Bsom.this.drawArea.repaint();
                } else {
                    Bsom.this.drawArea.density_mode = false;
                    Bsom.this.drawArea.start();
                }
            }
        });
        this.initButton = new JButton("init");
        this.initButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Bsom.this.drawArea.W.init();
                if (Bsom.this.drawArea.auto_learn) {
                    Bsom.this.alphaSlider.setValueOfSlider(Bsom.this.initial_alpha);
                    Bsom.this.betaSlider.setValueOfSlider(Bsom.this.initial_beta);
                    Bsom.this.drawArea.alpha = Bsom.this.initial_alpha;
                    Bsom.this.drawArea.beta = Bsom.this.initial_beta;
                }
            }
        });
        buttonPanel.add(this.learnButton);
        buttonPanel.add(this.autoButton);
        buttonPanel.add(this.densityButton);
        buttonPanel.add(this.initButton);
        controlPanel.add(buttonPanel);
        JPanel weightPanel = new JPanel();
        weightPanel.setLayout(new GridLayout(2, 1));
        JPanel alphaSliderPanel = new JPanel();
        alphaSliderPanel.setLayout(new BorderLayout());
        this.alphaSlider = new AlphaSlider(this.bsomDrawArea, this.alpha_min_power, this.alpha_max_power);
        JLabel alabel = new JLabel("alpha (log10)");
        alphaSliderPanel.add("Center", this.alphaSlider);
        alphaSliderPanel.add("South", alabel);
        weightPanel.add(alphaSliderPanel);
        JPanel betaSliderPanel = new JPanel();
        betaSliderPanel.setLayout(new BorderLayout());
        this.betaSlider = new BetaSlider(this.bsomDrawArea, this.beta_min_power, this.beta_max_power);
        JLabel blabel = new JLabel("beta (log10)");
        betaSliderPanel.add("Center", this.betaSlider);
        betaSliderPanel.add("South", blabel);
        weightPanel.add(betaSliderPanel);
        controlPanel.add(weightPanel);
        JPanel IOPanel = new JPanel();
        IOPanel.setLayout(new GridLayout(4, 1));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(1, 2));
        JLabel inputLabel = new JLabel("Input:");
        this.inputText = new JTextField(this.input_file, 10);
        this.inputText.setEditable(false);
        inputPanel.add(inputLabel);
        inputPanel.add(this.inputText);
        IOPanel.add(inputPanel);
        JPanel unitNumberPanel = new JPanel();
        unitNumberPanel.setLayout(new GridLayout(1, 2));
        this.unitNumberText = new JTextField("" + this.n_unit, 10);
        this.unitNumberText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bsom.this.n_unit = Integer.parseInt(Bsom.this.unitNumberText.getText());
                Bsom.this.resetUnitNumber(Bsom.this.n_unit);
            }
        });
        JLabel unitNumberLabel = new JLabel("units");
        unitNumberPanel.add(unitNumberLabel);
        unitNumberPanel.add(this.unitNumberText);
        IOPanel.add(unitNumberPanel);
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout(new GridLayout(1, 2));
        this.outputButton = new JButton("generate");
        this.outputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Bsom.this.outputWeight();
            }
        });
        JLabel dmy = new JLabel("Output: ");
        outputPanel.add(dmy);
        outputPanel.add(this.outputButton);
        IOPanel.add(outputPanel);
        controlPanel.add(IOPanel);
        this.add("South", controlPanel);
        this.alphaSlider.setValueOfSlider(this.initial_alpha);
        this.betaSlider.setValueOfSlider(this.initial_beta);
        this.bsomDrawArea.init();
        this.repaint();
    }

    @Override
    public void start() {
        if (!this.bsomDrawArea.density_mode) {
            this.bsomDrawArea.start();
        }
    }

    @Override
    public void stop() {
        this.bsomDrawArea.stop();
    }

    @Override
    public synchronized boolean action(Event evt, Object what) {
        if (super.action(evt, what)) {
            return true;
        }
        if (evt.target == this.inputText) {
            this.reloadData((String)what);
            return true;
        }
        if (evt.target == this.dstepText) {
            this.bsomDrawArea.dstep = this.dstep = Integer.valueOf((String)what).intValue();
            return true;
        }
        if (evt.target == this.outputButton) {
            this.outputWeight();
            return true;
        }
        return false;
    }

    public void setDelta(double delta) {
        BsomDemo.delta = delta;
    }

    public double getDelta() {
        return BsomDemo.delta;
    }

    public void loadData(P1D p1d) {
        this.buf = new Vector();
        this.p1d = p1d;
        for (int i = 0; i < p1d.size(); ++i) {
            this.buf.addElement(new Double(p1d.getX(i)));
            this.buf.addElement(new Double(p1d.getY(i)));
        }
    }

    public void loadData(String input_file) {
        this.buf = new Vector();
        this.p1d = new P1D(input_file);
        for (int i = 0; i < this.p1d.size(); ++i) {
            this.buf.addElement(new Double(this.p1d.getX(i)));
            this.buf.addElement(new Double(this.p1d.getY(i)));
        }
    }

    public void reloadData(String input_file) {
        if (this.p1d != null) {
            this.loadData(this.p1d);
        }
        this.bsomDrawArea.alpha = this.initial_alpha;
        this.bsomDrawArea.beta = this.initial_beta;
        this.bsomDrawArea.buf = this.buf;
        this.bsomDrawArea.auto_learn = false;
        this.bsomDrawArea.learn = false;
        this.bsomDrawArea.initData();
        this.bsomDrawArea.W.init();
        this.bsomDrawArea.draw_new_data = true;
        this.autoButton.setSelected(false);
        this.learnButton.setSelected(false);
        this.alphaSlider.setValueOfSlider(this.initial_alpha);
        this.betaSlider.setValueOfSlider(this.initial_beta);
        this.repaint();
    }

    public void outputWeight() {
        Weight W = this.bsomDrawArea.W;
        UserData UX = (UserData)this.bsomDrawArea.X;
        double dscale = UX.dscale;
        double mx = UX.mx;
        double my = UX.my;
        for (int i = 0; i < W.row; ++i) {
            double x = W.value[i][0] / dscale + mx;
            double y = W.value[i][1] / dscale + my;
            System.out.println(x + " " + y);
        }
        System.out.println(" ");
    }

    public P1D outputWeightP1D() {
        Weight W = this.bsomDrawArea.W;
        UserData UX = (UserData)this.bsomDrawArea.X;
        double dscale = UX.dscale;
        double mx = UX.mx;
        double my = UX.my;
        P1D p1d = new P1D("MSOM results");
        for (int i = 0; i < W.row; ++i) {
            double x = W.value[i][0] / dscale + mx;
            double y = W.value[i][1] / dscale + my;
            p1d.add(x, y);
        }
        return p1d;
    }

    private void showStatus(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

