/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Arrays;

public class Web {
    public static final String fSep = System.getProperty("file.separator");
    public static final String lSep = System.getProperty("line.separator");

    public static WgetStatus get(String url) {
        return Web.get(url, false);
    }

    public static WgetStatus get(String url, boolean isOverwrite) {
        String fileName = url.substring(url.lastIndexOf(47) + 1, url.length());
        Path currentRelativePath = Paths.get("", new String[0]);
        String s = currentRelativePath.toAbsolutePath().toString();
        return Web.get(url, s + File.separator + fileName, isOverwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WgetStatus get(String url, String saveAsFile, boolean isOverwrite) {
        File f;
        if (!isOverwrite && (f = new File(saveAsFile)).exists() && !f.isDirectory()) {
            return WgetStatus.AlreadyExists;
        }
        BufferedInputStream httpIn = null;
        OutputStream fileOutput = null;
        OutputStream bufferedOut = null;
        try {
            httpIn = new BufferedInputStream(new URL(url).openStream());
            fileOutput = new FileOutputStream(saveAsFile);
            bufferedOut = new BufferedOutputStream(fileOutput, 2048);
            byte[] data = new byte[2048];
            boolean fileComplete = false;
            int count = 0;
            while (!fileComplete) {
                count = ((InputStream)httpIn).read(data, 0, 2048);
                if (count <= 0) {
                    fileComplete = true;
                    continue;
                }
                bufferedOut.write(data, 0, count);
            }
        }
        catch (MalformedURLException e) {
            WgetStatus wgetStatus = WgetStatus.MalformedUrl;
            return wgetStatus;
        }
        catch (IOException e) {
            WgetStatus wgetStatus = WgetStatus.IoException;
            return wgetStatus;
        }
        finally {
            try {
                bufferedOut.close();
                fileOutput.close();
                ((InputStream)httpIn).close();
            }
            catch (IOException e) {
                return WgetStatus.UnableToCloseOutputStream;
            }
        }
        return WgetStatus.DownloadedSuccessfully;
    }

    public static String load(String url2) {
        return Web.load(url2, false);
    }

    public static String load(String url2, boolean isOverwrite) {
        return Web.load(url2, Web.getCurrentPath() + fSep + "lib" + fSep + "user", isOverwrite);
    }

    public static String load(String url2, String dir, boolean isOverwrite) {
        if (!url2.toLowerCase().endsWith(".jar")) {
            System.err.println("The input file is not a jar file and cannot be loaded");
            return WgetStatus.MalformedUrl.toString();
        }
        String fileName = dir + fSep + url2.substring(url2.lastIndexOf(47) + 1, url2.length());
        WgetStatus status = Web.get(url2, fileName, isOverwrite);
        try {
            Web.loadLibrary(new File(fileName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String out = status.toString() + " " + fileName;
        return out;
    }

    public static synchronized void loadLibrary(File jar) throws IOException {
        try {
            URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            URL url = jar.toURI().toURL();
            for (URL it : Arrays.asList(loader.getURLs())) {
                if (!it.equals(url)) continue;
                return;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)loader, url);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            throw new IOException(e);
        }
    }

    public static String getCurrentPath() {
        String DirPath = System.getProperty("jehep.home");
        if (DirPath == null) {
            try {
                DirPath = Web.getJarContainingFolder(Web.class);
                DirPath = DirPath.replace(fSep + "lib" + fSep + "system", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (DirPath == null) {
                Path currentRelativePath = Paths.get("", new String[0]);
                DirPath = currentRelativePath.toAbsolutePath().toString();
                DirPath = DirPath.replace(fSep + "lib" + fSep + "system", "");
            }
        }
        return DirPath;
    }

    private static String getJarContainingFolder(Class aclass) throws Exception {
        File jarFile;
        CodeSource codeSource = aclass.getProtectionDomain().getCodeSource();
        if (codeSource.getLocation() != null) {
            jarFile = new File(codeSource.getLocation().toURI());
        } else {
            String path = aclass.getResource(aclass.getSimpleName() + ".class").getPath();
            String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
            jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
            jarFile = new File(jarFilePath);
        }
        return jarFile.getParentFile().getAbsolutePath();
    }

    static enum WgetStatus {
        DownloadedSuccessfully,
        MalformedUrl,
        IoException,
        UnableToCloseOutputStream,
        AlreadyExists;

    }
}

