/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAxis;
import hep.aida.ref.histogram.Histogram1D;
import java.util.Arrays;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.P3D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.gui.HelpBrowser;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;

public class VHolder {
    private String title;
    private String[] names;
    private Double[][] data;
    private int nrows = 0;
    private int ncols = 0;

    public VHolder() {
    }

    public VHolder(H1D hh) {
        Histogram1D h1 = hh.get();
        IAxis axis = h1.axis();
        this.data = new Double[axis.bins()][6];
        this.names = new String[]{"Bin", "Bin min", "Bin max", "Mean", "Height", "Error"};
        this.nrows = axis.bins();
        this.ncols = this.names.length;
        for (int i = 0; i < this.nrows; ++i) {
            double x2 = h1.binMean(i);
            double x3 = axis.binLowerEdge(i);
            double x4 = axis.binUpperEdge(i);
            double x5 = h1.binHeight(i);
            double x6 = h1.binError(i);
            this.data[i][0] = x2;
            this.data[i][1] = x3;
            this.data[i][2] = x4;
            this.data[i][3] = x2;
            this.data[i][4] = x5;
            this.data[i][5] = x6;
        }
    }

    public VHolder(F1D ff) {
        ff.eval();
        this.title = "F1D: " + ff.getTitle();
        this.data = new Double[ff.getPoints()][3];
        this.names = new String[]{"Bin", "X", "Y"};
        this.nrows = ff.getPoints();
        this.ncols = this.names.length;
        for (int i = 0; i < this.nrows; ++i) {
            double x2 = ff.getX(i);
            double x3 = ff.getY(i);
            this.data[i][0] = i + 1;
            this.data[i][1] = x2;
            this.data[i][2] = x3;
        }
    }

    public VHolder(DataHolder dh) {
        int i;
        this.title = dh.getRelation();
        this.data = new Double[dh.getSize()][dh.getDimention() + 1];
        this.names = new String[dh.getDimention() + 1];
        this.nrows = dh.getSize();
        this.names[0] = "No";
        for (i = 0; i < dh.getDimention(); ++i) {
            if (dh.getName(i) != null) {
                this.names[i + 1] = dh.getName(i);
            }
            if (dh.getName(i) != null) continue;
            this.names[i + 1] = Integer.toString(i);
        }
        this.ncols = this.names.length;
        for (i = 0; i < dh.getSize(); ++i) {
            DataPoint dp = dh.getRow(i);
            this.data[i][0] = i + 1;
            for (int j = 0; j < dh.getDimention(); ++j) {
                double x = dp.getAttribute(j);
                this.data[i][j + 1] = x;
            }
        }
    }

    public VHolder(PND hh) {
        this.title = "PND: " + hh.getTitle();
        int ntot = hh.getDimension();
        this.names = new String[ntot + 1];
        this.data = new Double[hh.size()][ntot + 1];
        this.names[0] = "No";
        for (int j = 0; j < ntot; ++j) {
            String x;
            this.names[j + 1] = x = "c" + Integer.toString(j + 1);
        }
        this.nrows = hh.size();
        this.ncols = this.names.length;
        for (int i = 0; i < hh.size(); ++i) {
            double[] a = hh.get(i);
            this.data[i][0] = i + 1;
            for (int k = 0; k < a.length; ++k) {
                this.data[i][k + 1] = a[k];
            }
        }
    }

    public VHolder(PNI hh) {
        this.title = "PNI: " + hh.getTitle();
        int ntot = hh.getDimension();
        this.names = new String[ntot + 1];
        this.data = new Double[hh.size()][ntot + 1];
        this.names[0] = "No";
        for (int j = 0; j < ntot; ++j) {
            String x;
            this.names[j + 1] = x = "c" + Integer.toString(j + 1);
        }
        this.nrows = hh.size();
        this.ncols = this.names.length;
        for (int i = 0; i < hh.size(); ++i) {
            int[] a = hh.get(i);
            this.data[i][0] = i + 1;
            for (int k = 0; k < a.length; ++k) {
                this.data[i][k + 1] = a[k];
            }
        }
    }

    public VHolder(P1D hh) {
        this.title = "P1D: " + hh.getTitle();
        if (hh.dimension() == 2) {
            this.data = new Double[hh.size()][hh.dimension() + 1];
            this.names = new String[]{"No", "x", "y"};
            this.nrows = hh.size();
            this.ncols = this.names.length;
            for (int i = 0; i < this.nrows; ++i) {
                int x1 = i + 1;
                this.data[i][0] = x1;
                this.data[i][1] = hh.getX(i);
                this.data[i][2] = hh.getY(i);
            }
            return;
        }
        if (hh.dimension() == 3) {
            this.data = new Double[hh.size()][hh.dimension() + 1];
            this.names = new String[]{"No", "x", "y", "errY"};
            this.nrows = hh.size();
            this.ncols = this.names.length;
            for (int i = 0; i < this.nrows; ++i) {
                int x1 = i + 1;
                this.data[i][0] = x1;
                this.data[i][1] = hh.getX(i);
                this.data[i][2] = hh.getY(i);
                this.data[i][3] = hh.getYupper(i);
            }
            return;
        }
        if (hh.dimension() == 4) {
            this.data = new Double[hh.size()][hh.dimension() + 1];
            this.names = new String[]{"No", "x", "y", "errY Up", "errY Low"};
            this.nrows = hh.size();
            this.ncols = this.names.length;
            for (int i = 0; i < this.nrows; ++i) {
                int x1 = i + 1;
                this.data[i][0] = x1;
                this.data[i][1] = hh.getX(i);
                this.data[i][2] = hh.getY(i);
                this.data[i][3] = hh.getYupper(i);
                this.data[i][4] = hh.getYlower(i);
            }
            return;
        }
        if (hh.dimension() == 6) {
            this.data = new Double[hh.size()][hh.dimension() + 1];
            this.names = new String[]{"No", "x", "y", "errX Left", "errX right", "errY Up", "errY Low"};
            this.nrows = hh.size();
            this.ncols = this.names.length;
            for (int i = 0; i < this.nrows; ++i) {
                int x1 = i + 1;
                this.data[i][0] = x1;
                this.data[i][1] = hh.getX(i);
                this.data[i][2] = hh.getY(i);
                this.data[i][3] = hh.getXleft(i);
                this.data[i][4] = hh.getXright(i);
                this.data[i][5] = hh.getYupper(i);
                this.data[i][6] = hh.getYlower(i);
            }
            return;
        }
        if (hh.dimension() == 10) {
            this.data = new Double[hh.size()][hh.dimension() + 1];
            this.names = new String[]{"No", "x", "y", "errX Left", "errX right", "errY Up", "errY Low", "errX(sys) Left", "errX(sys) right", "errY(sys) Up", "errY(sys) Low"};
            this.nrows = hh.size();
            this.ncols = this.names.length;
            for (int i = 0; i < this.nrows; ++i) {
                int x1 = i + 1;
                this.data[i][0] = x1;
                this.data[i][1] = hh.getX(i);
                this.data[i][2] = hh.getY(i);
                this.data[i][3] = hh.getXleft(i);
                this.data[i][4] = hh.getXright(i);
                this.data[i][5] = hh.getYupper(i);
                this.data[i][6] = hh.getYlower(i);
                this.data[i][7] = hh.getXleftSys(i);
                this.data[i][8] = hh.getXrightSys(i);
                this.data[i][9] = hh.getYupperSys(i);
                this.data[i][10] = hh.getYlowerSys(i);
            }
            return;
        }
    }

    public VHolder(P2D hh) {
        this.title = "P2D: " + hh.getTitle();
        this.data = new Double[hh.size()][4];
        this.names = new String[]{"No", "x", "y", "z"};
        this.nrows = hh.size();
        this.ncols = this.names.length;
        for (int i = 0; i < hh.size(); ++i) {
            int x1 = i + 1;
            double x2 = hh.getX(i);
            double x3 = hh.getY(i);
            double x4 = hh.getZ(i);
            this.data[i][0] = x1;
            this.data[i][1] = x2;
            this.data[i][2] = x3;
            this.data[i][3] = x4;
        }
    }

    public VHolder(P0D hh) {
        this.data = new Double[hh.size()][2];
        this.names = new String[]{"No", "value"};
        this.title = "P0D: " + hh.getTitle();
        this.nrows = hh.size();
        this.ncols = this.names.length;
        for (int i = 0; i < hh.size(); ++i) {
            int x1 = i + 1;
            double x2 = hh.get(i);
            this.data[i][0] = x1;
            this.data[i][1] = x2;
        }
    }

    public VHolder(P0I hh) {
        this.data = new Double[hh.size()][2];
        this.names = new String[]{"No", "value"};
        this.title = "P0D: " + hh.getTitle();
        this.nrows = hh.size();
        this.ncols = this.names.length;
        for (int i = 0; i < hh.size(); ++i) {
            int x1 = i + 1;
            double x2 = hh.get(i);
            this.data[i][0] = x1;
            this.data[i][1] = x2;
        }
    }

    public VHolder(P3D hh) {
        this.names = new String[]{"No", "x", "dx", "y", "dy", "z", "dz"};
        this.data = new Double[hh.size()][7];
        this.title = "P3D: " + hh.getTitle();
        this.nrows = hh.size();
        this.ncols = this.names.length;
        for (int i = 0; i < hh.size(); ++i) {
            int x1 = i + 1;
            double x2 = hh.getX(i);
            double x3 = hh.getY(i);
            double x4 = hh.getZ(i);
            double dx2 = hh.getDX(i);
            double dx3 = hh.getDY(i);
            double dx4 = hh.getDZ(i);
            this.data[i][0] = x1;
            this.data[i][1] = x2;
            this.data[i][2] = dx2;
            this.data[i][3] = x3;
            this.data[i][4] = dx3;
            this.data[i][5] = x4;
            this.data[i][6] = dx4;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getNames() {
        return this.names;
    }

    public Double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.nrows = data.length;
        this.ncols = data[0].length;
        this.title = "1d array";
        this.names = new String[this.ncols];
        this.data = new Double[data.length][data[0].length];
        for (int row = 0; row < data.length; ++row) {
            this.names[row] = Integer.toString(row);
            for (int col = 0; col < data[0].length; ++col) {
                this.data[row][col] = data[row][col];
            }
        }
    }

    public void setData(double[] data) {
        this.nrows = data.length;
        this.ncols = 1;
        this.title = "1d array";
        this.names = new String[this.ncols];
        this.data = new Double[data.length][0];
        for (int row = 0; row < data.length; ++row) {
            this.names[row] = Integer.toString(row);
            this.data[row][0] = data[row];
        }
    }

    public String toString() {
        String s = "names=" + Arrays.deepToString(this.names);
        s = s + " data=" + Arrays.deepToString((Object[])this.data);
        return s;
    }

    public void setData(Double[][] data) {
        this.data = data;
    }

    public int dimen() {
        return this.ncols;
    }

    public int size() {
        return this.nrows;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

