/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import com.edsdev.jconvert.domain.Conversion;
import com.edsdev.jconvert.domain.ConversionType;
import com.edsdev.jconvert.persistence.DataLoader;
import com.edsdev.jconvert.presentation.ConversionTypeData;
import java.util.Iterator;
import java.util.List;

public class UConverter {
    private List<ConversionType> domainData = new DataLoader().loadData();
    private ConversionTypeData ctd;

    public UConverter() {
    }

    public UConverter(String type) {
        this.setConversionType(type);
    }

    public double convert(double value, String fromUnit, String toUnit) {
        return this.ctd.convert(value, fromUnit, toUnit);
    }

    public String toString() {
        Iterator<ConversionType> iter = this.domainData.iterator();
        String s = "";
        while (iter.hasNext()) {
            ConversionType type = iter.next();
            s = s + type.getTypeName() + " - " + type.getConversions().size() + " conversions\n";
        }
        return s;
    }

    public String[] getTypes() {
        String[] s = new String[this.domainData.size()];
        Iterator<ConversionType> iter = this.domainData.iterator();
        int j = 0;
        while (iter.hasNext()) {
            ConversionType type = iter.next();
            s[j] = type.getTypeName();
            ++j;
        }
        return s;
    }

    public ConversionType findType(String conversionUnit) {
        for (ConversionType type : this.domainData) {
            for (Conversion conv : type.getConversions()) {
                if (!conv.getFromUnit().equals(conversionUnit) && !conv.getToUnit().equals(conversionUnit)) continue;
                return type;
            }
        }
        return null;
    }

    public ConversionTypeData getConversionType(String conversionType) {
        for (ConversionType type : this.domainData) {
            if (!type.getTypeName().equals(conversionType)) continue;
            this.ctd = new ConversionTypeData(type);
            break;
        }
        return this.ctd;
    }

    public void setConversionType(String conversionType) {
        for (ConversionType type : this.domainData) {
            if (!type.getTypeName().equals(conversionType)) continue;
            this.ctd = new ConversionTypeData(type);
            break;
        }
    }

    public List<ConversionType> getDomanData() {
        return this.domainData;
    }

    public ConversionTypeData getConversionType() {
        return this.ctd;
    }
}

