/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;

public class IO {
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 4096;
    private static String match = "";
    private static ArrayList<String> myArr;
    private static boolean doMatch;
    private static Pattern pattern;

    public static String unzip(String zipFilePath, String destDirectory) throws IOException {
        String tmp = "Error unziping: " + zipFilePath;
        try {
            int nn = IO.unzipFile(zipFilePath, destDirectory);
            tmp = "-> Input zip file:" + zipFilePath + "\n";
            tmp = tmp + "-> Successfully unziped " + Integer.toString(nn) + " files to " + destDirectory;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public static String unzip(String zipFilePath) throws IOException {
        String tmp = "Error unziping " + zipFilePath;
        try {
            File ff = new File(zipFilePath);
            String dir = ff.getAbsoluteFile().getParent();
            int nn = IO.unzipFile(zipFilePath, dir);
            tmp = "-> Input zip file:" + zipFilePath + "\n";
            tmp = tmp + "-> Successfully unziped " + Integer.toString(nn) + " files to " + dir;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public static int write(Object o, String name, boolean compressed) {
        try {
            FileOutputStream outFile = new FileOutputStream(name);
            ObjectOutputStream outStream = compressed ? new ObjectOutputStream(new GZIPOutputStream(outFile)) : new ObjectOutputStream(outFile);
            outStream.writeObject(o);
            outStream.close();
            outFile.close();
        }
        catch (FileNotFoundException e) {
            IO.ErrorMessage(e.toString());
            return 2;
        }
        catch (IOException e) {
            IO.ErrorMessage(e.toString());
            return 1;
        }
        return 0;
    }

    public static int write(Object o, String name) {
        return IO.write(o, name, true);
    }

    public static int writeXML(Object o, String name) {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            ObjectOutputStream out = xstream.createObjectOutputStream((OutputStream)new FileOutputStream(name));
            out.writeObject(o);
            out.close();
        }
        catch (IOException e) {
            IO.ErrorMessage(e.toString());
            return 1;
        }
        return 0;
    }

    private static Object read(String sfile, boolean compressed) {
        if ((sfile = sfile.trim()).startsWith("http") || sfile.startsWith("ftp")) {
            try {
                return IO.read(new URL(sfile), compressed);
            }
            catch (MalformedURLException e) {
                IO.ErrorMessage(e.toString());
            }
        } else {
            return IO.read(new File(sfile), compressed);
        }
        return null;
    }

    public static Object read(File file, boolean compressed) {
        Object p0 = null;
        try {
            FileInputStream fileIn = new FileInputStream(file);
            ObjectInputStream in = compressed ? new ObjectInputStream(new GZIPInputStream(fileIn)) : new ObjectInputStream(fileIn);
            p0 = in.readObject();
            in.close();
            fileIn.close();
        }
        catch (ClassNotFoundException e) {
            IO.ErrorMessage(e.toString());
        }
        catch (FileNotFoundException e) {
            IO.ErrorMessage(e.toString());
        }
        catch (IOException e) {
            IO.ErrorMessage(e.toString());
        }
        return p0;
    }

    public static Object read(URL url, boolean compressed) {
        Object p0 = null;
        try {
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            ObjectInputStream in = compressed ? new ObjectInputStream(new GZIPInputStream(urlConn.getInputStream())) : new ObjectInputStream(urlConn.getInputStream());
            p0 = in.readObject();
            in.close();
        }
        catch (ClassNotFoundException e) {
            IO.ErrorMessage(e.toString());
        }
        catch (IOException e) {
            IO.ErrorMessage(e.toString());
        }
        return p0;
    }

    public static Object read(String name) {
        return IO.read(name, true);
    }

    public static Object readXML(String name) {
        Object p0 = null;
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            FileInputStream fileIn = new FileInputStream(name);
            ObjectInputStream ino = xstream.createObjectInputStream((InputStream)fileIn);
            try {
                p0 = ino.readObject();
            }
            catch (ClassNotFoundException e) {
                IO.ErrorMessage(e.toString());
                return 2;
            }
            ino.close();
        }
        catch (IOException e) {
            IO.ErrorMessage(e.toString());
            return 1;
        }
        return p0;
    }

    public static String toXML(Object ob) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        String xml = xstream.toXML(ob);
        return xml;
    }

    public static Object fromXML(String xml) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        return xstream.fromXML(xml);
    }

    private static void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    private static int unzipFile(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        int ntot = 0;
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                IO.extractFile(zipIn, filePath);
                ++ntot;
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        return ntot;
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public static ArrayList getFileList(String dir, String m) {
        match = m.trim();
        if (match.length() > 0) {
            doMatch = true;
            pattern = Pattern.compile(m);
        }
        myArr = new ArrayList();
        IO.traverse(new File(dir));
        return myArr;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    private static void processFile(File dir) {
        if (!dir.isDirectory()) {
            String sdir = dir.toString();
            if (doMatch) {
                Matcher matcher = pattern.matcher(sdir);
                boolean matchFound = matcher.find();
                if (matchFound) {
                    myArr.add(sdir);
                }
            } else {
                myArr.add(sdir);
            }
        }
    }

    private static void traverse(File dir) {
        IO.processFile(dir);
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                IO.traverse(new File(dir, children[i]));
            }
        }
    }

    static {
        doMatch = false;
    }
}

