/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.ref.histogram.Histogram2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jhplot.F2D;
import jhplot.H2D;
import jhplot.JHPlot;
import jhplot.P2D;
import jhplot.gui.CommonGUI;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.utils.HelpDialog;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.ContourChart;
import org.jzy3d.chart.controllers.mouse.camera.NewtCameraMouseController;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.chart.factories.AWTChartComponentFactory;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.contour.DefaultContourColoringPolicy;
import org.jzy3d.contour.IContourColoringPolicy;
import org.jzy3d.contour.MapperContourMeshGenerator;
import org.jzy3d.contour.MapperContourPictureGenerator;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalGrid;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Disk;
import org.jzy3d.plot3d.primitives.FlatLine2d;
import org.jzy3d.plot3d.primitives.HistogramBar;
import org.jzy3d.plot3d.primitives.Parallelepiped;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Scatter;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.primitives.Tube;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.ContourAxeBox;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.DefaultDecimalTickRenderer;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ScientificNotationTickRenderer;
import org.jzy3d.plot3d.primitives.contour.ContourMesh;
import org.jzy3d.plot3d.primitives.enlightables.EnlightableSphere;
import org.jzy3d.plot3d.rendering.canvas.CanvasNewtAwt;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.legends.colorbars.AWTColorbarLegend;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.text.drawable.DrawableTextBitmap;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class HPlotXYZ
extends GHFrame {
    private static final long serialVersionUID = 1L;
    public boolean set = true;
    private static int lightId = 0;
    private Chart[][] jpp;
    protected static int Nframe = 0;
    protected static int isOpen = 0;
    protected ArrayList<AbstractDrawable>[][] datalist;
    private final String help_file = "hplotxyz";
    private boolean currentWiredrame = true;
    private org.jzy3d.colors.Color currentFillColor = org.jzy3d.colors.Color.GREEN;
    private org.jzy3d.colors.Color currentWiredColor = org.jzy3d.colors.Color.BLACK;
    private float currentWiredWidth = 1.0f;
    private boolean solidColor = false;
    private boolean m_setContourMesh3D = false;
    private boolean m_setContourColor3D = false;
    private int xsize;
    private int ysize;
    private boolean first = true;
    private int dig = 2;
    private boolean showLegentBar = false;
    private int nlevels = 10;
    private int fontTick = 6;
    private int fontAxisTitles = 8;

    public HPlotXYZ(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set, 1);
        this.xsize = xsize;
        this.ysize = ysize;
        this.datalist = new ArrayList[this.N1final][this.N2final];
        this.jpp = new Chart[this.N1final][this.N2final];
        Nframe = 0;
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.datalist[i1][i2] = new ArrayList();
                AWTChartComponentFactory accf = new AWTChartComponentFactory();
                this.jpp[i1][i2] = accf.newChart(Quality.Advanced, IChartComponentFactory.Toolkit.newt.name());
                NewtCameraMouseController ctc = new NewtCameraMouseController(this.jpp[i1][i2]);
                BoundingBox3d b = new BoundingBox3d(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
                AxeBox ax = new AxeBox(b);
                this.jpp[i1][i2].getView().setAxe((IAxe)ax);
                if (this.N2final * this.N1final == 2) {
                    this.jpp[i1][i2].getView().getCamera().setScale(0.8f);
                }
                if (this.N2final * this.N1final == 3) {
                    this.jpp[i1][i2].getView().getCamera().setScale(0.6f);
                }
                if (this.N2final * this.N1final > 3) {
                    this.jpp[i1][i2].getView().getCamera().setScale(0.5f);
                }
                if (set) {
                    this.mainPanel.add((Component)((CanvasNewtAwt)this.jpp[i1][i2].getCanvas()));
                }
                ++Nframe;
            }
        }
    }

    public void setRange(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        BoundingBox3d b = new BoundingBox3d((float)minX, (float)maxX, (float)minY, (float)maxY, (float)minZ, (float)maxZ);
        this.jpp[N1][N2].getView().getAxe().setAxe(b);
    }

    public void setFontAxisTicks(int font) {
        AxeBox axe = (AxeBox)this.jpp[N1][N2].getView().getAxe();
        TextBitmapRenderer spp = (TextBitmapRenderer)axe.getTextRenderer();
        spp.setFontAxisTicks(font);
    }

    public void setAxisPenWidth(int pwidth) {
        AxeBox axe = (AxeBox)this.jpp[N1][N2].getView().getAxe();
        axe.setLineWidth(pwidth);
    }

    public int getFontAxisTicks() {
        AxeBox axe = (AxeBox)this.jpp[N1][N2].getView().getAxe();
        TextBitmapRenderer spp = (TextBitmapRenderer)axe.getTextRenderer();
        return spp.getFontAxisTicks();
    }

    public int getFontAxisLabels() {
        AxeBox axe = (AxeBox)this.jpp[N1][N2].getView().getAxe();
        TextBitmapRenderer spp = (TextBitmapRenderer)axe.getTextRenderer();
        return spp.getFontAxisLabels();
    }

    public HPlotXYZ(String title, int xsize, int ysize, int n1, int n2) {
        this(title, xsize, ysize, n1, n2, true);
    }

    @Override
    protected void clearFrame() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void refreshFrame() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    private org.jzy3d.colors.Color getColor(Color c) {
        return new org.jzy3d.colors.Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public CameraThreadController animate() {
        CameraThreadController s = new CameraThreadController(this.jpp[N1][N2]);
        s.start();
        return s;
    }

    public void setColorFill(Color color) {
        this.currentFillColor = this.getColor(color);
    }

    public void setColorWireframe(Color color) {
        this.currentWiredColor = this.getColor(color);
    }

    public void setWireframe(boolean wiredrame) {
        this.currentWiredrame = wiredrame;
    }

    public void setWireframeWidth(double width) {
        this.currentWiredWidth = (float)width;
    }

    public void setColorSolid(boolean solid) {
        this.solidColor = solid;
    }

    public View getView() {
        return this.jpp[N1][N2].getView();
    }

    public void setScale(double scale) {
        this.jpp[N1][N2].getView().getCamera().setScale((float)scale);
        this.jpp[N1][N2].getView().updateBounds();
    }

    public void zoom(double scale) {
        this.jpp[N1][N2].getView().zoom((float)scale);
    }

    public void setRotationAngle(double angle) {
    }

    public void setFaceDisplayed(boolean face) {
        this.jpp[N1][N2].getView().getAxe().getLayout().setFaceDisplayed(face);
    }

    public void setGridColor(Color co) {
        int color = co.getRGB();
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        org.jzy3d.colors.Color c = new org.jzy3d.colors.Color(red, green, blue, alpha);
        this.jpp[N1][N2].getView().getAxe().getLayout().setGridColor(c);
    }

    private void showIt() {
        this.updateAll();
        this.mainFrame.setVisible(true);
    }

    public void visible(int posX, int posY) {
        this.updateAll();
        this.mainFrame.setLocation(posX, posY);
        this.mainFrame.setVisible(true);
    }

    public HPlotXYZ(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public HPlotXYZ(String title) {
        this(title, 600, 600, 1, 1, true);
    }

    public HPlotXYZ() {
        this("Default", 600, 600, 1, 1, true);
    }

    public void clear() {
        this.jpp[N1][N2].clear();
    }

    public void clear(int i1, int i2) {
        this.jpp[i1][i2].clear();
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    public void distroy() {
        this.mainFrame.setVisible(false);
        this.close();
        this.removeFrame();
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAll();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.jpp[i1][i2].clear();
                this.jpp[i1][i2].dispose();
                this.jpp[i1][i2] = null;
            }
        }
        this.jpp = null;
        this.removeFrame();
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.mainFrame.setVisible(false);
            this.mainFrame.validate();
        }
        if (vs) {
            this.showIt();
        }
    }

    public void visible() {
        this.visible(true);
    }

    public void setNameX(String a) {
        this.jpp[N1][N2].getAxeLayout().setXAxeLabel(a);
    }

    public void setNameY(String a) {
        this.jpp[N1][N2].getAxeLayout().setYAxeLabel(a);
    }

    public void setNameZ(String a) {
        this.jpp[N1][N2].getAxeLayout().setZAxeLabel(a);
    }

    public void setAxesLabel(int axis, boolean shown) {
        if (axis == 0) {
            this.jpp[N1][N2].getAxeLayout().setXAxeLabelDisplayed(shown);
        }
        if (axis == 1) {
            this.jpp[N1][N2].getAxeLayout().setYAxeLabelDisplayed(shown);
        }
        if (axis == 2) {
            this.jpp[N1][N2].getAxeLayout().setZAxeLabelDisplayed(shown);
        }
    }

    public void setViewPoint(double x, double y, double z) {
        this.jpp[N1][N2].setViewPoint(new Coord3d(x, y, z));
    }

    public void setAxesLabelFont(Font font, org.jzy3d.colors.Color color) {
    }

    public void setContourMesh3D(boolean contour) {
        this.m_setContourMesh3D = contour;
    }

    public void setContourColor3D(boolean contour) {
        this.m_setContourColor3D = contour;
    }

    public void setContourLevels(int nlevels) {
        this.nlevels = nlevels;
    }

    public int getContourLevels() {
        return this.nlevels;
    }

    public void setContourMesh3D() {
        this.setContourMesh3D(true);
    }

    public void setContourColor3D() {
        this.setContourColor3D(true);
    }

    public boolean getContourMesh3D() {
        return this.m_setContourMesh3D;
    }

    public void setAxisTick(int axis, boolean shown) {
        if (axis == 0) {
            this.jpp[N1][N2].getAxeLayout().setXTickLabelDisplayed(shown);
        }
        if (axis == 1) {
            this.jpp[N1][N2].getAxeLayout().setYTickLabelDisplayed(shown);
        }
        if (axis == 2) {
            this.jpp[N1][N2].getAxeLayout().setZTickLabelDisplayed(shown);
        }
    }

    public void add(P2D h1) {
        this.add(h1, 1.0, Color.black);
    }

    public AbstractDrawable add(P2D h1, Color color) {
        return this.add(h1, 1.0, color);
    }

    public AbstractDrawable add(P2D h1, double pointSize) {
        return this.add(h1, pointSize, Color.black);
    }

    public AbstractDrawable draw(P2D h1, double penSize, Color color) {
        int size = h1.size();
        Coord3d[] points = new Coord3d[size];
        org.jzy3d.colors.Color[] colors = new org.jzy3d.colors.Color[size];
        for (int i = 0; i < size; ++i) {
            double x = h1.getX(i);
            double y = h1.getY(i);
            double z = h1.getZ(i);
            points[i] = new Coord3d(x, y, z);
            double a = 0.25f + (float)(points[i].distance(Coord3d.ORIGIN) / Math.sqrt(1.3)) / 2.0f;
            colors[i] = new org.jzy3d.colors.Color((float)x, (float)y, (float)z, (float)a);
        }
        Scatter scatter = new Scatter(points);
        scatter.setColor(this.getColor(color));
        scatter.setWidth((float)penSize);
        this.jpp[N1][N2].getScene().getGraph().add((AbstractDrawable)scatter);
        return scatter;
    }

    public AbstractDrawable add(P2D h1, double penSize, Color color) {
        int size = h1.size();
        Coord3d[] points = new Coord3d[size];
        for (int i = 0; i < size; ++i) {
            double x = h1.getX(i);
            double y = h1.getY(i);
            double z = h1.getZ(i);
            points[i] = new Coord3d(x, y, z);
        }
        Scatter scatter = new Scatter(points);
        scatter = new Scatter(points);
        scatter.setColor(this.getColor(color));
        scatter.setWidth((float)penSize);
        this.datalist[N1][N2].add((AbstractDrawable)scatter);
        return scatter;
    }

    public AbstractDrawable add(AbstractDrawable shape) {
        this.datalist[N1][N2].add(shape);
        return shape;
    }

    public void draw(AbstractDrawable[] shapes) {
        for (int i1 = 0; i1 < shapes.length; ++i1) {
            this.jpp[N1][N2].getScene().getGraph().add(shapes[i1]);
        }
    }

    public void update() {
        this.update(N1, N2);
    }

    public void update(int n1, int n2) {
        if (this.showLegentBar) {
            Shape s = (Shape)this.datalist[n1][n2].get(0);
            AWTColorbarLegend cbar = new AWTColorbarLegend((AbstractDrawable)s, this.jpp[n1][n2].getView().getAxe().getLayout());
            s.setLegend((ILegend)cbar);
        }
        this.jpp[n1][n2].getScene().getGraph().add(this.datalist[n1][n2]);
        if (this.set && (this.m_setContourMesh3D || this.m_setContourColor3D)) {
            this.getFrame().setContentPane((Container)((CanvasNewtAwt)this.jpp[n1][n2].getCanvas()));
            SwingUtilities.updateComponentTreeUI(this.getFrame());
        }
    }

    public void updateAll() {
    }

    public AbstractDrawable addText(String text, double[] pos, Color co) {
        int color = co.getRGB();
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        org.jzy3d.colors.Color c = new org.jzy3d.colors.Color(red, green, blue, alpha);
        DrawableTextBitmap t4 = new DrawableTextBitmap(text, new Coord3d(pos[0], pos[1], pos[2]), c);
        this.datalist[N1][N2].add((AbstractDrawable)t4);
        return t4;
    }

    public AbstractDrawable add(F2D f) {
        return this.add(f, 40, 40, f.getMinX(), f.getMaxX(), f.getMinY(), f.getMaxY());
    }

    public AbstractDrawable add(F2D f, double xmin, double xmax, double ymin, double ymax) {
        return this.add(f, 40, 40, xmin, xmax, ymin, ymax);
    }

    public AbstractDrawable add(final F2D h1, int xsteps, int ysteps, double xmin, double xmax, double ymin, double ymax) {
        NewtCameraMouseController ctc;
        ContourAxeBox cab;
        ContourChart chart;
        MapperContourMeshGenerator contour;
        if (h1.getLabelX() != null && h1.getLabelX().length() > 1) {
            this.setNameX(h1.getLabelX());
        }
        if (h1.getLabelY() != null && h1.getLabelY().length() > 1) {
            this.setNameY(h1.getLabelY());
        }
        Mapper mapper = new Mapper(){

            public double f(double x, double y) {
                return h1.eval(x, y);
            }
        };
        Range xrange = new Range((float)xmin, (float)xmax);
        Range yrange = new Range((float)ymin, (float)ymax);
        Shape surface = Builder.buildOrthonormal((OrthonormalGrid)new OrthonormalGrid(xrange, xsteps, yrange, ysteps), (Mapper)mapper);
        surface.setColor(this.currentFillColor);
        surface.setWireframeDisplayed(this.currentWiredrame);
        surface.setWireframeColor(this.currentWiredColor);
        surface.setWireframeWidth(this.currentWiredWidth);
        ColorMapper myColorMapper = null;
        if (!this.solidColor) {
            myColorMapper = new ColorMapper((IColorMap)new ColorMapRainbow(), (double)surface.getBounds().getZmin(), (double)surface.getBounds().getZmax(), new org.jzy3d.colors.Color(1.0f, 1.0f, 1.0f, 0.5f));
            surface.setColorMapper(myColorMapper);
        }
        if (this.m_setContourMesh3D) {
            contour = new MapperContourMeshGenerator(mapper, xrange, yrange);
            chart = new ContourChart(Quality.Advanced, IChartComponentFactory.Toolkit.newt.name());
            cab = (ContourAxeBox)chart.getView().getAxe();
            ContourMesh mesh = contour.getContourMesh((IContourColoringPolicy)new DefaultContourColoringPolicy(myColorMapper), this.xsize, this.ysize, this.nlevels, 0.0f, false);
            cab.setContourMesh(mesh);
            ctc = new NewtCameraMouseController((Chart)chart);
            chart.getScene().getGraph().add((AbstractDrawable)surface);
            this.jpp[HPlotXYZ.N1][HPlotXYZ.N2] = chart;
        }
        if (this.m_setContourColor3D) {
            contour = new MapperContourPictureGenerator(mapper, xrange, yrange);
            chart = new ContourChart(Quality.Advanced, IChartComponentFactory.Toolkit.newt.name());
            cab = (ContourAxeBox)chart.getView().getAxe();
            BufferedImage contourImage = contour.getFilledContourImage((IContourColoringPolicy)new DefaultContourColoringPolicy(myColorMapper), this.xsize, this.ysize, this.nlevels);
            cab.setContourImg(contourImage, xrange, yrange);
            ctc = new NewtCameraMouseController((Chart)chart);
            chart.getScene().getGraph().add((AbstractDrawable)surface);
            this.jpp[HPlotXYZ.N1][HPlotXYZ.N2] = chart;
        }
        this.datalist[N1][N2].add((AbstractDrawable)surface);
        return surface;
    }

    public AbstractDrawable addAsSurface(final H2D h2d) {
        NewtCameraMouseController ctc;
        ContourAxeBox cab;
        ContourChart chart;
        MapperContourMeshGenerator contour;
        Histogram2D h1 = h2d.get();
        Mapper mapper = new Mapper(){

            public double f(double x, double y) {
                int ix = h2d.findBinX(x);
                int iy = h2d.findBinY(y);
                return h2d.binHeight(ix, iy);
            }
        };
        int xsteps = h1.xAxis().bins();
        int ysteps = h1.yAxis().bins();
        Range xrange = new Range((float)h1.xAxis().lowerEdge(), (float)h1.xAxis().upperEdge());
        Range yrange = new Range((float)h1.yAxis().lowerEdge(), (float)h1.yAxis().upperEdge());
        Shape surface = Builder.buildOrthonormal((OrthonormalGrid)new OrthonormalGrid(xrange, xsteps, yrange, ysteps), (Mapper)mapper);
        surface.setColor(this.currentFillColor);
        surface.setWireframeDisplayed(this.currentWiredrame);
        surface.setWireframeColor(this.currentWiredColor);
        surface.setWireframeWidth(this.currentWiredWidth);
        ColorMapper myColorMapper = null;
        if (!this.solidColor) {
            myColorMapper = new ColorMapper((IColorMap)new ColorMapRainbow(), (double)surface.getBounds().getZmin(), (double)surface.getBounds().getZmax(), new org.jzy3d.colors.Color(1.0f, 1.0f, 1.0f, 0.7f));
            surface.setColorMapper(myColorMapper);
        }
        if (this.m_setContourMesh3D) {
            contour = new MapperContourMeshGenerator(mapper, xrange, yrange);
            chart = new ContourChart(Quality.Advanced, IChartComponentFactory.Toolkit.newt.name());
            cab = (ContourAxeBox)chart.getView().getAxe();
            ContourMesh mesh = contour.getContourMesh((IContourColoringPolicy)new DefaultContourColoringPolicy(myColorMapper), this.xsize, this.ysize, this.nlevels, 0.0f, false);
            cab.setContourMesh(mesh);
            ctc = new NewtCameraMouseController((Chart)chart);
            chart.getScene().getGraph().add((AbstractDrawable)surface);
            this.jpp[HPlotXYZ.N1][HPlotXYZ.N2] = chart;
        }
        if (this.m_setContourColor3D) {
            contour = new MapperContourPictureGenerator(mapper, xrange, yrange);
            chart = new ContourChart(Quality.Advanced, IChartComponentFactory.Toolkit.newt.name());
            cab = (ContourAxeBox)chart.getView().getAxe();
            BufferedImage contourImage = contour.getFilledContourImage((IContourColoringPolicy)new DefaultContourColoringPolicy(myColorMapper), this.xsize, this.ysize, this.nlevels);
            cab.setContourImg(contourImage, xrange, yrange);
            ctc = new NewtCameraMouseController((Chart)chart);
            chart.getScene().getGraph().add((AbstractDrawable)surface);
            this.jpp[HPlotXYZ.N1][HPlotXYZ.N2] = chart;
        }
        this.datalist[N1][N2].add((AbstractDrawable)surface);
        return surface;
    }

    public void add(H2D h2d) {
        this.addAsBars(h2d);
    }

    @Override
    public void export(String file) {
        if (!file.toLowerCase().endsWith(".png")) {
            JOptionPane.showMessageDialog(this.getFrame(), "Non PNG images are not supported by HPlotXYZ");
            return;
        }
        File image = new File(file);
        try {
            this.jpp[N1][N2].screenshot(image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addAsBars(H2D h2d) {
        Histogram2D h1 = h2d.get();
        int ibinsX = h1.xAxis().bins() + 2;
        int ibinsY = h1.yAxis().bins() + 2;
        int zmax = (int)h1.maxBinHeight();
        for (int i = 0; i < ibinsX - 1; ++i) {
            double x = h1.xAxis().binLowerEdge(i);
            double wx = h1.xAxis().binWidth(i);
            for (int j = 0; j < ibinsY - 1; ++j) {
                double y = h1.yAxis().binLowerEdge(j);
                double wy = h1.yAxis().binWidth(j);
                double h = h1.binHeight(i, j);
                Polygon[] pp = this.getSquareBar(x, wx, y, wy, h);
                for (int k = 0; k < pp.length; ++k) {
                    pp[k].setColor(this.currentFillColor);
                    pp[k].setWireframeDisplayed(this.currentWiredrame);
                    pp[k].setWireframeColor(this.currentWiredColor);
                    pp[k].setWireframeWidth(this.currentWiredWidth);
                    if (!this.solidColor) {
                        pp[k].setColorMapper(new ColorMapper((IColorMap)new ColorMapRainbow(), 0.0, (double)zmax, new org.jzy3d.colors.Color(1.0f, 1.0f, 1.0f, 0.8f)));
                    }
                    this.datalist[N1][N2].add((AbstractDrawable)pp[k]);
                }
            }
        }
    }

    public void setLegendBar() {
        this.showLegentBar = true;
    }

    public AbstractDrawable draw(final H2D h2d) {
        Histogram2D h1 = h2d.get();
        Mapper mapper = new Mapper(){

            public double f(double x, double y) {
                int ix = h2d.findBinX(x);
                int iy = h2d.findBinY(y);
                return h2d.binHeight(ix, iy);
            }
        };
        int xsteps = h1.xAxis().bins();
        int ysteps = h1.yAxis().bins();
        Range xrange = new Range((float)h1.xAxis().lowerEdge(), (float)h1.xAxis().upperEdge());
        Range yrange = new Range((float)h1.yAxis().lowerEdge(), (float)h1.yAxis().upperEdge());
        Shape surface = Builder.buildOrthonormal((OrthonormalGrid)new OrthonormalGrid(xrange, xsteps, yrange, ysteps), (Mapper)mapper);
        surface.setColorMapper(new ColorMapper((IColorMap)new ColorMapRainbow(), (double)surface.getBounds().getZmin(), (double)surface.getBounds().getZmax(), new org.jzy3d.colors.Color(1.0f, 1.0f, 1.0f, 0.5f)));
        surface.setFaceDisplayed(true);
        surface.setWireframeDisplayed(true);
        surface.setWireframeColor(org.jzy3d.colors.Color.BLACK);
        this.jpp[N1][N2].getScene().add((AbstractDrawable)surface);
        return surface;
    }

    public Chart getChart() {
        return this.jpp[N1][N2];
    }

    public void setBackground(Color co) {
        int color = co.getRGB();
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        org.jzy3d.colors.Color c = new org.jzy3d.colors.Color(red, green, blue, alpha);
        this.jpp[N1][N2].getView().setBackgroundColor(c);
    }

    public void setTickScientific(int axis, int dig) {
        this.dig = dig;
        if (axis == 0) {
            this.jpp[N1][N2].getAxeLayout().setXTickRenderer((ITickRenderer)new ScientificNotationTickRenderer(dig));
        }
        if (axis == 1) {
            this.jpp[N1][N2].getAxeLayout().setYTickRenderer((ITickRenderer)new ScientificNotationTickRenderer(dig));
        }
        if (axis == 2) {
            this.jpp[N1][N2].getAxeLayout().setZTickRenderer((ITickRenderer)new ScientificNotationTickRenderer(dig));
        }
    }

    public void setTickDecimal(int axis, int dig) {
        this.dig = dig;
        if (axis == 0) {
            this.jpp[N1][N2].getAxeLayout().setXTickRenderer((ITickRenderer)new DefaultDecimalTickRenderer(dig));
        }
        if (axis == 1) {
            this.jpp[N1][N2].getAxeLayout().setYTickRenderer((ITickRenderer)new DefaultDecimalTickRenderer(dig));
        }
        if (axis == 2) {
            this.jpp[N1][N2].getAxeLayout().setZTickRenderer((ITickRenderer)new DefaultDecimalTickRenderer(dig));
        }
    }

    public void setTickScientificAll(int dig) {
        this.setTickScientific(0, dig);
        this.setTickScientific(1, dig);
        this.setTickScientific(2, dig);
    }

    public void setTickDecimalAll(int dig) {
        this.setTickDecimal(0, dig);
        this.setTickDecimal(1, dig);
        this.setTickDecimal(2, dig);
    }

    public void setAxesBox(boolean isbox) {
        this.jpp[N1][N2].getView().setAxeBoxDisplayed(isbox);
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.jpp[i1][i2].clear();
                this.jpp[i1][i2].dispose();
                this.jpp[i1][i2] = null;
            }
        }
    }

    @Override
    protected void exportImage() {
        if (this.isBorderShown()) {
            this.showBorders(false);
        }
        JHPlot.showStatusBarText("Export to an image file");
        JFrame jm = this.getFrame();
        JFileChooser fileChooser = CommonGUI.openRasterImageFileChooser(jm);
        if (fileChooser.showDialog(jm, "Save As") == 0) {
            int res;
            final File scriptFile = fileChooser.getSelectedFile();
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(jm, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            JHPlot.showStatusBarText(mess);
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HPlotXYZ.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    @Override
    protected void showHelp() {
        new HelpDialog((Component)this.getFrame(), "hplotxyz.html");
    }

    @Override
    protected void openReadDataDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    protected void openWriteDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HPlotXYZ");
    }

    private Polygon[] getSquareBar(double x, double wx, double y, double wy, double height) {
        float xmin = (float)x;
        float xmax = (float)(x + wx);
        float ymin = (float)y;
        float ymax = (float)(y + wy);
        float zmin = 0.0f;
        float zmax = (float)height;
        BoundingBox3d bbox = new BoundingBox3d(xmin, xmax, ymin, ymax, zmin, zmax);
        Polygon[] quads = new Polygon[6];
        quads[0] = new Polygon();
        quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmax())));
        quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmin())));
        quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmin())));
        quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmax())));
        quads[1] = new Polygon();
        quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmax())));
        quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmin())));
        quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmin())));
        quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmax())));
        quads[2] = new Polygon();
        quads[2].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmax())));
        quads[2].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmin())));
        quads[2].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmin())));
        quads[2].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmax())));
        quads[3] = new Polygon();
        quads[3].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmax())));
        quads[3].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmin())));
        quads[3].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmin())));
        quads[3].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmax())));
        quads[4] = new Polygon();
        quads[4].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmax())));
        quads[4].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmax())));
        quads[4].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmax())));
        quads[4].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmax())));
        quads[5] = new Polygon();
        quads[5].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmin())));
        quads[5].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmin())));
        quads[5].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmin())));
        quads[5].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmin())));
        return quads;
    }

    public void addBar(double x, double y, double z, double height, double radius) {
        HistogramBar bar = new HistogramBar();
        bar.setData(new Coord3d(x, y, z), (float)height, (float)radius, this.currentFillColor);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addPoint(double x, double y, double z, double width) {
        Point bar = new Point();
        bar.setData(new Coord3d(x, y, z));
        bar.setColor(this.currentFillColor);
        bar.setWidth((float)width);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addPolygon(P2D p2d) {
        Polygon bar = new Polygon();
        for (int i = 0; i < p2d.size(); ++i) {
            Point p = new Point(new Coord3d(p2d.getX(i), p2d.getY(i), p2d.getZ(i)));
            p.setColor(this.currentWiredColor);
            bar.add(p);
        }
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addFlatLine(float[] x, float[] y, double depth) {
        FlatLine2d bar = new FlatLine2d(x, y, (float)depth);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addDisk(double x, double y, double z, double radiusInner, double radiusOuter, int slices, int loops) {
        Disk bar = new Disk();
        bar.setData(new Coord3d(x, y, z), (float)radiusInner, (float)radiusOuter, slices, loops);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addSphere(double x, double y, double z, double radius, double height, int slices, int stacks) {
        EnlightableSphere bar = new EnlightableSphere();
        bar.setData(new Coord3d(x, y, z), (float)radius, (float)height, slices, stacks);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addTube(double x, double y, double z, double radiusBottom, double radiusTop, double height, int slices, int stacks) {
        Tube bar = new Tube();
        bar.setData(new Coord3d(x, y, z), (float)radiusBottom, (float)radiusTop, (float)height, slices, stacks);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    private Parallelepiped getParallelepiped(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        BoundingBox3d b = new BoundingBox3d(xmin, xmax, ymin, ymax, zmin, zmax);
        Parallelepiped bar = new Parallelepiped(b);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        return bar;
    }

    public void addParallelepiped(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        BoundingBox3d b = new BoundingBox3d(xmin, xmax, ymin, ymax, zmin, zmax);
        Parallelepiped bar = new Parallelepiped(b);
        bar.setColor(this.currentFillColor);
        bar.setWireframeDisplayed(this.currentWiredrame);
        bar.setWireframeColor(this.currentWiredColor);
        bar.setWireframeWidth(this.currentWiredWidth);
        this.datalist[N1][N2].add((AbstractDrawable)bar);
    }

    public void addLight(double x, double y, double z, Color AmbiantColor, Color DiffuseColor, Color SpecularColor) {
        Light light = new Light(lightId++);
        light.setPosition(new Coord3d(x, y, z));
        light.setAmbiantColor(this.getColor(AmbiantColor));
        light.setDiffuseColor(this.getColor(DiffuseColor));
        light.setSpecularColor(this.getColor(SpecularColor));
        this.jpp[N1][N2].getScene().add(light);
    }

    public List<AbstractDrawable> getShapeList() {
        return this.datalist[N1][N2];
    }

    @Override
    protected void openReadDialog() {
    }
}

