/*
 * Decompiled with CFR 0.152.
 */
package fitter;

import fitter.BFunc;
import fitter.BMark;
import fitter.SEditor;
import hep.aida.IAnalysisFactory;
import hep.aida.IFitData;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionCatalog;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.ITree;
import hep.aida.ref.function.AbstractIFunction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.HMLabel;
import jhplot.HPlot;
import jhplot.P1D;
import jhplot.fit.BreitWigner;
import jhplot.fit.Exponent;
import jhplot.fit.Gauss;
import jhplot.fit.Landau;
import jhplot.fit.P0;
import jhplot.fit.P1;
import jhplot.fit.P2;
import jhplot.fit.P3;
import jhplot.fit.P4;
import jhplot.fit.P5;
import jhplot.fit.P6;
import jhplot.fit.Pow;
import jhplot.utils.Util;

public class Fitter {
    private static String[] labels;
    private String[] tooltip;
    private String[] items;
    private String[] definition;
    private String[] param;
    private int[] dimention;
    private ArrayList<BFunc> afunc;
    private String[] engines;
    private DefaultListModel model;
    private JList jlist;
    private JFrame frame;
    private H1D h1;
    private P1D p1;
    private boolean showFrame = false;
    final JTextPane textArea;
    final JTextField funcText;
    private StyledDocument doc;
    private String mess = "";
    private Style style = null;
    private final String br = "<br>";
    private final HPlot hplot;
    private final Font font = new Font("sansserif", 1, 10);
    private final Font fontB = new Font("sansserif", 1, 12);
    private JFormattedTextField minRange;
    private JFormattedTextField maxRange;
    private int[] constraint = new int[50];
    private JComboBox method;
    private JComboBox engine;
    private IAnalysisFactory anFactory;
    private ITree tree;
    private IFunctionFactory funcFactory;
    private IFitFactory fitFactory;
    private IFitter fitter;
    private IFunctionCatalog funcCatalog;
    private IFitResult fitResult;
    private IFunction fresult;
    private IFitData data;
    private SEditor se;
    private double rmin;
    private double rmax;
    private String shplot = "c1";
    private String sdata = "h1";
    private double[] fPars;
    private double[] fParErrs;
    private String[] fParNames;
    private F1D f2 = null;
    private ArrayList<BMark> bSetInit;
    private ArrayList<BMark> bSetResult;
    private IFunction func;
    private static String sfunc;
    private String codeFunc = "";
    private static boolean firstFit;
    private static boolean firstShow;

    public static void main(String[] args) {
        new Fitter(null, "c1");
    }

    public void iniData(H1D h1, String name) {
        this.h1 = h1;
        this.sdata = name;
        if (h1 != null && this.textArea != null) {
            this.rmin = h1.getMin();
            this.rmax = h1.getMax();
            this.maxRange.setValue(new Double(this.rmax));
            this.minRange.setValue(new Double(this.rmin));
            this.mess = "Histogram <b>" + h1.getTitle() + "</b> is loaded<br>";
            this.mess = this.mess + "Entries <b>" + Integer.toString(h1.entries()) + "</b> is loaded<p>";
            this.setHtml(this.mess);
        }
    }

    public void iniData(P1D p1, String name) {
        this.p1 = p1;
        this.sdata = name;
        if (p1 != null && this.textArea != null) {
            this.rmin = p1.getMin(0);
            this.rmax = p1.getMax(0);
            this.maxRange.setValue(new Double(this.rmax));
            this.minRange.setValue(new Double(this.rmin));
            this.mess = "P1D data <b>" + p1.getTitle() + "</b> are loaded<br>";
            this.mess = this.mess + "Entries <b>" + Integer.toString(p1.size()) + "</b> is loaded<p>";
            this.setHtml(this.mess);
        }
    }

    public Fitter(HPlot hplot, String name) {
        int i;
        this.shplot = name;
        this.hplot = hplot;
        this.showFrame = false;
        firstFit = true;
        firstShow = true;
        this.afunc = new ArrayList();
        this.afunc.add(new BFunc("P0", "p0"));
        this.afunc.add(new BFunc("P1", "p0+p1*x"));
        this.afunc.add(new BFunc("P2", "p0+p1*x+p2*x^2"));
        this.afunc.add(new BFunc("P3", "p0+p1*x+p2*x^2+p3*x^3"));
        this.afunc.add(new BFunc("P4", "polynom^4"));
        this.afunc.add(new BFunc("P5", "polynom^5"));
        this.afunc.add(new BFunc("P6", "polynom^6"));
        this.afunc.add(new BFunc("Gauss", "p0*exp(arg*arg/2); arg=(x-p1)/p2"));
        this.afunc.add(new BFunc("BreitWigner", "p0*bw/(2*PI); bw=p2/((x-p1)*(x-p1)+p2*p2/4)"));
        this.afunc.add(new BFunc("Exponent", "p0*exp^(p1*(x-p2))"));
        this.afunc.add(new BFunc("Landau", "Landau (Moyal formula)"));
        this.afunc.add(new BFunc("Pow", "p0*(p1-x)^p2"));
        Collections.sort(this.afunc);
        labels = new String[this.afunc.size()];
        this.tooltip = new String[this.afunc.size()];
        this.definition = new String[this.afunc.size()];
        this.param = new String[this.afunc.size()];
        this.dimention = new int[this.afunc.size()];
        for (i = 0; i < this.afunc.size(); ++i) {
            BFunc a = this.afunc.get(i);
            Fitter.labels[i] = a.getName();
            this.tooltip[i] = a.getTip();
            this.definition[i] = a.getDefinition();
            this.param[i] = a.getParam();
            this.dimention[i] = a.getDim();
        }
        this.model = new DefaultListModel();
        int n = labels.length;
        for (i = 0; i < n; ++i) {
            this.model.addElement(labels[i]);
        }
        this.jlist = new JList(this.model){
            public static final long serialVersionUID = 126L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (-1 < index) {
                    String item = Fitter.this.tooltip[index];
                    return item;
                }
                return null;
            }
        };
        this.anFactory = IAnalysisFactory.create();
        this.tree = this.anFactory.createTreeFactory().create();
        this.funcFactory = this.anFactory.createFunctionFactory(this.tree);
        this.fitFactory = this.anFactory.createFitFactory();
        this.fitter = this.fitFactory.createFitter("Chi2", "jminuit", "noClone=\"true\"");
        this.data = this.fitFactory.createFitData();
        this.funcCatalog = this.funcFactory.catalog();
        this.bSetInit = new ArrayList();
        this.bSetResult = new ArrayList();
        this.items = this.fitFactory.availableFitMethods();
        this.engines = this.fitFactory.availableFitEngines();
        this.frame = new JFrame("Fit Panel");
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Fitter.this.frame.setVisible(false);
                System.gc();
                Fitter.this.frame.dispose();
            }
        });
        this.funcText = new JTextField("select a function and press \"add\"");
        this.funcText.setFont(this.fontB);
        this.funcText.setEditable(false);
        this.se = new SEditor(this.frame, this);
        Container contentPane = this.frame.getContentPane();
        JScrollPane scrollPane1 = new JScrollPane(this.jlist);
        contentPane.add((Component)scrollPane1, "West");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        HTMLDocument htmlDoc = (HTMLDocument)editorKit.createDefaultDocument();
        this.minRange = new JFormattedTextField();
        this.maxRange = new JFormattedTextField();
        this.minRange.setToolTipText("min value");
        this.maxRange.setToolTipText("max value");
        this.minRange.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (!(input instanceof JFormattedTextField)) {
                    return true;
                }
                return ((JFormattedTextField)input).isEditValid();
            }
        });
        this.maxRange.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (!(input instanceof JFormattedTextField)) {
                    return true;
                }
                return ((JFormattedTextField)input).isEditValid();
            }
        });
        this.minRange.setFont(this.fontB);
        this.maxRange.setFont(this.fontB);
        this.minRange.setColumns(6);
        this.maxRange.setColumns(6);
        this.maxRange.setValue(new Double(0.0));
        this.minRange.setValue(new Double(0.0));
        this.textArea = new JTextPane();
        this.textArea.setEditable(false);
        this.textArea.setEditorKit(editorKit);
        this.textArea.setContentType("text/html");
        this.textArea.setDocument(htmlDoc);
        this.doc = (StyledDocument)this.textArea.getDocument();
        this.style = this.doc.getStyle("text/html");
        JScrollPane scrollPane2 = new JScrollPane(this.textArea);
        contentPane.add((Component)scrollPane2, "Center");
        this.method = new JComboBox<String>(this.items);
        this.method.setSelectedIndex(3);
        this.method.setPreferredSize(new Dimension(115, 24));
        this.method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                int nn = combo.getSelectedIndex();
                String s = Fitter.this.items[nn];
                Fitter.this.fitter.setFitMethod(s);
                Fitter.this.codeFunc = Fitter.this.codeFunc + "fitter.setFitMethod(\"" + s + "\")\n";
            }
        });
        this.engine = new JComboBox<String>(this.engines);
        if (this.engines.length > 1) {
            this.engine.setSelectedIndex(1);
        } else {
            this.engine.setSelectedIndex(0);
        }
        this.engine.setPreferredSize(new Dimension(100, 24));
        this.engine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                int nn = combo.getSelectedIndex();
                String s = Fitter.this.engines[nn];
                Fitter.this.fitter.setEngine(s);
                Fitter.this.codeFunc = Fitter.this.codeFunc + "fitter.setEngine(\"" + s + "\")\n";
            }
        });
        JPanel jpTOP = new JPanel();
        jpTOP.setLayout(new BorderLayout());
        JPanel jpRIGHT = new JPanel();
        JPanel jp = new JPanel(new GridLayout(2, 1));
        JPanel jp1 = new JPanel(new FlowLayout(1, 1, 1));
        JPanel jp2 = new JPanel(new FlowLayout(1, 1, 1));
        jp.add(jp1);
        jp.add(jp2);
        JButton jb = new JButton("add");
        jp1.add(jb);
        jp1.add(this.method);
        jp1.add(this.engine);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object firstSel = Fitter.this.jlist.getSelectedValue();
                int indx = Fitter.this.jlist.getSelectedIndex();
                if (firstSel == null) {
                    return;
                }
                if (indx < 0) {
                    return;
                }
                final int Index = indx;
                Thread t = new Thread("build function thread"){

                    @Override
                    public void run() {
                        Fitter.this.buildFunc(Index);
                    }
                };
                t.start();
            }
        });
        jb = new JButton("Settings");
        jp2.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Fitter.this.func != null) {
                    Fitter.this.se.fillTable();
                    Fitter.this.se.showIt();
                }
            }
        });
        jb = new JButton("AIDA code");
        jb.setToolTipText("Generate and insert Jython code");
        jp1.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String tmp = Fitter.this.makeCode();
                Fitter.this.showOutput(tmp);
            }
        });
        jb = new JButton("Output");
        jb.setToolTipText("Generate and insert output");
        jp1.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String tmp = Fitter.this.makeOutput();
                Fitter.this.showOutput(tmp);
            }
        });
        jb = new JButton("Fit!");
        jb.setToolTipText("Performe fit");
        jp2.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread t = new Thread("do fit thread"){

                    @Override
                    public void run() {
                        Fitter.this.doFit(Fitter.this.func, sfunc);
                    }
                };
                t.start();
            }
        });
        jb = new JButton("Best guess");
        jp2.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Fitter.this.mess = "";
                Fitter.this.setHtml(Fitter.this.mess);
                Fitter.this.ErrorMessage("Not implemented");
            }
        });
        jb = new JButton("Clear");
        jp2.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Fitter.this.clearFit();
            }
        });
        jb = new JButton("Exit");
        jp2.add(jb);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int res = JOptionPane.showConfirmDialog(Fitter.this.frame, "Do you want to exit?", "", 0);
                if (res == 1) {
                    return;
                }
                Fitter.this.frame.setVisible(false);
                System.gc();
                Fitter.this.frame.dispose();
            }
        });
        jpTOP.add((Component)this.funcText, "Center");
        jpRIGHT.add(this.minRange);
        jpRIGHT.add(this.maxRange);
        jpTOP.add((Component)jpRIGHT, "East");
        contentPane.add((Component)jpTOP, "North");
        contentPane.add((Component)jp, "South");
    }

    public void showIt() {
        this.showFrame = true;
        Util.rightWithin(this.hplot.getFrame(), this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void setHtml(String html) {
        this.textArea.setText("<html>" + html + "</html>");
        this.textArea.setCaretPosition(this.doc.getLength());
    }

    public void iniFunc() {
        if (this.func == null) {
            return;
        }
        double maxBinHeight = 1.0;
        double mean = 0.0;
        double rms = 1.0;
        if (this.h1 != null) {
            maxBinHeight = this.h1.maxBinHeight();
            mean = this.h1.mean();
            rms = this.h1.rms();
        }
        if (this.p1 != null) {
            maxBinHeight = this.p1.getMax(1);
            mean = this.p1.meanX();
            rms = 1.0;
        }
        if (sfunc.indexOf("Gauss") > -1) {
            this.func.setParameter("norm", maxBinHeight);
            this.func.setParameter("mean", mean);
            this.func.setParameter("sigma", rms);
        } else if (sfunc.indexOf("BreitWigner") > -1) {
            this.func.setParameter("norm", maxBinHeight);
            this.func.setParameter("mean", mean);
            this.func.setParameter("gamma", 0.5 * rms);
        } else if (sfunc.indexOf("Exponent") > -1) {
            this.func.setParameter("pe0", 1.0);
            this.func.setParameter("pe1", 1.0);
            this.func.setParameter("pe2", 0.0);
        } else if (sfunc.indexOf("Landau") > -1) {
            this.func.setParameter("norm", maxBinHeight);
            this.func.setParameter("peak", mean);
            this.func.setParameter("sigma", rms);
        }
        if (this.bSetResult.size() == 0) {
            this.bSetInit.clear();
            String[] sname = this.func.parameterNames();
            double[] par = this.func.parameters();
            for (int i = 0; i < this.func.numberOfParameters(); ++i) {
                this.bSetInit.add(new BMark(sname[i], 0.0, 0.0, par[i], false, this.constraint[i]));
            }
        } else {
            this.bSetInit = this.bSetResult;
            String[] sname = this.func.parameterNames();
            double[] par = this.func.parameters();
            for (int i = this.bSetResult.size(); i < this.func.numberOfParameters(); ++i) {
                this.bSetInit.add(new BMark(sname[i], 0.0, 0.0, par[i], false, 0));
            }
        }
        this.se.putSettings(this.bSetInit);
    }

    public void clearFit() {
        this.mess = "";
        this.setHtml(this.mess);
        this.func = null;
        sfunc = "";
        this.fitResult = null;
        this.bSetInit.clear();
        this.bSetResult.clear();
        this.funcText.setText("cleared..Add a new function");
        this.data.reset();
        if (!firstFit) {
            this.hplot.clearData(this.hplot.sizeData() - 1);
            this.hplot.removeLabel(this.hplot.numberLabels() - 1);
            this.hplot.refreshFrame();
            firstFit = true;
        }
        if (!firstShow) {
            this.hplot.clearData(this.hplot.sizeData() - 1);
            this.hplot.refreshFrame();
            firstShow = true;
        }
        System.gc();
    }

    public void setRange(double rmin, double rmax) {
        this.rmin = rmin;
        this.rmax = rmax;
    }

    public void doFit(IFunction func, String sfunc) {
        this.func = func;
        Fitter.sfunc = sfunc;
        this.codeFunc = this.codeFunc + "func = funcFactory.createFunctionByName(\"fit function\",\"" + sfunc + "\")\n";
        this.getSettings();
        this.mess = this.mess + "Perform fit in the range:" + Double.toString(this.rmin) + " : " + Double.toString(this.rmax) + "<br>";
        this.data = this.fitFactory.createFitData();
        this.codeFunc = this.codeFunc + "data = fitFactory.createFitData()\n";
        if (this.h1 != null) {
            this.data.create1DConnection((IHistogram1D)this.h1.get());
            this.codeFunc = this.codeFunc + "data.create1DConnection( " + this.sdata + ".get() )\n";
        }
        if (this.p1 != null) {
            this.data.create1DConnection(this.p1.getIDataPointSet(), 0, 1);
            this.codeFunc = this.codeFunc + "data.create1DConnection( p1.getIDataPointSet(),0," + this.sdata + ".size() )\n";
        }
        this.data.range(0).excludeAll();
        this.data.range(0).include(this.rmin, this.rmax);
        this.fitResult = this.fitter.fit(this.data, func);
        this.codeFunc = this.codeFunc + "rmin=" + Double.toString(this.rmin) + "; rmax=" + Double.toString(this.rmax) + "\n";
        this.codeFunc = this.codeFunc + "data.range(0).excludeAll()\n";
        this.codeFunc = this.codeFunc + "data.range(0).include(rmin,rmax)\n";
        this.codeFunc = this.codeFunc + "fitResult = fitter.fit(data,func)\n";
        this.fPars = this.fitResult.fittedParameters();
        this.fParErrs = this.fitResult.errors();
        this.fParNames = this.fitResult.fittedParameterNames();
        String spar = "";
        DecimalFormat dfb = new DecimalFormat("##.####E00");
        DecimalFormat dfb0 = new DecimalFormat("#.##E00");
        String[] slabel = new String[this.fitResult.fittedFunction().numberOfParameters() + 1];
        spar = spar + "Chi2 = " + dfb0.format((Object)this.fitResult.quality()) + "<br>";
        slabel[0] = "&chi;^{2} / ndf = " + dfb0.format((Object)(this.fitResult.quality() * (double)this.fitResult.ndf())) + "/" + this.fitResult.ndf();
        for (int i = 0; i < this.fitResult.fittedFunction().numberOfParameters(); ++i) {
            String a1 = dfb.format((Object)this.fPars[i]);
            String e1 = dfb.format((Object)this.fParErrs[i]);
            spar = spar + this.fParNames[i] + " = " + a1 + "  &plusmn;  " + e1 + "<br>";
            slabel[i + 1] = this.fParNames[i] + " = " + dfb0.format((Object)this.fPars[i]) + "  &plusmn;  " + dfb0.format((Object)this.fParErrs[i]);
        }
        this.fresult = this.fitResult.fittedFunction();
        this.codeFunc = this.codeFunc + "fresult=fitResult.fittedFunction()\n";
        this.bSetResult.clear();
        String[] sname = this.fresult.parameterNames();
        double[] par = this.fresult.parameters();
        for (int i = 0; i < this.fresult.numberOfParameters(); ++i) {
            this.bSetResult.add(new BMark(sname[i], 0.0, 0.0, par[i], false, this.constraint[i]));
        }
        this.se.putSettings(this.bSetResult);
        this.mess = this.mess + spar + "<br>";
        this.setHtml(this.mess);
        if (this.hplot != null) {
            if (this.h1 != null || this.p1 != null) {
                this.f2 = new F1D(sfunc, this.fresult, this.rmin, this.rmax);
                this.codeFunc = this.codeFunc + "f2=F1D(\"" + sfunc + "\", fresult, rmin, rmax)\n";
            }
            this.f2.setColor(Color.red);
            this.f2.setPenWidth(2);
            if (!firstShow) {
                this.hplot.clearData(this.hplot.sizeData() - 1);
                firstShow = true;
            }
            if (!firstFit) {
                this.hplot.clearData(this.hplot.sizeData() - 1);
                this.hplot.removeLabel(this.hplot.numberLabels() - 1);
            }
            HMLabel lab = new HMLabel(slabel, 0.65, 0.85, "NDC");
            lab.setFont(this.font);
            this.hplot.add(lab);
            if (this.h1 != null) {
                this.hplot.draw(this.f2, true);
            }
            if (this.p1 != null) {
                this.hplot.draw(this.f2, true);
            }
            this.codeFunc = this.codeFunc + this.shplot + ".draw(f2,1)";
            firstFit = false;
        }
    }

    private String makeCode() {
        String codeStart = "\n\n# --- code was generated by jHPlot authomatically ---:\nfrom hep.aida import *\nfrom jhplot.fit import *\n";
        codeStart = codeStart + "\nanFactory = IAnalysisFactory.create()\ntree        = anFactory.createTreeFactory().create()\nfitFactory  = anFactory.createFitFactory()\nfitter = fitFactory.createFitter(\"Chi2\",\"jminuit\")\nfuncFactory = anFactory.createFunctionFactory( tree )\nfuncCatalog = funcFactory.catalog()\n";
        String tmp = codeStart + this.codeFunc;
        tmp = tmp + "\n\n# Fit output:\n";
        tmp = tmp + "print \"fit chi2/ndf =\",fitResult.quality()\n";
        tmp = tmp + "print \"output parameters=\",fitResult.fittedParameterNames()\n";
        tmp = tmp + "print \"output parameter values=\",fitResult.fittedParameters()\n";
        tmp = tmp + "print \"output parameter errors=\",fitResult.errors()\n";
        tmp = tmp + "\n# --- end of authomatically generated code --- \n";
        return tmp;
    }

    private String makeOutput() {
        String tmp = "\n# fit output\n";
        tmp = tmp + "ndf=" + Integer.toString(this.fitResult.ndf()) + "\n";
        tmp = tmp + "chi2=" + Double.toString((double)this.fitResult.ndf() * this.fitResult.quality()) + "\n";
        for (int i = 0; i < this.fitResult.fittedFunction().numberOfParameters(); ++i) {
            tmp = tmp + this.fParNames[i] + " = " + Double.toString(this.fPars[i]) + "\n";
            tmp = tmp + this.fParNames[i] + "_E = " + Double.toString(this.fParErrs[i]) + "\n";
        }
        return tmp;
    }

    public void drawFunc() {
        if (!firstShow) {
            this.hplot.clearData(this.hplot.sizeData() - 1);
        }
        if (!firstFit) {
            this.bSetResult.clear();
            this.data.reset();
        }
        this.getSettings();
        this.f2 = new F1D(sfunc, this.func, this.rmin, this.rmax);
        if (this.h1 != null) {
            this.hplot.draw(this.f2, true);
        }
        if (this.p1 != null) {
            this.hplot.draw(this.f2, false);
        }
        firstShow = false;
    }

    public void getSettings() {
        if (this.showFrame) {
            this.rmin = (Double)this.minRange.getValue();
            this.rmax = (Double)this.maxRange.getValue();
        }
        if (this.func == null) {
            this.ErrorMessage("No function selected");
            return;
        }
        if (this.rmax <= this.rmin) {
            this.ErrorMessage("Fit range is wrong");
            return;
        }
        this.bSetInit = this.se.getSettings();
        String[] name1 = this.func.parameterNames();
        for (int i = 0; i < this.bSetInit.size(); ++i) {
            BMark b = this.bSetInit.get(i);
            this.constraint[i] = 0;
            String name = b.getTitle();
            if (b.getMin() < b.getMax()) {
                this.fitter.fitParameterSettings(name).setBounds(b.getMin(), b.getMax());
                this.codeFunc = this.codeFunc + "fitter.fitParameterSettings(\"" + name + "\").setBounds(" + Double.toString(b.getMin()) + "," + Double.toString(b.getMax()) + ")\n";
            }
            this.fitter.fitParameterSettings(name).setFixed(b.getFix());
            String jy_logic = "0";
            if (b.getFix()) {
                jy_logic = "1";
            }
            this.codeFunc = this.codeFunc + "fitter.fitParameterSettings(\"" + name + "\").setFixed(" + jy_logic + ")\n";
            this.func.setParameter(name, b.getC());
            this.codeFunc = this.codeFunc + "func.setParameter(\"" + name + "\"," + Double.toString(b.getC()) + ")\n";
            int jj = b.getCons();
            if (jj <= 0 || jj > name1.length || jj == i) continue;
            this.fitter.setConstraint(name + " = " + name1[jj]);
            this.codeFunc = this.codeFunc + "fitter.setConstraint(\"" + name + "\" = \"" + name1[jj] + "\")\n";
            this.constraint[i] = jj;
        }
        this.mess = this.mess + "Perform fit in the range:" + Double.toString(this.rmin) + " : " + Double.toString(this.rmax) + "<br>";
    }

    public void showOutput(String a) {
        String classname = "jehep.ui.Editor";
        Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName(classname);
            o = c.newInstance();
        }
        catch (Exception e) {
            System.out.println(a);
            return;
        }
        String meth = "insetTextCaret";
        Class[] parameterTypes = new Class[]{String.class};
        try {
            Method m = c.getMethod(meth, parameterTypes);
            m.invoke(c, a);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
    }

    public void addFunc(String name1, String tooltip1, String defininion1, String param1, int dim) {
        int i;
        this.afunc.add(new BFunc(name1, tooltip1, defininion1, param1, dim));
        Collections.sort(this.afunc);
        labels = new String[this.afunc.size()];
        this.tooltip = new String[this.afunc.size()];
        this.definition = new String[this.afunc.size()];
        this.param = new String[this.afunc.size()];
        this.dimention = new int[this.afunc.size()];
        for (i = 0; i < this.afunc.size(); ++i) {
            BFunc a = this.afunc.get(i);
            Fitter.labels[i] = a.getName();
            this.tooltip[i] = a.getTip();
            this.definition[i] = a.getDefinition();
            this.dimention[i] = a.getDim();
            this.param[i] = a.getParam();
        }
        this.model.clear();
        for (i = 0; i < labels.length; ++i) {
            this.model.addElement(labels[i]);
        }
        this.jlist.repaint();
    }

    private void buildFunc(int indx) {
        AbstractIFunction f = null;
        this.func = null;
        String s = labels[indx];
        this.mess = this.mess + "<b>" + s + "</b> added<br>";
        if (s.equals("P0")) {
            f = new P0(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P0(\"" + s + "\"))\n";
        } else if (s.equals("P1")) {
            f = new P1(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P1(\"" + s + "\"))\n";
        } else if (s.equals("P2")) {
            f = new P2(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P2(\"" + s + "\"))\n";
        } else if (s.equals("P3")) {
            f = new P3(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P3(\"" + s + "\"))\n";
        } else if (s.equals("P4")) {
            f = new P4(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P4(\"" + s + "\"))\n";
        } else if (s.equals("P5")) {
            f = new P5(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P5(\"" + s + "\"))\n";
        } else if (s.equals("P6")) {
            f = new P6(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", P6(\"" + s + "\"))\n";
        } else if (s.equals("Gauss")) {
            f = new Gauss(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", Gauss(\"" + s + "\"))\n";
        } else if (s.equals("BreitWigner")) {
            f = new BreitWigner(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", BreitWigner(\"" + s + "\"))\n";
        } else if (s.equals("Exponent")) {
            f = new Exponent(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", Exponent(\"" + s + "\"))\n";
        } else if (s.equals("Pow")) {
            f = new Pow(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", Pow(\"" + s + "\"))\n";
        } else if (s.equals("Landau")) {
            f = new Landau(s);
            this.funcCatalog.add(s, (IFunction)f);
            this.codeFunc = this.codeFunc + "funcCatalog.add(\"" + s + "\", Landau(\"" + s + "\"))\n";
        } else if (!this.definition[indx].equals("undefined")) {
            f = this.funcFactory.createFunctionFromScript(s, this.dimention[indx], this.definition[indx], this.param[indx], s, null);
            this.funcCatalog.add(s, (IFunction)f);
            String dd = Integer.toString(this.dimention[indx]);
            this.codeFunc = this.codeFunc + "funcFactory.createFunctionFromScript(\"" + s + "\"," + dd + ",\"" + this.definition[indx] + "\",\"" + this.param[indx] + "\",\" \",null)\n";
        }
        sfunc = sfunc.length() > 0 ? sfunc + "+" + s : s;
        this.funcText.setText(sfunc);
        this.mess = this.mess + "current function=<b>" + sfunc + "</b><br>";
        this.func = this.funcFactory.createFunctionByName("fit function", sfunc);
        this.iniFunc();
        this.setHtml(this.mess);
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    static {
        sfunc = "";
    }
}

