/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class SteinerSurface
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.732, 1.6, 1.8);

    public SteinerSurface() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.umin.reset("0");
        this.umax.reset("pi");
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.uPatchCount.setValueAndDefault(20);
        this.vPatchCount.setValueAndDefault(20);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double HalfAASquare = 0.5 * AA * AA;
        return new Vector3D(HalfAASquare * (SteinerSurface.sin(2.0 * u) * SteinerSurface.cos(v) * SteinerSurface.cos(v)), HalfAASquare * (SteinerSurface.sin(u) * SteinerSurface.sin(2.0 * v)), HalfAASquare * (SteinerSurface.cos(u) * SteinerSurface.sin(2.0 * v)));
    }
}

