/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.Complex;
import vmm3d.core.IntegerParam;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class PlanarEnneper
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm3d.surface.parametric.PlanarEnneper.MainEx", 1);
    private IntegerParam only3 = new IntegerParam("vmm3d.surface.parametric.PlanarEnneper.Only3", 2);
    private int kW;
    private int d3;
    private double r1;

    public PlanarEnneper() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.only3);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(9.0, -13.0, 18.0));
        this.setDefaultWindow(-4.0, 4.0, -4.5, 3.5);
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset(-1.3);
        this.umax.reset(0.25, 0.15, 0.45);
        this.vmin.reset(0.0);
        this.vmax.reset(Math.PI * 2);
        this.canShowConjugateSurface = true;
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        return z;
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex w = z.integerPower(this.kW);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = z.integerPower(this.kW - this.d3);
        return w;
    }

    @Override
    protected Complex gaussTimesHPrime(Complex z) {
        Complex w = z.integerPower(2 * this.kW - this.d3);
        return w;
    }

    @Override
    protected Complex gaussInverseTimesHPrime(Complex z) {
        Complex w = z.integerPower(this.d3);
        return w.inverse();
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.kW = 1 + this.exponent.getValue();
        this.d3 = this.only3.getValue();
        this.r1 = 1.0;
        this.ucount = 1 + this.uPatchCount.getValue() * 6;
        this.vcount = 1 + this.vPatchCount.getValue() * 6;
        this.helperArray = new ComplexVector3D[this.ucount][this.vcount];
        this.du = (this.umax.getValue() - this.umin.getValue()) / (double)(this.ucount - 1);
        this.dv = (this.vmax.getValue() - this.vmin.getValue()) / (double)(this.vcount - 1);
    }

    @Override
    protected ComplexVector3D getCenter() {
        ComplexVector3D hA00 = new ComplexVector3D(this.helperArray[0][0]);
        hA00 = hA00.plus(this.helperArray[0][(int)Math.floor(this.vcount - 1)]).times(0.5);
        hA00 = hA00.plus(this.helperArray[0][(int)Math.floor(this.vcount / 2)]).times(0.5);
        return hA00;
    }
}

