/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.Complex;
import vmm3d.core.IntegerParam;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class DoubleEnneper
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm3d.surface.parametric.DoubleEnneper.MainEx", 8);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.DoubleEnneper.aa", 4.0, 4.0, 4.0);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm3d.surface.parametric.DoubleEnneper.bb", 0.1, 0.0, 1.0);
    double uminmax = 1.5;
    private int ee;
    private double AA;
    private double BE;
    private Complex q1;
    private Complex q2;
    private Complex q3;
    private Complex q1q2;

    public DoubleEnneper() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(40.0, -50.0, 40.0));
        this.setDefaultWindow(-9.0, 9.0, -7.0, 7.0);
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset(-this.uminmax);
        this.umax.reset(this.uminmax);
        this.vmin.reset(0.0);
        this.vmax.reset(Math.PI * 2);
        this.canShowConjugateSurface = true;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AFP = this.afp.getValue();
        if (param != this.afp) {
            this.needsValueArray = true;
            if (param == this.exponent) {
                this.uminmax = 2.0 - (double)this.exponent.getValue() / 16.0;
                this.umin.reset(-this.uminmax);
                this.umax.reset(this.uminmax);
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        return z;
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex w = z.integerPower(this.ee);
        Complex aux = this.q2.times(w);
        aux.assignMinus(this.q1);
        aux.assignTimes(w);
        Complex auy = this.q1.times(w);
        auy.assignMinus(this.q2);
        auy.assignTimes(z);
        return aux.dividedBy(auy);
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = z.integerPower(this.ee);
        Complex aux = w.minus(this.q1q2);
        aux.assignTimes(w);
        aux.re += 1.0;
        Complex auy = this.q3.times(w);
        auy.assignTimes(z);
        return aux.dividedBy(auy);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.ee = this.exponent.getValue();
        this.BE = Math.PI * 2 * this.bb.getValue() / (double)this.ee;
        this.AA = Math.max(1.1, this.aa.getValue());
        this.q1 = new Complex(Math.sqrt(this.AA) * Math.cos(this.BE / 2.0), Math.sqrt(this.AA) * Math.sin(this.BE / 2.0));
        this.q1 = this.q1.integerPower(this.ee);
        this.q2 = this.q1.inverse();
        this.q1q2 = this.q1.integerPower(2).plus(this.q2.integerPower(2));
        double r = Math.exp((double)(2 * this.ee) * Math.log(this.AA));
        r = (r - 1.0) / (r + 1.0);
        this.q3 = new Complex(Math.cos((double)this.ee * this.BE), r * Math.sin((double)this.ee * this.BE));
        this.q3 = this.q3.times(Math.sqrt(this.AA * this.AA + 1.0 / this.AA / this.AA) * Math.exp(this.ee) * (double)(this.ee + 1) / (5.5 + 1.0 / (double)this.ee) * Math.sqrt(this.ee));
    }

    @Override
    protected ComplexVector3D getCenter() {
        int um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        int vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
        ComplexVector3D hA00 = new ComplexVector3D(this.helperArray[um][0]);
        return hA00.plus(this.helperArray[um][vm]).times(0.5);
    }
}

