/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core3D.Vector3D;

public class Maps {
    static double dotProd(Vector3D v, Vector3D w) {
        return v.x * w.x + v.y * w.y + v.z * w.z;
    }

    public static void ProjectOnAxis(Vector3D axis, Vector3D source, Vector3D destination) {
        destination = axis.times(Maps.dotProd(axis, source));
    }

    public static Vector3D ProjectionOnAxis(Vector3D axis, Vector3D source) {
        return axis.times(Maps.dotProd(axis, source));
    }

    public static void ReflectInAxis(Vector3D axis, Vector3D source, Vector3D destination) {
        destination = axis.times(2.0 * Maps.dotProd(axis, source)).minus(source);
    }

    public static Vector3D ReflectionInAxis(Vector3D axis, Vector3D source) {
        return axis.times(2.0 * Maps.dotProd(axis, source)).minus(source);
    }

    public static void Transvect(Vector3D e1, Vector3D e2, Vector3D source, Vector3D destination) {
        Vector3D midpoint = new Vector3D(e1.plus(e2).normalized());
        Maps.ReflectInAxis(midpoint, Maps.ReflectionInAxis(e1, source), destination);
    }

    public static Vector3D Transvection(Vector3D e1, Vector3D e2, Vector3D source) {
        Vector3D midpoint = new Vector3D(e1.plus(e2).normalized());
        return Maps.ReflectionInAxis(midpoint, Maps.ReflectionInAxis(e1, source));
    }
}

