/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class ImplicitHyperboloid2Sheet
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm3d.surface.implicit.Hyperboloid2.a", 0.6, 0.6, 0.8);
    private RealParamAnimateable b = new RealParamAnimateable("vmm3d.surface.implicit.Hyperboloid2.b", 10.0, 10.0, 8.0);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double aa = this.a.getValue();
        double bb = this.b.getValue();
        double height = bb * (ImplicitHyperboloid2Sheet.sqr(x) - ImplicitHyperboloid2Sheet.sqr(y) - ImplicitHyperboloid2Sheet.sqr(z / aa));
        return height;
    }

    public ImplicitHyperboloid2Sheet() {
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.setDefaultViewpoint(new Vector3D(9.0, 500.0, -1.5));
        this.searchRadius.reset(3.0);
        this.pointCloudCount.reset(12000);
        this.level.reset(1.0, 1.0, 1.0);
        this.heightFunctionType = SurfaceImplicit.equationType.QUADRATIC;
    }
}

