/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.spacecurve.parametric;

import java.awt.Color;
import java.util.Random;
import vmm3d.core.View;
import vmm3d.core3D.DotCloudSurface;
import vmm3d.core3D.Vector3D;
import vmm3d.spacecurve.parametric.SpaceCurveParametric;

public abstract class SphericalCurve
extends SpaceCurveParametric {
    protected DotCloudSphere cloudSphere;

    public SphericalCurve() {
        this.setDefaultWindow(-1.2, 1.2, -1.2, 1.2);
        this.setDefaultViewpoint(new Vector3D(16.0, 8.0, 19.0));
        this.cloudSphere = new DotCloudSphere();
        this.cloudSphere.setColor(Color.blue);
        this.addDecoration(this.cloudSphere);
    }

    @Override
    public View getDefaultView() {
        SphericalCurveView view = new SphericalCurveView();
        view.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsCurve");
        return view;
    }

    public class SphericalCurveView
    extends SpaceCurveParametric.SpaceCurveParametricView {
    }

    protected class DotCloudSphere
    extends DotCloudSurface {
        protected DotCloudSphere() {
        }

        @Override
        protected Vector3D makeRandomPixel(Random randomNumberGenerator) {
            double u = randomNumberGenerator.nextDouble() * Math.PI * 2.0;
            double z = randomNumberGenerator.nextDouble() * 2.0 - 1.0;
            double r = Math.sqrt(1.0 - z * z);
            double x = r * Math.cos(u);
            double y = r * Math.sin(u);
            return new Vector3D(x, y, z);
        }
    }
}

