/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.pseudospherical;

import vmm3d.core.Complex;
import vmm3d.core3D.Vector3D;
import vmm3d.pseudospherical.ComplexMatrix2D;
import vmm3d.pseudospherical.nSolitons;

public class TwoSoliton
extends nSolitons {
    public TwoSoliton() {
        int j;
        int i;
        this.addParameter(this.s1);
        this.addParameter(this.s);
        this.umin.reset(-3.0);
        this.umax.reset(3.0);
        this.vmin.reset("-2*pi/3");
        this.vmax.reset("2*pi/2");
        this.setDefaultWindow(-1.54413, 2.08531, -1.01855, 1.80435);
        this.setDefaultViewpoint(new Vector3D(5.68343, -4.97103, 2.70184));
        this.setDefaultViewUp(new Vector3D(-0.273059, -0.58132, -0.679148));
        this.lambda = new Complex(0.0, 1.0);
        this.E = new ComplexMatrix2D[3][6];
        for (i = 0; i <= 2; ++i) {
            for (j = 0; j < 6; ++j) {
                this.E[i][j] = new ComplexMatrix2D();
            }
        }
        this.g = new ComplexMatrix2D[3][5];
        for (i = 0; i <= 2; ++i) {
            for (j = 0; j < 5; ++j) {
                this.g[i][j] = new ComplexMatrix2D();
            }
        }
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.proj1 = ComplexMatrix2D.getProj(this.initVec1);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.g2 = new ComplexMatrix2D();
    }

    @Override
    public synchronized Vector3D surfacePoint(double x, double t) {
        ComplexMatrix2D ret = this.firstSoliton(x, t);
        this.afterFirstSol(x, t);
        ret = this.iterate1(x, t);
        double aa = ret.entries[1][1].im;
        double bb = ret.entries[1][2].re;
        double cc = ret.entries[1][2].im;
        if (Double.isNaN(aa) || Double.isNaN(aa) || Double.isNaN(aa)) {
            cc = 0.0;
            bb = 0.0;
            aa = 0.0;
        }
        return new Vector3D(aa, bb, cc);
    }
}

