/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.polyhedron;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.ActionList;
import vmm3d.actions.ToggleAction;
import vmm3d.core.Animation;
import vmm3d.core.I18n;
import vmm3d.core.TimerAnimation;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Exhibit3D;
import vmm3d.core3D.PhongLighting;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;
import vmm3d.core3D.View3DLit;

public class IFS
extends Exhibit3D {
    protected int edgeDivisor = 8;
    protected boolean useBackFaceFudge = false;
    private Vector3D[] vertices;
    private int[][] faces;
    private Vector3D[] unitNormals;
    private ArrayList<int[]> edges;
    private ArrayList<Face> clippedFaces;
    private ArrayList<Segment> clippedEdges;

    public IFS(Vector3D[] vertexList, int[][] faceData) {
        this.setIFSData(vertexList, faceData);
    }

    protected IFS() {
    }

    protected void setIFSData(Vector3D[] vertices, int[][] faces) {
        this.vertices = vertices;
        this.faces = faces;
        this.edges = new ArrayList();
        for (int[] face : faces) {
            block1: for (int i = 0; i < face.length; ++i) {
                int v1 = face[i];
                int v2 = i == face.length - 1 ? face[0] : face[i + 1];
                for (int[] edge : this.edges) {
                    if ((edge[0] != v1 || edge[1] != v2) && (edge[0] != v2 || edge[1] != v1)) continue;
                    continue block1;
                }
                this.edges.add(new int[]{v1, v2});
            }
        }
        this.unitNormals = new Vector3D[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            int[] vertexIndices = faces[i];
            Vector3D normal = null;
            for (int j = 0; j < vertexIndices.length; ++j) {
                Vector3D v1 = vertices[vertexIndices[j]];
                Vector3D v2 = vertices[vertexIndices[(j + 1) % vertexIndices.length]];
                Vector3D v3 = vertices[vertexIndices[(j + 2) % vertexIndices.length]];
                normal = v3.minus(v2).cross(v1.minus(v2));
                normal.normalize();
                if (!Double.isNaN(normal.x)) break;
            }
            if (normal == null) {
                normal = new Vector3D(0.0, 0.0, 1.0);
            }
            this.unitNormals[i] = normal;
        }
        this.clippedFaces = null;
        this.clippedEdges = null;
        this.forceRedraw();
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform3D, Transform3D newTransform3D) {
        if (this.clippedFaces == null || exhibitNeedsRedraw || !newTransform3D.hasSameProjection(previousTransform3D)) {
            this.clip(view);
        }
    }

    @Override
    protected void doDraw3D(VectorGraphics g, View3D view, Transform3D transform) {
        boolean wire = false;
        if (!(view instanceof View3DLit)) {
            wire = true;
        } else if (((View3DLit)view).getRenderingStyle() == 0) {
            wire = true;
        } else if (((View3DLit)view).getFastDrawing() && !((View3DLit)view).getDragAsSurface()) {
            wire = true;
        }
        if (wire) {
            boolean thickWireframe = true;
            if (view instanceof IFSView) {
                thickWireframe = ((IFSView)view).getThickWireframe();
            }
            Color saveColor = g.getColor();
            Stroke saveStroke = g.getStroke();
            BasicStroke wideStroke = new BasicStroke(transform.getDefaultStrokeSize() * 5.0f, 0, 0);
            BasicStroke normalStroke = new BasicStroke(transform.getDefaultStrokeSize(), 0, 0);
            for (Segment seg : this.clippedEdges) {
                if (seg.wd) {
                    g.setStroke((Stroke)wideStroke);
                    g.setColor(thickWireframe ? saveColor : g.getBackground());
                } else {
                    g.setStroke((Stroke)normalStroke);
                    g.setColor(thickWireframe ? g.getBackground() : saveColor);
                }
                view.drawLine(seg.v1, seg.v2);
            }
            g.setColor(saveColor);
            g.setStroke(saveStroke);
        } else {
            View3DLit vl = (View3DLit)view;
            int sidesToDraw = -1;
            if (view instanceof IFSView) {
                sidesToDraw = ((IFSView)view).sidesToDraw;
            }
            if (sidesToDraw < 0) {
                sidesToDraw = this.clippedFaces.size();
            }
            int opaqueness = (int)(255.0 * (1.0 - vl.getTransparency()));
            for (int f = 0; f < sidesToDraw; ++f) {
                Face face = this.clippedFaces.get(f);
                if (vl.getLightingEnabled()) {
                    Color c = PhongLighting.phongLightingColor(face.unitNormal, vl, vl.getTransform3D(), face.centerPoint, Color.white);
                    if (opaqueness < 255) {
                        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), opaqueness);
                    }
                    view.setColor(c);
                } else {
                    view.setColor(Color.WHITE);
                }
                Vector3D[] v = new Vector3D[face.vertexIndices.length];
                for (int i = 0; i < face.vertexIndices.length; ++i) {
                    v[i] = this.vertices[face.vertexIndices[i]];
                }
                vl.fillPolygon(v, Color.BLACK);
            }
        }
    }

    @Override
    public View getDefaultView() {
        return new IFSView();
    }

    @Override
    public Animation getCreateAnimation(View view) {
        if (!(view instanceof IFSView)) {
            return null;
        }
        final IFSView ifsView = (IFSView)view;
        return new TimerAnimation(-1, 200){

            @Override
            protected void drawFrame() {
                ifsView.sidesToDraw++;
                if (IFS.this.clippedFaces != null && ifsView.sidesToDraw >= IFS.this.clippedFaces.size()) {
                    this.cancel();
                } else {
                    if (IFS.this.clippedFaces != null && this.getMillisecondsPerFrame() * IFS.this.clippedFaces.size() > 3000) {
                        this.setMillisecondsPerFrame(3000 / IFS.this.clippedFaces.size());
                    }
                    IFS.this.fireExhibitChangeEvent();
                }
            }

            @Override
            protected void animationStarting() {
                ifsView.sidesToDraw = 0;
                IFS.this.fireExhibitChangeEvent();
            }

            @Override
            protected void animationEnding() {
                ifsView.sidesToDraw = -1;
                IFS.this.fireExhibitChangeEvent();
            }
        };
    }

    @Override
    public ActionList getActionsForView(View view) {
        ActionList actions = super.getActionsForView(view);
        if (view instanceof IFSView) {
            actions.add(null);
            actions.add(((IFSView)view).thickWireframeToggle);
        }
        return actions;
    }

    private void clip(View3D view) {
        Transform3D transform = view.getTransform3D();
        this.clippedFaces = new ArrayList();
        block0: for (int f = 0; f < this.faces.length; ++f) {
            int[] faceData;
            for (int i : faceData = this.faces[f]) {
                if (view.clip(this.vertices[i])) continue block0;
            }
            Face face = new Face(faceData, this.unitNormals[f]);
            this.clippedFaces.add(face);
        }
        for (Face face : this.clippedFaces) {
            face.computeZ(transform);
        }
        Collections.sort(this.clippedFaces);
        this.clippedEdges = new ArrayList();
        for (int[] edge : this.edges) {
            Vector3D v1 = this.vertices[edge[0]];
            Vector3D v2 = this.vertices[edge[1]];
            Vector3D dv = v2.minus(v1).times(1.0 / (double)this.edgeDivisor);
            Vector3D v = v1;
            for (int i = 0; i < this.edgeDivisor; ++i) {
                Vector3D w;
                Vector3D vector3D = w = i == this.edgeDivisor - 1 ? v2 : v1.plus(dv.times(i));
                if (!view.clip(v) && !view.clip(w)) {
                    this.clippedEdges.add(new Segment(v, w, true));
                    this.clippedEdges.add(new Segment(v, w, false));
                }
                v = w;
            }
        }
        for (Segment seg : this.clippedEdges) {
            seg.computeZ(transform);
        }
        Collections.sort(this.clippedEdges);
    }

    public static class IFSView
    extends View3DLit {
        private int sidesToDraw = -1;
        @VMMSave
        private boolean thickWireframe = true;
        protected ToggleAction thickWireframeToggle = new ToggleAction(I18n.tr("vmm.polyhedron.IFS.thickWireframe"), true){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IFSView.this.setThickWireframe(this.getState());
            }
        };

        public IFSView() {
            this.setAntialiased(true);
            this.setDragAsSurface(true);
        }

        public boolean getThickWireframe() {
            return this.thickWireframe;
        }

        public void setThickWireframe(boolean thickWireframe) {
            if (this.thickWireframe == thickWireframe) {
                return;
            }
            this.thickWireframe = thickWireframe;
            this.thickWireframeToggle.setState(thickWireframe);
            this.forceRedraw();
        }
    }

    private class Segment
    implements Comparable<Segment> {
        Vector3D v1;
        Vector3D v2;
        double centerZ;
        boolean wd;

        Segment(Vector3D v1, Vector3D v2, boolean wd) {
            this.v1 = v1;
            this.v2 = v2;
            this.wd = wd;
        }

        void computeZ(Transform3D transform) {
            this.centerZ = this.wd ? 1024.0 * Math.min(transform.objectToViewZ(this.v1), transform.objectToViewZ(this.v2)) : 1024.0 * Math.max(transform.objectToViewZ(this.v1), transform.objectToViewZ(this.v2)) + 8.0;
        }

        @Override
        public int compareTo(Segment seg) {
            if (this.centerZ == seg.centerZ) {
                return 0;
            }
            if (this.centerZ < seg.centerZ) {
                return -1;
            }
            return 1;
        }
    }

    private class Face
    implements Comparable<Face> {
        int[] vertexIndices;
        Vector3D unitNormal;
        Vector3D centerPoint;
        double centerZ;
        boolean isBackFace;

        Face(int[] indices, Vector3D unitNormal) {
            this.vertexIndices = indices;
            this.unitNormal = unitNormal;
            this.centerPoint = IFS.this.vertices[this.vertexIndices[0]];
            for (int i = 1; i < this.vertexIndices.length; ++i) {
                this.centerPoint = this.centerPoint.plus(IFS.this.vertices[this.vertexIndices[i]]);
            }
            this.centerPoint = this.centerPoint.times(1.0 / (double)this.vertexIndices.length);
        }

        void computeZ(Transform3D transform) {
            this.centerZ = 0.0;
            for (int index : this.vertexIndices) {
                this.centerZ += transform.objectToViewZ(IFS.this.vertices[index]);
            }
            this.centerZ /= (double)this.vertexIndices.length;
            if (IFS.this.useBackFaceFudge) {
                if (transform.getOrthographicProjection()) {
                    this.isBackFace = this.unitNormal.dot(transform.getViewDirection()) <= 0.0;
                } else {
                    Vector3D patchCG = IFS.this.vertices[this.vertexIndices[0]];
                    for (int i = 1; i < this.vertexIndices.length; ++i) {
                        patchCG = patchCG.plus(IFS.this.vertices[this.vertexIndices[i]]);
                    }
                    this.isBackFace = this.unitNormal.dot((patchCG = patchCG.times(1.0 / (double)this.vertexIndices.length)).minus(transform.getViewPoint())) <= 0.0;
                }
            } else {
                this.isBackFace = false;
            }
        }

        @Override
        public int compareTo(Face face) {
            if (this.isBackFace == face.isBackFace) {
                if (this.centerZ == face.centerZ) {
                    return 0;
                }
                if (this.centerZ < face.centerZ) {
                    return -1;
                }
                return 1;
            }
            if (this.isBackFace) {
                return -1;
            }
            return 1;
        }
    }
}

