/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.ode.secondorder3D;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Display;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.Util;
import vmm3d.core.View;
import vmm3d.core3D.BasicMouseTask3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;
import vmm3d.ode.ODE_3D;

public abstract class ChargedParticles
extends ODE_3D {
    public ChargedParticles() {
        super(false, true, "x", "y", "z", "x'", "y'", "z'");
        this.showAxes = true;
    }

    @Override
    protected void nextEulerPoint(double[] pointData, double dt) {
        Vector3D deriv = new Vector3D();
        double x = pointData[0];
        double y = pointData[1];
        double z = pointData[2];
        double xdot = pointData[3];
        double ydot = pointData[4];
        double zdot = pointData[5];
        this.dotdot(x, y, z, xdot, ydot, zdot, deriv);
        pointData[0] = x + dt * xdot;
        pointData[1] = y + dt * ydot;
        pointData[2] = z + dt * zdot;
        pointData[3] = xdot + dt * deriv.x;
        pointData[4] = ydot + dt * deriv.y;
        pointData[5] = zdot + dt * deriv.z;
    }

    @Override
    protected void nextRungeKuttaPoint(double[] pointData, double dt) {
        Vector3D deriv = new Vector3D();
        double x = pointData[0];
        double y = pointData[1];
        double z = pointData[2];
        double xdot = pointData[3];
        double ydot = pointData[4];
        double zdot = pointData[5];
        double i1 = dt * xdot;
        double j1 = dt * ydot;
        double m1 = dt * zdot;
        this.dotdot(x, y, z, xdot, ydot, zdot, deriv);
        double h1 = dt * deriv.x;
        double k1 = dt * deriv.y;
        double n1 = dt * deriv.z;
        double i2 = dt * (xdot + h1 / 2.0);
        double j2 = dt * (ydot + k1 / 2.0);
        double m2 = dt * (zdot + n1 / 2.0);
        this.dotdot(x + i1 / 2.0, y + j1 / 2.0, z + m1 / 2.0, xdot + h1 / 2.0, ydot + k1 / 2.0, zdot + n1 / 2.0, deriv);
        double h2 = dt * deriv.x;
        double k2 = dt * deriv.y;
        double n2 = dt * deriv.z;
        double i3 = dt * (xdot + h2 / 2.0);
        double j3 = dt * (ydot + k2 / 2.0);
        double m3 = dt * (zdot + n2 / 2.0);
        this.dotdot(x + i2 / 2.0, y + j2 / 2.0, z + m2 / 2.0, xdot + h2 / 2.0, ydot + k2 / 2.0, zdot + n2 / 2.0, deriv);
        double h3 = dt * deriv.x;
        double k3 = dt * deriv.y;
        double n3 = dt * deriv.z;
        double i4 = dt * (xdot + h3);
        double j4 = dt * (ydot + k3);
        double m4 = dt * (zdot + n3);
        this.dotdot(x + i3, y + j3, z + m3, xdot + h3, ydot + k3, zdot + n3, deriv);
        double h4 = dt * deriv.x;
        double k4 = dt * deriv.y;
        double n4 = dt * deriv.z;
        double dx = i1 / 6.0 + i2 / 3.0 + i3 / 3.0 + i4 / 6.0;
        double dy = j1 / 6.0 + j2 / 3.0 + j3 / 3.0 + j4 / 6.0;
        double dz = m1 / 6.0 + m2 / 3.0 + m3 / 3.0 + m4 / 6.0;
        double dxdot = h1 / 6.0 + h2 / 3.0 + h3 / 3.0 + h4 / 6.0;
        double dydot = k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        double dzdot = n1 / 6.0 + n2 / 3.0 + n3 / 3.0 + n4 / 6.0;
        pointData[0] = x + dx;
        pointData[1] = y + dy;
        pointData[2] = z + dz;
        pointData[3] = xdot + dxdot;
        pointData[4] = ydot + dydot;
        pointData[5] = zdot + dzdot;
    }

    private void dotdot(double x, double y, double z, double xdot, double ydot, double zdot, Vector3D answer) {
        this.magneticField(x, y, z, answer);
        Vector3D magfield = new Vector3D();
        this.magneticField(x, y, z, magfield);
        double magX = magfield.x;
        double magY = magfield.y;
        double magZ = magfield.z;
        answer.x = magY * zdot - magZ * ydot;
        answer.y = magZ * xdot - magX * zdot;
        answer.z = magX * ydot - magY * xdot;
    }

    protected abstract void magneticField(double var1, double var3, double var5, Vector3D var7);

    @Override
    protected MouseTask makeDefaultMouseTask(ODE_3D.ODEView view) {
        return new ThrowIt();
    }

    private class ThrowIt
    extends BasicMouseTask3D {
        int startX;
        int startY;
        int currentX;
        int currentY;
        boolean throwing;

        private ThrowIt() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isAltDown()) {
                this.throwing = true;
                this.startX = this.currentX = evt.getX();
                this.startY = this.currentY = evt.getY();
                return true;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.throwing) {
                this.currentX = evt.getX();
                this.currentY = evt.getY();
                view.forceRedraw();
            } else {
                super.doMouseDrag(evt, display, view, width, height);
            }
        }

        @Override
        public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.throwing) {
                this.throwing = false;
                ODE_3D.ODEView odeView = (ODE_3D.ODEView)view;
                Vector3D pt1 = ChargedParticles.this.screenPointTo3DPoint(odeView, this.startX, this.startY);
                Vector3D pt2 = ChargedParticles.this.screenPointTo3DPoint(odeView, this.currentX, this.currentY);
                double[] data = new double[]{pt1.x, pt1.y, pt1.z, pt2.x - pt1.x, pt2.y - pt1.y, pt2.z - pt1.z};
                ((ODE_3D.ODEView)view).startOrbitAtPoint(data);
            } else {
                super.doMouseUp(evt, display, view, width, height);
            }
        }

        @Override
        public void drawWhileDragging(VectorGraphics g, Display display, View view, int width, int height) {
            if (this.throwing) {
                if (((View3D)view).getViewStyle() == 1) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(view.getForeground());
                }
                g.drawLine(this.startX, this.startY, this.currentX, this.currentY);
            } else {
                super.drawWhileDragging(g, display, view, width, height);
            }
        }

        @Override
        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.secondorder2D.mouseTaskStatusText");
        }
    }
}

