/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.ode.firstorder1D;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import vmm3d.core.BasicMouseTask2D;
import vmm3d.core.Display;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.Util;
import vmm3d.core.View;
import vmm3d.ode.ODE_1D;
import vmm3d.ode.ODE_2D;

public abstract class ODE1stOrder1D
extends ODE_1D {
    @Override
    protected void nextEulerPoint(double[] pointData, double dt) {
        double x1 = pointData[0];
        double x2 = pointData[1];
        double dx1 = dt * this.x1Prime(x1, x2);
        double dx2 = dt * this.x2Prime(x1, x2);
        pointData[0] = x1 + dx1;
        pointData[1] = x2 + dx2;
    }

    @Override
    protected final double vectorField_x(double x, double y, double t) {
        return this.x1Prime(x, y);
    }

    @Override
    protected final double vectorField_y(double x, double y, double t) {
        return this.x2Prime(x, y);
    }

    @Override
    protected void nextRungeKuttaPoint(double[] pointData, double dt) {
        double x1 = pointData[0];
        double x2 = pointData[1];
        double h1 = dt * this.x1Prime(x1, x2);
        double k1 = dt * this.x2Prime(x1, x2);
        double h2 = dt * this.x1Prime(x1 + h1 / 2.0, x2 + k1 / 2.0);
        double k2 = dt * this.x2Prime(x1 + h1 / 2.0, x2 + k1 / 2.0);
        double h3 = dt * this.x1Prime(x1 + h2 / 2.0, x2 + k2 / 2.0);
        double k3 = dt * this.x2Prime(x1 + h2 / 2.0, x2 + k2 / 2.0);
        double h4 = dt * this.x1Prime(x1 + h3, x2 + k3);
        double k4 = dt * this.x2Prime(x1 + h3, x2 + k3);
        double dx1 = h1 / 6.0 + h2 / 3.0 + h3 / 3.0 + h4 / 6.0;
        double dx2 = k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        pointData[0] = x1 + dx1;
        pointData[1] = x2 + dx2;
    }

    public ODE1stOrder1D() {
        super(true, true, "t", "y");
        this.addProjectedOrbitsAction = false;
    }

    @Override
    protected MouseTask makeDefaultMouseTask(ODE_2D.ODEView view) {
        return new StartOrbit();
    }

    private class StartOrbit
    extends BasicMouseTask2D {
        private StartOrbit() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isAltDown()) {
                ODE_2D.ODEView odeView = (ODE_2D.ODEView)view;
                Point2D.Double pt = new Point2D.Double(evt.getX(), evt.getY());
                view.getTransform().viewportToWindow(pt);
                odeView.startOrbitAtPoint(new double[]{((Point2D)pt).getX(), ((Point2D)pt).getY()});
                return false;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText");
        }
    }
}

