/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.functions;

import java.util.ArrayList;
import vmm3d.functions.ComplexVariable;
import vmm3d.functions.EvalStack;
import vmm3d.functions.StackOp;
import vmm3d.functions.Type;
import vmm3d.functions.Variable;

final class ProgFunction {
    private ProgCommand[] commands;
    private int argCount;
    private Type argType;
    private Type type;

    private ProgFunction() {
    }

    int getArgCount() {
        return this.argCount;
    }

    Type getArgType() {
        return this.argType;
    }

    Type getType() {
        return this.type;
    }

    void apply(EvalStack stack) {
        if (this.argCount == 0) {
            for (ProgCommand command : this.commands) {
                command.apply(stack);
            }
        } else {
            int sizeOfArgBlock = this.argType == Type.COMPLEX ? 2 * this.argCount : this.argCount;
            stack.startFunctionCall(sizeOfArgBlock);
            for (ProgCommand command : this.commands) {
                command.apply(stack);
            }
            if (this.type == Type.COMPLEX) {
                stack.endComplexValuedFunction(sizeOfArgBlock);
            } else {
                stack.endRealValuedFunction(sizeOfArgBlock);
            }
        }
    }

    static /* synthetic */ ProgCommand[] access$402(ProgFunction x0, ProgCommand[] x1) {
        x0.commands = x1;
        return x1;
    }

    private class FunctionRef
    extends ProgCommand {
        ProgFunction func;

        FunctionRef(ProgFunction f) {
            this.func = f;
        }

        @Override
        void apply(EvalStack stack) {
            this.func.apply(stack);
        }
    }

    private class ComplexVarRef
    extends ProgCommand {
        ComplexVariable variable;

        ComplexVarRef(ComplexVariable v) {
            this.variable = v;
        }

        @Override
        void apply(EvalStack stack) {
            stack.push(this.variable.getRe(), this.variable.getIm());
        }
    }

    private class VarRef
    extends ProgCommand {
        Variable variable;

        VarRef(Variable v) {
            this.variable = v;
        }

        @Override
        void apply(EvalStack stack) {
            stack.push(this.variable.getVal());
        }
    }

    private class ComplexConstRef
    extends ConstRef {
        double im;

        ComplexConstRef(double re, double im) {
            super(re);
            this.im = im;
        }

        @Override
        void apply(EvalStack stack) {
            stack.push(this.re, this.im);
        }
    }

    private class ConstRef
    extends ProgCommand {
        double re;

        ConstRef(double x) {
            this.re = x;
        }

        @Override
        void apply(EvalStack stack) {
            stack.push(this.re);
        }
    }

    private class Conditional
    extends ProgCommand {
        ProgCommand[] trueCase;
        ProgCommand[] falseCase;

        Conditional(ArrayList<ProgCommand> trueCase, ArrayList<ProgCommand> falseCase) {
            this.trueCase = new ProgCommand[trueCase.size()];
            trueCase.toArray(this.trueCase);
            this.falseCase = new ProgCommand[falseCase.size()];
            falseCase.toArray(this.falseCase);
        }

        @Override
        void apply(EvalStack stack) {
            if (stack.pop() == 0.0) {
                for (ProgCommand c : this.falseCase) {
                    c.apply(stack);
                }
            } else {
                for (ProgCommand c : this.trueCase) {
                    c.apply(stack);
                }
            }
        }
    }

    private class StackOpRef
    extends ProgCommand {
        StackOp op;

        StackOpRef(StackOp op) {
            this.op = op;
        }

        @Override
        void apply(EvalStack stack) {
            stack.apply(this.op);
        }
    }

    private class ArgRef
    extends ProgCommand {
        int argNum;

        ArgRef(int argNum) {
            this.argNum = argNum;
        }

        @Override
        void apply(EvalStack stack) {
            if (ProgFunction.this.argType == Type.COMPLEX) {
                stack.fetchComplex(this.argNum * 2);
            } else {
                stack.fetch(this.argNum);
            }
        }
    }

    private abstract class ProgCommand {
        private ProgCommand() {
        }

        abstract void apply(EvalStack var1);
    }

    static class Builder {
        private ProgFunction func;
        private ArrayList<ProgCommand> commands;
        private ArrayList<ProgCommand> currentSubProg;
        private ArrayList<ArrayList<ProgCommand>> pendingSubProgs;
        private ArrayList<ArrayList<ProgCommand>> subProgs;
        private ArrayList<ConstRef> constants;

        Builder() {
        }

        private void add(ProgCommand command) {
            assert (this.func != null);
            assert (command != null);
            if (this.currentSubProg != null) {
                this.currentSubProg.add(command);
            } else {
                this.commands.add(command);
            }
        }

        void start(int argCount, Type argType) {
            assert (this.func == null);
            this.func = new ProgFunction();
            this.func.argType = argType;
            this.func.argCount = argCount;
            this.commands = new ArrayList();
        }

        void addStackOp(StackOp op) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new StackOpRef(op));
        }

        void addArgumentReference(int argumentNumber) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new ArgRef(argumentNumber));
        }

        void addConditional(int trueCaseProgNum, int falseCaseProgNum, boolean trueCaseNeedsRealToComplex) {
            if (trueCaseNeedsRealToComplex) {
                ProgFunction progFunction = this.func;
                progFunction.getClass();
                this.subProgs.get(trueCaseProgNum).add(progFunction.new StackOpRef(StackOp.REAL_TO_COMPLEX));
            }
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new Conditional(this.subProgs.get(trueCaseProgNum), this.subProgs.get(falseCaseProgNum)));
        }

        void addFunctionRef(ProgFunction func) {
            ProgFunction progFunction = func;
            progFunction.getClass();
            this.add(progFunction.new FunctionRef(func));
        }

        void addRealConstant(double x) {
            if (this.constants == null) {
                this.constants = new ArrayList();
            }
            for (ConstRef c : this.constants) {
                if (c instanceof ComplexConstRef || c.re != x) continue;
                this.add(c);
                return;
            }
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            ConstRef c = progFunction.new ConstRef(x);
            this.constants.add(c);
            this.add(c);
        }

        void addComplexConstant(double re, double im) {
            if (this.constants == null) {
                this.constants = new ArrayList();
            }
            for (ConstRef c : this.constants) {
                if (!(c instanceof ComplexConstRef) || c.re != re || ((ComplexConstRef)c).im != im) continue;
                this.add(c);
                return;
            }
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            ComplexConstRef c = progFunction.new ComplexConstRef(re, im);
            this.constants.add(c);
            this.add(c);
        }

        void addVariableRef(Variable v) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new VarRef(v));
        }

        void addComplexVariableRef(ComplexVariable v) {
            ProgFunction progFunction = this.func;
            progFunction.getClass();
            this.add(progFunction.new ComplexVarRef(v));
        }

        int startSubProg() {
            assert (this.func != null);
            if (this.currentSubProg != null) {
                this.pendingSubProgs = new ArrayList();
                this.pendingSubProgs.add(this.currentSubProg);
            }
            this.currentSubProg = new ArrayList();
            if (this.subProgs == null) {
                this.subProgs = new ArrayList();
            }
            this.subProgs.add(this.currentSubProg);
            return this.subProgs.size() - 1;
        }

        void finishSubProg() {
            assert (this.currentSubProg != null);
            this.currentSubProg = this.pendingSubProgs != null && this.pendingSubProgs.size() > 0 ? this.pendingSubProgs.remove(this.pendingSubProgs.size() - 1) : null;
        }

        ProgFunction finish(Type valueType) {
            assert (this.func != null);
            assert (this.currentSubProg == null);
            this.func.type = valueType;
            ProgFunction.access$402(this.func, new ProgCommand[this.commands.size()]);
            this.commands.toArray(this.func.commands);
            ProgFunction f = this.func;
            this.reset();
            return f;
        }

        void reset() {
            this.func = null;
            this.commands = null;
            this.subProgs = null;
            this.currentSubProg = null;
            this.pendingSubProgs = null;
            this.constants = null;
        }
    }
}

