/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import org.freehep.graphics2d.VectorGraphics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.core.Axes2D;
import vmm3d.core.Display;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.Prefs;
import vmm3d.core.SaveAndRestore;
import vmm3d.core.Transform;
import vmm3d.core.Util;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Axes3D;
import vmm3d.core3D.BasicMouseTask3D;
import vmm3d.core3D.Grid3D;
import vmm3d.core3D.Set3DViewOptionsDialog;
import vmm3d.core3D.SetViewpointDialog;
import vmm3d.core3D.StereoComposite;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;

public class View3D
extends View {
    public static final int MONOCULAR_VIEW = 0;
    public static final int RED_GREEN_STEREO_VIEW = 1;
    public static final int STEREOGRAPH_VIEW = 2;
    public static final int CROSS_EYE_STEREO_VIEW = 3;
    @VMMSave
    private int viewStyle = 0;
    private Color savedBackground;
    @VMMSave
    private boolean enableThreeD = true;
    private Transform saveTransform2DWhileThreeDEnabled = null;
    private Transform saveTransform3DWhileThreeDDisabled = null;
    private int saveViewStyleWhile3DDisabled = -1;
    protected Transform3D transform3D;
    protected StereoComposite stereoComposite;
    private Rectangle leftEyeRect;
    private Rectangle rightEyeRect;
    private Dimension stereographPreferredSize;
    private Rectangle stereographPreferredLeftEyeRect;
    private Rectangle stereographPreferredRightEyeRect;
    private int saveStereographDisplayWidth;
    private int saveStereographDisplayHeight;
    private Dimension savePreferredSizeForStereograph;
    private VectorGraphics leftEyeGraphics;
    private VectorGraphics rightEyeGraphics;
    private VectorGraphics leftEyeUntransformedGraphics;
    private VectorGraphics rightEyeUntransformedGraphics;
    private VectorGraphics saveGraphicsDuringStereo;
    private VectorGraphics saveUntransformedGraphicsDuringStereo;
    private Vector3D viewDirection;
    private double clipZ;
    private double eyeSeparationMultiplier;
    protected BufferedImage leftStereographOSI;
    protected BufferedImage rightStereographOSI;
    protected ActionRadioGroup viewStyleCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm3d.core3D.commands.Monocular"), I18n.tr("vmm3d.core3D.commands.RedGreenStereo"), I18n.tr("vmm3d.core3D.commands.Stereograph"), I18n.tr("vmm3d.core3D.commands.CrossEyeStereo")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            View3D.this.setViewStyle(selectedIndex);
        }
    };
    protected ActionRadioGroup projectionCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm3d.core3D.commands.PerspectiveProjection"), I18n.tr("vmm3d.core3D.commands.OrthographicProjection")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            View3D.this.setOrthographicProjection(selectedIndex == 1);
        }
    };
    protected AbstractActionVMM setViewpointAction;
    protected AbstractActionVMM set3DViewOptionsAction;

    public int getViewStyle() {
        return this.viewStyle;
    }

    public void setViewStyle(int style) {
        if (style < 0 || style > 3) {
            return;
        }
        this.viewStyleCommands.setSelectedIndex(style);
        if (style == this.viewStyle) {
            return;
        }
        this.rightStereographOSI = null;
        this.leftStereographOSI = null;
        this.fullOSI = null;
        if (style == 1) {
            Color c = this.getBackground();
            this.setBackground(Color.BLACK);
            this.savedBackground = c;
            this.backgroundCommands.setEnabled(false);
        } else {
            if (this.viewStyle == 1 && this.savedBackground != null) {
                this.setBackground(this.savedBackground);
            }
            this.backgroundCommands.setEnabled(true);
        }
        if (style == 3 || style == 2) {
            this.enterStereographView(this.viewStyle, style);
        } else if (this.viewStyle == 3 || this.viewStyle == 2) {
            this.leaveStereographView();
        }
        this.viewStyle = style;
        if (this.transform3D != null) {
            if (this.viewStyle != 1 || !"yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"))) {
                this.transform3D.setObjectDisplacementNormalToScreen(0.0);
            } else if (this.getViewStyle() == 1 && this.getTransform3D() != null) {
                double extent = Math.max(this.getTransform3D().getXmaxRequested() - this.getTransform3D().getXminRequested(), this.getTransform3D().getYmaxRequested() - this.getTransform3D().getYminRequested());
                this.getTransform3D().setObjectDisplacementNormalToScreen(extent / 3.0);
            }
        }
        this.forceRedraw();
    }

    private void enterStereographView(int oldViewStyle, int viewStyle) {
        int dotsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
        if (dotsPerInch == 72 && Util.isMacOS()) {
            dotsPerInch = 100;
        }
        if (oldViewStyle != 3 && oldViewStyle != 2) {
            this.savePreferredSizeForStereograph = this.getDisplay() == null ? null : new Dimension(this.getDisplay().getWidth(), this.getDisplay().getHeight());
        }
        Dimension preferredSize = null;
        if (viewStyle == 3) {
            this.leftEyeRect = new Rectangle(dotsPerInch - 20, 5, 7 * dotsPerInch / 2, 7 * dotsPerInch / 2);
            this.rightEyeRect = new Rectangle(5 * dotsPerInch - 20, 5, 7 * dotsPerInch / 2, 7 * dotsPerInch / 2);
            preferredSize = new Dimension(19 * dotsPerInch / 2 - 40, 12 + 7 * dotsPerInch / 2);
        } else {
            this.leftEyeRect = new Rectangle(dotsPerInch - 20, 5, 5 * dotsPerInch / 2, 5 * dotsPerInch / 2);
            this.rightEyeRect = new Rectangle(dotsPerInch + 5 + 5 * dotsPerInch / 2, 5, 5 * dotsPerInch / 2, 5 * dotsPerInch / 2);
            preferredSize = new Dimension(-14 + 7 * dotsPerInch, 12 + 5 * dotsPerInch / 2);
        }
        this.stereographPreferredSize = preferredSize;
        this.stereographPreferredLeftEyeRect = (Rectangle)this.leftEyeRect.clone();
        this.stereographPreferredRightEyeRect = (Rectangle)this.rightEyeRect.clone();
        this.saveStereographDisplayWidth = preferredSize.width;
        this.saveStereographDisplayHeight = preferredSize.height;
        if (this.getDisplay() != null) {
            this.getDisplay().setPreferredSize(preferredSize);
            if (preferredSize.width > this.getDisplay().getWidth() || preferredSize.height > this.getDisplay().getHeight()) {
                double scale = Math.min((double)this.getDisplay().getWidth() / (double)preferredSize.width, (double)this.getDisplay().getHeight() / (double)preferredSize.height);
                this.leftEyeRect.x = (int)((double)this.leftEyeRect.x * scale);
                this.rightEyeRect.x = (int)((double)this.rightEyeRect.x * scale);
                this.leftEyeRect.width = this.rightEyeRect.width = (int)((double)this.leftEyeRect.width * scale);
                this.leftEyeRect.height = this.rightEyeRect.height = (int)((double)this.leftEyeRect.height * scale);
            }
            int left = (this.getDisplay().getWidth() - (this.rightEyeRect.x + this.rightEyeRect.width - this.leftEyeRect.x)) / 2;
            int top = (this.getDisplay().getHeight() - this.leftEyeRect.height) / 2;
            this.rightEyeRect.x += left - this.leftEyeRect.x;
            this.leftEyeRect.x = left;
            this.rightEyeRect.y = this.leftEyeRect.y = top;
            this.saveStereographDisplayWidth = this.getDisplay().getWidth();
            this.saveStereographDisplayHeight = this.getDisplay().getHeight();
        }
    }

    private void adjustStereographToNewSize(int width, int height) {
        this.leftEyeRect = (Rectangle)this.stereographPreferredLeftEyeRect.clone();
        this.rightEyeRect = (Rectangle)this.stereographPreferredRightEyeRect.clone();
        double scale = Math.min((double)width / (double)this.stereographPreferredSize.width, (double)height / (double)this.stereographPreferredSize.height);
        this.leftEyeRect.x = (int)((double)this.leftEyeRect.x * scale);
        this.rightEyeRect.x = (int)((double)this.rightEyeRect.x * scale);
        this.leftEyeRect.width = this.rightEyeRect.width = (int)((double)this.leftEyeRect.width * scale);
        this.leftEyeRect.height = this.rightEyeRect.height = (int)((double)this.leftEyeRect.height * scale);
        int left = (width - (this.rightEyeRect.x + this.rightEyeRect.width - this.leftEyeRect.x)) / 2;
        int top = (height - this.leftEyeRect.height) / 2;
        this.rightEyeRect.x += left - this.leftEyeRect.x;
        this.leftEyeRect.x = left;
        this.rightEyeRect.y = this.leftEyeRect.y = top;
        this.saveStereographDisplayWidth = width;
        this.saveStereographDisplayHeight = height;
    }

    private void leaveStereographView() {
        if (this.getDisplay() != null) {
            if (this.savePreferredSizeForStereograph == null) {
                this.getDisplay().setPreferredSize(new Dimension(800, 490));
            } else {
                this.getDisplay().setPreferredSize(this.savePreferredSizeForStereograph);
            }
        }
    }

    public void moveStereographImages(int offset) {
        if (this.viewStyle != 3 && this.viewStyle != 2) {
            return;
        }
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        if (offset < 0) {
            if (this.leftEyeRect.x + offset < 0) {
                offset = -this.leftEyeRect.x;
            }
            if (offset >= 0) {
                return;
            }
        } else {
            if (this.leftEyeRect.x + this.leftEyeRect.width + offset + 1 > this.rightEyeRect.x - offset - 1) {
                offset = (this.rightEyeRect.x - (this.leftEyeRect.x + this.leftEyeRect.width)) / 2 - 1;
            }
            if (offset <= 0) {
                return;
            }
        }
        this.leftEyeRect.x += offset;
        this.rightEyeRect.x -= offset;
        this.forceRedraw();
    }

    public Rectangle stereographLeftEyeRect() {
        return this.leftEyeRect;
    }

    public Rectangle stereographRightEyeRect() {
        return this.rightEyeRect;
    }

    public boolean getEnableThreeD() {
        return this.enableThreeD;
    }

    public void setEnableThreeD(boolean enable) {
        if (enable == this.enableThreeD) {
            return;
        }
        boolean showAxes = this.getShowAxes();
        if (showAxes) {
            this.setShowAxes(false);
        }
        this.enableThreeD = enable;
        if (showAxes) {
            this.setShowAxes(true);
        }
        if (this.enableThreeD) {
            this.saveTransform2DWhileThreeDEnabled = this.getTransform();
            if (this.saveTransform3DWhileThreeDDisabled != null) {
                this.setTransform(this.saveTransform3DWhileThreeDDisabled);
                this.saveTransform3DWhileThreeDDisabled = null;
            } else {
                this.setTransform(new Transform3D());
            }
            if (this.saveViewStyleWhile3DDisabled >= 0) {
                this.setViewStyle(this.saveViewStyleWhile3DDisabled);
                this.saveViewStyleWhile3DDisabled = -1;
            }
        } else {
            this.saveTransform3DWhileThreeDDisabled = this.getTransform();
            if (this.saveTransform2DWhileThreeDEnabled != null) {
                this.setTransform(this.saveTransform2DWhileThreeDEnabled);
                this.saveTransform2DWhileThreeDEnabled = null;
            } else {
                Transform3D tr = new Transform3D();
                if (this.getTransform() != null) {
                    tr.setLimits(this.getTransform().getXmin(), this.getTransform().getXmax(), this.getTransform().getYmin(), this.getTransform().getYmax());
                }
                this.setTransform(tr);
            }
            this.saveViewStyleWhile3DDisabled = this.getViewStyle();
            this.setViewStyle(0);
            this.setViewPoint(new Vector3D(1.0, 0.0, 0.0));
            this.setOrthographicProjection(true);
        }
        this.viewStyleCommands.setEnabled(this.enableThreeD);
        if (this.setViewpointAction != null) {
            this.setViewpointAction.setEnabled(this.enableThreeD);
        }
        this.projectionCommands.setEnabled(this.enableThreeD);
        this.forceRedraw();
    }

    public void setWindowForUseWhileThreeDDisabled(double xmin, double xmax, double ymin, double ymax) {
        if (!this.enableThreeD) {
            this.setWindow(xmin, xmax, ymin, ymax);
        } else {
            if (this.saveTransform2DWhileThreeDEnabled == null) {
                this.saveTransform2DWhileThreeDEnabled = new Transform3D();
            }
            this.saveTransform2DWhileThreeDEnabled.setLimits(xmin, xmax, ymin, ymax);
        }
    }

    protected Transform getSavedAuxiliaryTransformForEnableThreeD() {
        if (this.enableThreeD) {
            return this.saveTransform2DWhileThreeDEnabled;
        }
        return this.saveTransform3DWhileThreeDDisabled;
    }

    protected void setSavedAuxiliaryTransformForEnableThreeD(Transform transform) {
        if (this.enableThreeD) {
            this.saveTransform2DWhileThreeDEnabled = transform;
        } else {
            this.saveTransform3DWhileThreeDDisabled = transform;
        }
    }

    public boolean getOrthographicProjection() {
        if (this.transform3D == null) {
            return true;
        }
        return this.transform3D.getOrthographicProjection();
    }

    public void setOrthographicProjection(boolean orthographic) {
        if (this.transform3D != null) {
            this.transform3D.setOrthographicProjection(orthographic);
        }
    }

    public Vector3D getViewPoint() {
        if (this.transform3D == null) {
            return null;
        }
        return this.transform3D.getViewPoint();
    }

    public void setViewPoint(Vector3D viewpoint) {
        if (this.transform3D != null && !this.transform3D.getViewPoint().equals(viewpoint)) {
            this.transform3D.setViewPoint(viewpoint);
        }
    }

    public Vector3D getViewUp() {
        if (this.transform3D == null) {
            return null;
        }
        return this.transform3D.getImagePlaneYDirection();
    }

    public void setViewUp(Vector3D viewUp) {
        if (this.transform3D != null) {
            this.transform3D.setImagePlaneYDirection(viewUp);
        }
    }

    @Override
    public void setExhibit(Exhibit exhibit) {
        if (exhibit == this.getExhibit()) {
            return;
        }
        if (!this.enableThreeD) {
            this.saveTransform2DWhileThreeDEnabled = this.getTransform();
        }
        super.setExhibit(exhibit);
        this.transform3D = this.getTransform() != null && this.getTransform() instanceof Transform3D ? (Transform3D)this.getTransform() : null;
        this.savedBackground = null;
        if (exhibit != null && (this.viewStyle == 2 || this.viewStyle == 3)) {
            this.enterStereographView(0, this.viewStyle);
        }
        if (this.viewStyle == 1 && this.transform3D != null && "yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"))) {
            double extent = Math.max(this.transform3D.getXmaxRequested() - this.transform3D.getXminRequested(), this.transform3D.getYmaxRequested() - this.transform3D.getYminRequested());
            this.transform3D.setObjectDisplacementNormalToScreen(extent / 3.0);
        }
        if (!this.enableThreeD) {
            this.saveTransform3DWhileThreeDDisabled = this.getTransform();
            this.setTransform(this.saveTransform2DWhileThreeDEnabled);
            this.saveTransform2DWhileThreeDEnabled = null;
        }
    }

    @Override
    public void setTransform(Transform transform) {
        super.setTransform(transform);
        if (transform != null && transform instanceof Transform3D) {
            this.transform3D = (Transform3D)transform;
            this.projectionCommands.setSelectedIndex(this.transform3D.getOrthographicProjection() ? 1 : 0);
            if (this.viewStyle == 1 && "yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"))) {
                double extent = Math.max(this.transform3D.getXmaxRequested() - this.transform3D.getXminRequested(), this.transform3D.getYmaxRequested() - this.transform3D.getYminRequested());
                this.transform3D.setObjectDisplacementNormalToScreen(extent / 3.0);
            }
        } else {
            this.transform3D = null;
        }
    }

    @Override
    public void setDisplay(Display display) {
        super.setDisplay(display);
        if (this.getExhibit() != null && (this.viewStyle == 2 || this.viewStyle == 3)) {
            this.enterStereographView(0, this.viewStyle);
        } else {
            String anaglyphViewPref = Prefs.get("view3d.initialAnaglyphMode", "default");
            if (anaglyphViewPref.equalsIgnoreCase("always")) {
                if (this.enableThreeD) {
                    this.setViewStyle(1);
                } else {
                    this.saveViewStyleWhile3DDisabled = 1;
                }
            } else if (anaglyphViewPref.equalsIgnoreCase("never")) {
                if (this.enableThreeD) {
                    this.setViewStyle(0);
                } else {
                    this.saveViewStyleWhile3DDisabled = 0;
                }
            }
        }
    }

    @Override
    public void finish() {
        this.setViewStyle(0);
    }

    @Override
    public void takeExhibit(View view, boolean shareTransform) {
        this.savedBackground = null;
        if (!shareTransform || view.getTransform() == null || !(view.getTransform() instanceof Transform3D)) {
            super.takeExhibit(view, false);
            return;
        }
        if (view instanceof View3D) {
            this.setEnableThreeD(((View3D)view).getEnableThreeD());
        }
        super.takeExhibit(view, true);
        this.transform3D = (Transform3D)this.getTransform();
        if (view instanceof View3D) {
            View3D v3 = (View3D)view;
            if (this.enableThreeD) {
                this.saveTransform2DWhileThreeDEnabled = v3.saveTransform2DWhileThreeDEnabled;
                this.setViewStyle(v3.getViewStyle());
            } else {
                this.saveTransform3DWhileThreeDDisabled = v3.saveTransform3DWhileThreeDDisabled;
                this.saveViewStyleWhile3DDisabled = v3.saveViewStyleWhile3DDisabled;
            }
        }
    }

    public Transform3D getTransform3D() {
        if (this.getTransform() instanceof Transform3D) {
            return (Transform3D)this.getTransform();
        }
        return null;
    }

    @Override
    protected Axes2D createAxes() {
        if (this.enableThreeD) {
            return new Axes3D();
        }
        return new Axes2D();
    }

    @Override
    public MouseTask getDefaultMouseTask() {
        return new BasicMouseTask3D();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.savedBackground = null;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        super.stateChanged(evt);
        if (evt.getSource() instanceof Transform3D) {
            boolean isOrtho = ((Transform3D)evt.getSource()).getOrthographicProjection();
            this.projectionCommands.setSelectedIndex(isOrtho ? 1 : 0);
        }
    }

    @Override
    public ActionList getViewCommands() {
        ActionList commands = super.getViewCommands();
        commands.add(null);
        commands.add(this.projectionCommands);
        this.projectionCommands.setEnabled(this.enableThreeD);
        commands.add(null);
        commands.add(this.viewStyleCommands);
        return commands;
    }

    @Override
    public ActionList getSettingsCommands() {
        ActionList commands = super.getSettingsCommands();
        this.setViewpointAction = new AbstractActionVMM(I18n.tr("vmm3d.core3D.commands.SetViewpoint")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (View3D.this.getDisplay() != null) {
                    View3D.this.getDisplay().stopAnimation();
                }
                SetViewpointDialog.showDialog(View3D.this);
            }
        };
        this.set3DViewOptionsAction = new AbstractActionVMM(I18n.tr("vmm3d.core3D.commands.Set3DViewOptions") + "..."){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (View3D.this.getDisplay() != null) {
                    View3D.this.getDisplay().stopAnimation();
                }
                Set3DViewOptionsDialog.showDialog(View3D.this);
            }
        };
        commands.add(this.set3DViewOptionsAction);
        commands.add(null);
        this.setViewpointAction.setEnabled(this.enableThreeD);
        commands.add(this.setViewpointAction);
        return commands;
    }

    @Override
    protected boolean needsNewOSI(int width, int height) {
        if (this.viewStyle == 0 || this.viewStyle == 1) {
            return super.needsNewOSI(width, height);
        }
        return this.leftStereographOSI == null || width != this.saveStereographDisplayWidth || height != this.saveStereographDisplayHeight;
    }

    @Override
    protected void putOSI(VectorGraphics g, int width, int height) {
    }

    @Override
    protected void createOSI(int width, int height) {
        this.rightStereographOSI = null;
        this.leftStereographOSI = null;
        this.fullOSI = null;
        if (this.viewStyle == 0) {
            super.createOSI(width, height);
        } else if (this.viewStyle == 1) {
            if (this.stereoComposite == null) {
                this.stereoComposite = new StereoComposite();
            }
            this.stereoComposite.setSize(width, height);
            this.fullOSI = this.stereoComposite.getImage();
        } else if (this.viewStyle == 2 || this.viewStyle == 3) {
            if (width != this.saveStereographDisplayWidth || height != this.saveStereographDisplayHeight) {
                this.adjustStereographToNewSize(width, height);
            }
            this.leftStereographOSI = new BufferedImage(this.leftEyeRect.width, this.leftEyeRect.height, this.offscreenImageType);
            this.rightStereographOSI = new BufferedImage(this.leftEyeRect.width, this.leftEyeRect.height, this.offscreenImageType);
            this.fullOSI = this.leftStereographOSI;
        }
    }

    @Override
    protected void clearOSI() {
        if (this.viewStyle == 0) {
            super.clearOSI();
        } else if (this.viewStyle == 1) {
            VectorGraphics vg;
            VectorGraphics g = this.stereoComposite.getLeftEyeGraphics();
            if (g != null) {
                vg = VectorGraphics.create((Graphics)g);
                vg.setColor(Color.black);
                vg.fillRect(0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight());
                vg.setColor(Color.white);
            }
            g.dispose();
            g = this.stereoComposite.getRightEyeGraphics();
            if (g != null) {
                vg = VectorGraphics.create((Graphics)g);
                vg.setColor(Color.black);
                vg.fillRect(0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight());
                vg.setColor(Color.white);
            }
            g.dispose();
        } else {
            Graphics g = this.leftStereographOSI.getGraphics();
            VectorGraphics vg = VectorGraphics.create((Graphics)g);
            vg.setColor(this.getBackground());
            vg.fillRect(0, 0, this.leftEyeRect.width, this.leftEyeRect.height);
            vg.dispose();
            g = this.rightStereographOSI.getGraphics();
            vg = VectorGraphics.create((Graphics)g);
            vg.setColor(this.getBackground());
            vg.fillRect(0, 0, this.leftEyeRect.width, this.leftEyeRect.height);
            vg.dispose();
        }
    }

    @Override
    protected VectorGraphics prepareOSIForDrawing() {
        this.viewDirection = this.transform3D.getViewDirection();
        this.viewDirection.negate();
        this.clipZ = this.transform3D.getFocalLength() - this.transform3D.getClipDistance();
        this.eyeSeparationMultiplier = Prefs.getDouble("eyeSeparationMultiplier", 1.0);
        if (this.viewStyle == 0) {
            return super.prepareOSIForDrawing();
        }
        if (this.viewStyle == 1) {
            VectorGraphics g = this.getCurrentGraphics();
            if (g != null) {
                g.setColor(Color.white);
                g.setBackground(Color.black);
                if (this.getAntialiased()) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.getTransform().setUpDrawInfo(g, 0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight(), this.getPreserveAspect(), this.getApplyGraphics2DTransform());
                this.leftEyeGraphics = g;
                this.leftEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
            }
            if ((g = this.getCurrentGraphics()) != null) {
                g.setColor(Color.white);
                g.setBackground(Color.black);
                if (this.getAntialiased()) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                this.getTransform().setUpDrawInfo(g, 0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight(), this.getPreserveAspect(), this.getApplyGraphics2DTransform());
                this.rightEyeGraphics = g;
                this.rightEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
            }
            g = this.getCurrentGraphics();
            this.getTransform().setUpDrawInfo(g, 0, 0, this.stereoComposite.getWidth(), this.stereoComposite.getHeight(), this.getPreserveAspect(), this.getApplyGraphics2DTransform());
            this.currentGraphics = g;
            return g;
        }
        VectorGraphics g = this.getCurrentGraphics();
        g.setColor(this.getForeground());
        g.setBackground(this.getBackground());
        this.getTransform().setUpDrawInfo(g, 0, 0, this.leftEyeRect.width, this.leftEyeRect.height, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
        if (this.getAntialiased()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.rightEyeGraphics = g;
        this.rightEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
        g = (VectorGraphics)this.leftStereographOSI.getGraphics();
        if (this.getAntialiased()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor(this.getForeground());
        g.setBackground(this.getBackground());
        this.getTransform().setUpDrawInfo(g, 0, 0, this.leftEyeRect.width, this.leftEyeRect.height, this.getPreserveAspect(), this.getApplyGraphics2DTransform());
        this.leftEyeGraphics = g;
        this.leftEyeUntransformedGraphics = this.getTransform().getUntransformedGraphics();
        this.currentGraphics = g;
        return g;
    }

    @Override
    protected void finishOSIDraw() {
        if (this.viewStyle == 0) {
            super.finishOSIDraw();
        } else {
            this.leftEyeGraphics.dispose();
            this.rightEyeGraphics.dispose();
            if (this.leftEyeUntransformedGraphics != null) {
                this.leftEyeUntransformedGraphics.dispose();
            }
            if (this.rightEyeUntransformedGraphics != null) {
                this.rightEyeUntransformedGraphics.dispose();
            }
            if (this.viewStyle == 1) {
                this.stereoComposite.compose();
            }
        }
    }

    @Override
    public void addExtraXML(Document containingDocument, Element viewElement) {
        super.addExtraXML(containingDocument, viewElement);
        Transform savedTransform = this.getSavedAuxiliaryTransformForEnableThreeD();
        if (savedTransform != null) {
            Element transformElement = SaveAndRestore.makeTransformElement("savedtransform", containingDocument, savedTransform);
            viewElement.appendChild(transformElement);
        }
    }

    @Override
    public void readExtraXML(Element viewInfo) throws IOException {
        super.readExtraXML(viewInfo);
        Element savedtransformElement = SaveAndRestore.getChildElement(viewInfo, "savedtransform");
        if (savedtransformElement != null) {
            Transform transform = SaveAndRestore.buildTransformFromElement(savedtransformElement);
            this.setSavedAuxiliaryTransformForEnableThreeD(transform);
        }
    }

    public void drawPixel(Vector3D v) {
        Point2D.Double pt = new Point2D.Double();
        if (this.clip(v)) {
            return;
        }
        if (this.viewStyle == 0) {
            this.transform3D.objectToXYWindowCoords(v, pt);
            this.transform3D.windowToViewport(pt);
            this.drawPixelDirect(null, (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
        } else {
            this.setUpForLeftEye();
            this.transform3D.objectToXYWindowCoords(v, pt);
            this.transform3D.windowToViewport(pt);
            this.drawPixelDirect(null, (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
            this.setUpForRightEye();
            this.transform3D.objectToXYWindowCoords(v, pt);
            this.transform3D.windowToViewport(pt);
            this.drawPixelDirect(null, (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
            this.finishStereoView();
        }
    }

    public void drawDot(Vector3D pt, double diameter) {
        double h = diameter * this.transform3D.getPixelWidth();
        double w = diameter * this.transform3D.getPixelHeight();
        Point2D.Double pt2D = new Point2D.Double();
        if (this.viewStyle == 0) {
            this.transform3D.objectToDrawingCoords(pt, pt2D);
            this.currentGraphics.fill((Shape)new Ellipse2D.Double(((Point2D)pt2D).getX() - h / 2.0, ((Point2D)pt2D).getY() - w / 2.0, h, w));
        } else {
            this.setUpForLeftEye();
            this.transform3D.objectToDrawingCoords(pt, pt2D);
            this.currentGraphics.fill((Shape)new Ellipse2D.Double(((Point2D)pt2D).getX() - h / 2.0, ((Point2D)pt2D).getY() - w / 2.0, h, w));
            this.setUpForRightEye();
            this.transform3D.objectToDrawingCoords(pt, pt2D);
            this.currentGraphics.fill((Shape)new Ellipse2D.Double(((Point2D)pt2D).getX() - h / 2.0, ((Point2D)pt2D).getY() - w / 2.0, h, w));
            this.finishStereoView();
        }
    }

    public void drawPixels(Vector3D[] vlist) {
        Point2D.Double pt = new Point2D.Double();
        if (this.viewStyle == 0) {
            for (int i = 0; i < vlist.length; ++i) {
                if (vlist[i] == null || this.clip(vlist[i])) continue;
                this.transform3D.objectToXYWindowCoords(vlist[i], pt);
                this.transform3D.windowToViewport(pt);
                this.drawPixelDirect(null, (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
            }
        } else {
            int i;
            this.setUpForLeftEye();
            for (i = 0; i < vlist.length; ++i) {
                if (vlist[i] == null || this.clip(vlist[i])) continue;
                this.transform3D.objectToXYWindowCoords(vlist[i], pt);
                this.transform3D.windowToViewport(pt);
                this.drawPixelDirect(null, (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
            }
            this.setUpForRightEye();
            for (i = 0; i < vlist.length; ++i) {
                if (vlist[i] == null || this.clip(vlist[i])) continue;
                this.transform3D.objectToXYWindowCoords(vlist[i], pt);
                this.transform3D.windowToViewport(pt);
                this.drawPixelDirect(null, (int)((Point2D)pt).getX(), (int)((Point2D)pt).getY());
            }
            this.finishStereoView();
        }
    }

    public void drawLine(Vector3D v1, Vector3D v2) {
        if (this.clip(v1) || this.clip(v2)) {
            return;
        }
        if (this.viewStyle == 0) {
            Point2D p1 = this.transform3D.objectToDrawingCoords(v1);
            Point2D p2 = this.transform3D.objectToDrawingCoords(v2);
            this.currentGraphics.draw((Shape)new Line2D.Float(p1, p2));
        } else {
            this.setUpForLeftEye();
            Point2D p1 = this.transform3D.objectToDrawingCoords(v1);
            Point2D p2 = this.transform3D.objectToDrawingCoords(v2);
            this.currentGraphics.draw((Shape)new Line2D.Float(p1, p2));
            this.setUpForRightEye();
            p1 = this.transform3D.objectToDrawingCoords(v1);
            p2 = this.transform3D.objectToDrawingCoords(v2);
            this.currentGraphics.draw((Shape)new Line2D.Float(p1, p2));
            this.finishStereoView();
        }
    }

    public void drawString(String str, Vector3D basepoint) {
        if (this.clip(basepoint)) {
            return;
        }
        if (this.viewStyle == 0) {
            Point2D p = this.transform3D.objectToXYWindowCoords(basepoint);
            super.drawString(str, p.getX(), p.getY());
        } else {
            this.setUpForLeftEye();
            Point2D p = this.transform3D.objectToXYWindowCoords(basepoint);
            super.drawString(str, p.getX(), p.getY());
            this.setUpForRightEye();
            p = this.transform3D.objectToXYWindowCoords(basepoint);
            super.drawString(str, p.getX(), p.getY());
            this.finishStereoView();
        }
    }

    public void drawCurve(Vector3D[] points) {
        if (points != null) {
            this.drawCurve(points, points.length);
        }
    }

    public void drawCurve(Vector3D[] points, int pointCount) {
        this.drawCurve(points, 0, pointCount - 1);
    }

    public void drawCurve(Vector3D[] points, int startIndex, int endIndex) {
        if (points == null) {
            return;
        }
        if (startIndex >= points.length) {
            startIndex = points.length - 1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= points.length) {
            endIndex = points.length - 1;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex <= startIndex) {
            return;
        }
        Point2D[] projectedPoints = new Point2D[endIndex - startIndex + 1];
        if (this.viewStyle == 0) {
            for (int i = 0; i < projectedPoints.length; ++i) {
                projectedPoints[i] = points[i - startIndex] == null || this.clip(points[i - startIndex]) ? null : this.transform3D.objectToXYWindowCoords(points[i - startIndex]);
            }
            super.drawCurve(projectedPoints);
        } else {
            int i;
            this.setUpForLeftEye();
            for (i = 0; i < projectedPoints.length; ++i) {
                projectedPoints[i] = points[i - startIndex] == null || this.clip(points[i - startIndex]) ? null : this.transform3D.objectToXYWindowCoords(points[i - startIndex]);
            }
            super.drawCurve(projectedPoints);
            this.setUpForRightEye();
            for (i = 0; i < projectedPoints.length; ++i) {
                projectedPoints[i] = points[i - startIndex] == null || this.clip(points[i - startIndex]) ? null : this.transform3D.objectToXYWindowCoords(points[i - startIndex]);
            }
            super.drawCurve(projectedPoints);
            this.finishStereoView();
        }
    }

    public void drawCollaredCurve(Vector3D[] points, boolean reversed) {
        if (points != null) {
            this.drawCollaredCurve(points, 0, points.length - 1, reversed);
        }
    }

    public void drawCollaredCurve(Vector3D[] points, int pointCount, boolean reversed) {
        if (points != null) {
            this.drawCollaredCurve(points, 0, pointCount - 1, reversed);
        }
    }

    public void drawCollaredCurve(Vector3D[] points, int startIndex, int endIndex, boolean reversed) {
        if (points == null) {
            return;
        }
        if (!reversed && this.viewStyle != 0) {
            this.drawCurve(points, startIndex, endIndex);
            return;
        }
        if (startIndex >= points.length) {
            startIndex = points.length - 1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= points.length) {
            endIndex = points.length - 1;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex <= startIndex) {
            return;
        }
        if (this.viewStyle == 0) {
            this.drawCollaredCurveDirect(points, startIndex, endIndex, reversed);
        } else {
            this.setUpForLeftEye();
            this.drawCollaredCurveDirect(points, startIndex, endIndex, reversed);
            this.setUpForRightEye();
            this.drawCollaredCurveDirect(points, startIndex, endIndex, reversed);
            this.finishStereoView();
        }
    }

    public void drawWireframeSurface(Grid3D surfaceData) {
        if (this.getViewStyle() == 0) {
            surfaceData.applyTransform(this.transform3D, this);
            surfaceData.drawCurves(this, this.currentGraphics);
        } else {
            this.setUpForLeftEye();
            surfaceData.applyTransform(this.transform3D, this);
            surfaceData.drawCurves(this, this.currentGraphics);
            this.setUpForRightEye();
            surfaceData.applyTransform(this.transform3D, this);
            surfaceData.drawCurves(this, this.currentGraphics);
            this.finishStereoView();
        }
    }

    @Override
    public void drawPixelDirect(Color color, int x, int y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (color == null) {
            color = this.currentGraphics.getColor();
        }
        int rgb = color.getRGB();
        BufferedImage image = this.viewStyle == 1 ? (this.currentGraphics == this.leftEyeGraphics ? this.stereoComposite.getLeftEyeImage() : this.stereoComposite.getRightEyeImage()) : (this.viewStyle == 0 ? this.fullOSI : (this.currentGraphics == this.leftEyeGraphics ? this.leftStereographOSI : this.rightStereographOSI));
        if (x >= image.getWidth() || y >= image.getHeight()) {
            return;
        }
        image.setRGB(x, y, rgb);
    }

    private void drawCollaredCurveDirect(Vector3D[] points, int startIndex, int endIndex, boolean reversed) {
        Vector3D p1 = points[startIndex] == null ? null : this.transform3D.objectToViewCoords(points[startIndex]);
        ArrayList<CurveSegment> segments = new ArrayList<CurveSegment>();
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            Vector3D p2;
            Vector3D vector3D = p2 = points[i] == null || this.clip(points[i]) ? null : this.transform3D.objectToViewCoords(points[i]);
            if (p1 != null && p2 != null) {
                segments.add(new CurveSegment(p1, p2));
            }
            p1 = p2;
        }
        Collections.sort(segments);
        Color saveColor = this.currentGraphics.getColor();
        Stroke saveStroke = this.currentGraphics.getStroke();
        BasicStroke wideStroke = new BasicStroke(this.getTransform().getDefaultStrokeSize() * 5.0f, 0, 0);
        BasicStroke normalStroke = new BasicStroke(this.getTransform().getDefaultStrokeSize(), 0, 0);
        for (int i = 0; i < segments.size(); ++i) {
            this.currentGraphics.setStroke((Stroke)wideStroke);
            this.currentGraphics.setColor(reversed ? saveColor : this.currentGraphics.getBackground());
            this.currentGraphics.draw((Shape)segments.get(i));
            this.currentGraphics.setStroke((Stroke)normalStroke);
            this.currentGraphics.setColor(reversed ? this.currentGraphics.getBackground() : saveColor);
            this.currentGraphics.draw((Shape)segments.get(i));
        }
        this.currentGraphics.setColor(saveColor);
        this.currentGraphics.setStroke(saveStroke);
    }

    protected void setUpForLeftEye() {
        double separationFactor = this.viewStyle == 3 ? 0.04 : (this.viewStyle == 2 ? -0.03 : 0.03);
        this.transform3D.selectLeftEye(separationFactor *= this.eyeSeparationMultiplier);
        this.saveGraphicsDuringStereo = this.currentGraphics;
        this.saveUntransformedGraphicsDuringStereo = this.getTransform().getUntransformedGraphics();
        Color color = this.saveGraphicsDuringStereo.getColor();
        this.leftEyeGraphics.setColor(color);
        this.rightEyeGraphics.setColor(color);
        Stroke stroke = this.saveGraphicsDuringStereo.getStroke();
        this.leftEyeGraphics.setStroke(stroke);
        this.rightEyeGraphics.setStroke(stroke);
        Font font = this.saveGraphicsDuringStereo.getFont();
        this.leftEyeGraphics.setFont(font);
        this.rightEyeGraphics.setFont(font);
        this.transform3D.useGraphics(this.leftEyeGraphics, this.leftEyeUntransformedGraphics);
        this.currentGraphics = this.leftEyeGraphics;
    }

    protected void setUpForRightEye() {
        double separationFactor = this.viewStyle == 3 ? 0.04 : (this.viewStyle == 2 ? -0.03 : 0.03);
        this.transform3D.selectRightEye(separationFactor *= this.eyeSeparationMultiplier);
        this.transform3D.useGraphics(this.rightEyeGraphics, this.rightEyeUntransformedGraphics);
        this.currentGraphics = this.rightEyeGraphics;
    }

    protected void finishStereoView() {
        this.transform3D.selectNoEye();
        this.transform3D.useGraphics(this.saveGraphicsDuringStereo, this.saveUntransformedGraphicsDuringStereo);
        this.currentGraphics = this.saveGraphicsDuringStereo;
        this.saveGraphicsDuringStereo = null;
        this.saveUntransformedGraphicsDuringStereo = null;
    }

    public final boolean clip(Vector3D objectPoint) {
        return objectPoint.dot(this.viewDirection) > this.clipZ;
    }

    private class CurveSegment
    extends Line2D.Double
    implements Comparable<CurveSegment> {
        Vector3D v1;
        Vector3D v2;
        double midpoint_z;

        CurveSegment(Vector3D v1, Vector3D v2) {
            this.v1 = v1;
            this.v2 = v2;
            this.midpoint_z = (v1.z + v2.z) / 2.0;
            Point2D.Double p1 = new Point2D.Double(v1.x, v1.y);
            Point2D.Double p2 = new Point2D.Double(v2.x, v2.y);
            if (!View3D.this.getTransform().appliedTransform2D()) {
                View3D.this.getTransform().windowToViewport(p1);
                View3D.this.getTransform().windowToViewport(p2);
            }
            this.setLine(p1, p2);
        }

        @Override
        public int compareTo(CurveSegment c) {
            if (this.midpoint_z < c.midpoint_z) {
                return -1;
            }
            if (this.midpoint_z > c.midpoint_z) {
                return 1;
            }
            return 0;
        }
    }
}

