/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import vmm3d.core.I18n;
import vmm3d.core.SettingsDialog;
import vmm3d.core3D.View3DLit;

public class SetTransparencyDialog
extends SettingsDialog {
    private View3DLit view;
    private JSlider slider;
    private int originalPosition;

    public static void showDialog(View3DLit view) {
        new SetTransparencyDialog(view).setVisible(true);
    }

    private SetTransparencyDialog(View3DLit view) {
        super(view.getDisplay(), I18n.tr("vmm3d.core3D.commands.setTransparency"));
        this.view = view;
        double originalVal = view.getTransparency();
        this.originalPosition = (int)(255.0 * originalVal);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.slider = new JSlider(0, 255, this.originalPosition);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(0, new JLabel(I18n.tr("vmm3d.core3D.SetTransparencyDialog.Opaque")));
        labels.put(255, new JLabel(I18n.tr("vmm3d.core3D.SetTransparencyDialog.Transparent")));
        this.slider.setLabelTable(labels);
        this.slider.setPaintLabels(true);
        inputPanel.add((Component)this.slider, "Center");
        this.addInfoLabel(I18n.tr("vmm3d.core3D.SetTransparencyDialog.info"));
        this.addInputPanel(inputPanel);
    }

    @Override
    protected boolean doOK() {
        int position = this.slider.getValue();
        if (position != this.originalPosition) {
            double value = position <= 10 ? 0.0 : (double)position / 255.0;
            this.view.setTransparency(value);
            this.originalPosition = position;
        }
        return true;
    }

    @Override
    protected void doDefaults() {
        this.slider.setValue(0);
    }
}

