/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core3D;

import java.awt.Color;
import vmm3d.core3D.DirectionalLight;
import vmm3d.core3D.LightSettings;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3DLit;
import vmm3d.core3D.View3DWithLightSettings;

public class PhongLighting {
    static final float removalRatio = 0.6f;
    static float theReflectance;

    private static void getTheReflectance(Vector3D normal, Vector3D theDirection, View3DLit view) {
        boolean thePositiveSide = false;
        boolean theNegativeSide = true;
        int theOrientation = view.getOrientation();
        float c = (float)normal.dot(theDirection);
        boolean theSide = false;
        switch (theOrientation) {
            case 2: {
                break;
            }
            case 0: {
                if (c > 0.0f) {
                    theSide = false;
                    break;
                }
                theSide = true;
                break;
            }
            case 1: {
                theSide = c > 0.0f;
            }
        }
        theReflectance = theSide ? 0.675f : 1.0f;
    }

    private static float specularIntensityOfSource(Vector3D normal, Vector3D sourceHalfwayVector, View3DWithLightSettings view) {
        LightSettings currentLightSettings = view.getLightSettings();
        int specularExponent = currentLightSettings.getSpecularExponent();
        float g = (float)(-normal.dot(sourceHalfwayVector));
        g = (float)Math.max((double)g, 0.1);
        g = (float)Math.pow(g, specularExponent);
        return g;
    }

    private static Vector3D getDirectionInSpace(Vector3D theVector, Transform3D theTransform) {
        Vector3D viewDirection = theTransform.getViewDirection();
        Vector3D imagePlaneXDirection = theTransform.getImagePlaneXDirection();
        Vector3D imagePlaneYDirection = theTransform.getImagePlaneYDirection();
        Vector3D v1 = viewDirection.times(-theVector.z);
        Vector3D v2 = imagePlaneXDirection.times(theVector.x);
        Vector3D v3 = imagePlaneYDirection.times(theVector.y);
        return v1.plus(v2).plus(v3).normalized();
    }

    private static float addValues(float r0, float r1, float r2, float r3, float c0, float c1, float c2, float c3, float c4) {
        float sum;
        if (Math.abs(r0) + Math.abs(r1) + Math.abs(r2) + Math.abs(r3) == 0.0f) {
            r0 = 1.0f;
        }
        if ((sum = r0 * c0 + r1 * c1 + r2 * c2 + r3 * c3 + c4) < 0.0f) {
            return 0.0f;
        }
        if (sum > 1.0f) {
            return 1.0f;
        }
        return sum;
    }

    public static Color phongLightingColor(Vector3D normal, View3DWithLightSettings view, Transform3D transform, Vector3D location, Color intrinsicColor) {
        float redValue;
        float greenValue;
        float blueValue;
        int viewStyle = view.getViewStyle();
        Vector3D viewPoint = transform.getViewPoint();
        Vector3D viewDirection = transform.getViewDirection();
        Vector3D locationDirection = location.minus(viewPoint).normalized();
        float[] intrinsicColorValues = intrinsicColor.getColorComponents(null);
        LightSettings currentLightSettings = view.getLightSettings();
        Color source0Color = currentLightSettings.getLight0();
        DirectionalLight source1 = currentLightSettings.getDirectionalLight1();
        Color source1Color = source1.getItsColor();
        DirectionalLight source2 = currentLightSettings.getDirectionalLight2();
        Color source2Color = source2.getItsColor();
        DirectionalLight source3 = currentLightSettings.getDirectionalLight3();
        Color source3Color = source3.getItsColor();
        Color ambientColor = currentLightSettings.getAmbientLight();
        Vector3D source1DirectionInSpace = PhongLighting.getDirectionInSpace(source1.getItsDirection(), transform);
        Vector3D source2DirectionInSpace = PhongLighting.getDirectionInSpace(source2.getItsDirection(), transform);
        Vector3D source3DirectionInSpace = PhongLighting.getDirectionInSpace(source3.getItsDirection(), transform);
        Vector3D source0HalfwayVector = locationDirection.plus(viewDirection).normalized();
        Vector3D source1HalfwayVector = locationDirection.plus(source1DirectionInSpace).normalized().times(-1.0);
        Vector3D source2HalfwayVector = locationDirection.plus(source2DirectionInSpace).normalized().times(-1.0);
        Vector3D source3HalfwayVector = locationDirection.plus(source3DirectionInSpace).normalized().times(-1.0);
        Vector3D theDirection = view.getOrthographicProjection() ? viewDirection : locationDirection;
        Vector3D colorNormal = normal.dot(theDirection) <= 0.0 ? normal : normal.negated();
        if (view instanceof View3DLit) {
            PhongLighting.getTheReflectance(normal, theDirection, (View3DLit)view);
        } else {
            theReflectance = 1.0f;
        }
        float scat0 = theReflectance * (float)(-colorNormal.dot(locationDirection));
        float scat1 = theReflectance * (float)(-colorNormal.dot(source1DirectionInSpace));
        float scat2 = theReflectance * (float)(-colorNormal.dot(source2DirectionInSpace));
        float scat3 = theReflectance * (float)(-colorNormal.dot(source3DirectionInSpace));
        float spec0 = theReflectance * PhongLighting.specularIntensityOfSource(normal, source0HalfwayVector, view);
        float spec1 = theReflectance * PhongLighting.specularIntensityOfSource(normal, source1HalfwayVector, view);
        float spec2 = theReflectance * PhongLighting.specularIntensityOfSource(normal, source2HalfwayVector, view);
        float spec3 = theReflectance * PhongLighting.specularIntensityOfSource(normal, source3HalfwayVector, view);
        float tot0 = (1.0f - 0.6f * currentLightSettings.getSpecularRatio()) * scat0 + currentLightSettings.getSpecularRatio() * spec0;
        float tot1 = (1.0f - 0.6f * currentLightSettings.getSpecularRatio()) * scat1 + currentLightSettings.getSpecularRatio() * spec1;
        float tot2 = (1.0f - 0.6f * currentLightSettings.getSpecularRatio()) * scat2 + currentLightSettings.getSpecularRatio() * spec2;
        float tot3 = (1.0f - 0.6f * currentLightSettings.getSpecularRatio()) * scat3 + currentLightSettings.getSpecularRatio() * spec3;
        float[] source0ColorValues = source0Color.getColorComponents(null);
        float[] source1ColorValues = source1Color.getColorComponents(null);
        float[] source2ColorValues = source2Color.getColorComponents(null);
        float[] source3ColorValues = source3Color.getColorComponents(null);
        float[] ambientColorValues = ambientColor.getColorComponents(null);
        if (viewStyle == 1) {
            greenValue = blueValue = Math.min(Math.max(tot0, 0.0f), 1.0f);
            redValue = blueValue;
        } else {
            redValue = PhongLighting.addValues(tot0, tot1, tot2, tot3, source0ColorValues[0], source1ColorValues[0], source2ColorValues[0], source3ColorValues[0], ambientColorValues[0]);
            greenValue = PhongLighting.addValues(tot0, tot1, tot2, tot3, source0ColorValues[1], source1ColorValues[1], source2ColorValues[1], source3ColorValues[1], ambientColorValues[1]);
            blueValue = PhongLighting.addValues(tot0, tot1, tot2, tot3, source0ColorValues[2], source1ColorValues[2], source2ColorValues[2], source3ColorValues[2], ambientColorValues[2]);
        }
        return new Color(redValue * intrinsicColorValues[0], greenValue * intrinsicColorValues[1], blueValue * intrinsicColorValues[2]);
    }
}

