/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm3d.core.Exhibit;
import vmm3d.core.Filmstrip;
import vmm3d.core.I18n;
import vmm3d.core.IntegerParam;
import vmm3d.core.ParameterInput;
import vmm3d.core.SettingsDialog;
import vmm3d.core.View;

public class SetNumberOfFramesDialog
extends SettingsDialog {
    private Exhibit exhibit;
    private IntegerParam numberOfFramesForMorphing;
    private JCheckBox useFilmstripForMorphing;
    protected ParameterInput numberOfFramesForMorphingInput;

    public static void showDialog(View view) {
        new SetNumberOfFramesDialog(view).setVisible(true);
    }

    private SetNumberOfFramesDialog(View view) {
        super(view.getDisplay(), I18n.tr("vmm3d.core.dialogtitle.SetNumberOfFrames"), false, false);
        this.exhibit = view.getExhibit();
        this.numberOfFramesForMorphing = new IntegerParam(I18n.tr("vmm3d.core.SetNumberOfFramesDialog.FramesForMorphing", "x"), this.exhibit.getFramesForMorphing());
        this.numberOfFramesForMorphingInput = new ParameterInput(this.numberOfFramesForMorphing);
        this.numberOfFramesForMorphingInput.setColumns(4);
        this.numberOfFramesForMorphing.setMinimumValueForInput(2);
        this.numberOfFramesForMorphing.setMaximumValueForInput(1000);
        this.useFilmstripForMorphing = new JCheckBox(I18n.tr("vmm3d.core.SetNumberOfFramesDialog.UseFilmstrip"));
        this.useFilmstripForMorphing.setSelected(this.exhibit.getUseFilmstripForMorphing());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 1, 8, 8));
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout(8, 8));
        top.add((Component)this.numberOfFramesForMorphingInput, "Center");
        top.add((Component)new JLabel(this.numberOfFramesForMorphing.getName() + ": "), "West");
        panel.add(top);
        panel.add(this.useFilmstripForMorphing);
        int frames = Filmstrip.maxFrames(view.getDisplay().getWidth(), view.getDisplay().getHeight(), true);
        if (frames > 0) {
            --frames;
        }
        panel.add(new JLabel(I18n.tr("vmm3d.core.SetNumberOfFramesDialog.FramesAvailable", "" + frames), 4));
        this.addInputPanel(panel);
    }

    @Override
    protected boolean doOK() {
        String error = this.numberOfFramesForMorphingInput.checkContents();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        this.numberOfFramesForMorphingInput.setValueFromContents();
        this.exhibit.setFramesForMorphing(this.numberOfFramesForMorphing.getValue());
        this.exhibit.setUseFilmstripForMorphing(this.useFilmstripForMorphing.isSelected());
        return true;
    }
}

