/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import vmm3d.core.Util;

public class Filmstrip {
    private ArrayList<BufferedImage> images = new ArrayList();

    public static int maxFrames(int width, int height, boolean color) {
        long bytesPerFrame;
        long mem = Util.availableMemory() - 3000000L;
        int frames = (int)(mem / (bytesPerFrame = (long)(1000 + width * height * (color ? 4 : 1))));
        if (frames < 2) {
            frames = 0;
        }
        return frames;
    }

    public void setFrame(int frameNumber, BufferedImage image) {
        if (frameNumber < this.images.size()) {
            this.images.set(frameNumber, image);
        } else {
            while (this.images.size() < frameNumber - 1) {
                this.images.add(null);
            }
            this.images.add(image);
        }
    }

    public int getFrameCount() {
        return this.images.size();
    }

    public BufferedImage getFrame(int frameNumber) {
        return this.images.get(frameNumber);
    }

    public void stripNullFrames() {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            if (this.images.get(i) != null) continue;
            this.images.remove(i);
        }
    }
}

