/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.Animateable;
import vmm3d.core.Animation;
import vmm3d.core.AnimationLimitsDialog;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Decorateable;
import vmm3d.core.Decoration;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.ParameterDialog;
import vmm3d.core.Parameterizable;
import vmm3d.core.SetNumberOfFramesDialog;
import vmm3d.core.SetXYWindowDialog;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;

public abstract class Exhibit
implements Parameterizable,
Decorateable,
ChangeListener {
    private ArrayList<ChangeListener> changeListeners;
    private ArrayList<View> views;
    private ChangeEvent changeEvent;
    private String name;
    private Color defaultForeground = Color.black;
    private Color defaultBackground = Color.white;
    @VMMSave
    private double[] defaultWindow;
    @VMMSave
    private int framesForMorphing = 50;
    @VMMSave
    private boolean useFilmstripForMorphing;
    protected boolean isMorphing;
    protected View morphingView;
    protected ArrayList<Parameter> parameters;
    protected ArrayList<Decoration> decorations;
    protected boolean exhibitNeedsRedraw = true;
    protected Transform previousTransform;

    public String getName() {
        if (this.name == null) {
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return I18n.tr(this.getName());
    }

    public int getFramesForMorphing() {
        return this.framesForMorphing;
    }

    public void setFramesForMorphing(int framesForMorphing) {
        if (framesForMorphing > 1) {
            this.framesForMorphing = framesForMorphing;
        }
    }

    public boolean getUseFilmstripForMorphing() {
        return this.useFilmstripForMorphing;
    }

    public void setUseFilmstripForMorphing(boolean useFilmstripForMorphing) {
        this.useFilmstripForMorphing = useFilmstripForMorphing;
    }

    public void addExtraXML(Document containingDocument, Element exhibitElement) {
    }

    public void readExtraXML(Element exhibitInfo) throws IOException {
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener != null && this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireExhibitChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        if (this.isMorphing && this.morphingView != null) {
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                View v;
                if (!(this.changeListeners.get(i) instanceof View) || (v = (View)this.changeListeners.get(i)).getDisplay() != this.morphingView.getDisplay()) continue;
                v.stateChanged(this.changeEvent);
            }
        } else {
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                this.changeListeners.get(i).stateChanged(this.changeEvent);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.fireExhibitChangeEvent();
    }

    public Parameter[] getParameters() {
        if (this.parameters == null) {
            return new Parameter[0];
        }
        Parameter[] params = new Parameter[this.parameters.size()];
        for (int i = params.length - 1; i >= 0; --i) {
            params[params.length - i - 1] = this.parameters.get(i);
        }
        return params;
    }

    public Parameter getParameterByName(String name) {
        if (this.parameters != null && name != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!name.equals(this.parameters.get(i).getName())) continue;
                return this.parameters.get(i);
            }
        }
        return null;
    }

    protected void addParameter(Parameter param) {
        if (param == null) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        if (this.parameters.contains(param)) {
            return;
        }
        this.parameters.add(param);
        param.setOwner(this);
    }

    protected void removeParameter(Parameter param) {
        if (param == null || this.parameters == null || !this.parameters.contains(param)) {
            return;
        }
        this.parameters.remove(param);
        param.setOwner(null);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        this.forceRedraw();
    }

    public ActionList getActionsForView(final View view) {
        ActionList actions = new ActionList();
        AbstractActionVMM createAction = new AbstractActionVMM(I18n.tr("vmm3d.core.commands.Create"), "K"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Animation create = Exhibit.this.getCreateAnimation(view);
                if (create != null) {
                    if (view != null && view.getDisplay() != null) {
                        view.getDisplay().installAnimation(create);
                    } else {
                        create.start();
                    }
                } else {
                    Exhibit.this.forceRedraw();
                }
            }
        };
        actions.add(createAction);
        return actions;
    }

    public ActionList getSettingsCommandsForView(final View view) {
        ActionList commands = new ActionList();
        AbstractActionVMM setParametersAction = new AbstractActionVMM(I18n.tr("vmm3d.core.commands.SetParameters")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().stopAnimation();
                Parameter[] params = view.getViewAndExhibitParameters();
                ParameterDialog.showDialog(view.getDisplay(), I18n.tr("vmm3d.core.dialogtitle.SetParameters"), params);
            }
        };
        AbstractActionVMM setAnimationParametersAction = new AbstractActionVMM(I18n.tr("vmm3d.core.commands.SetAnimationParameters")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().stopAnimation();
                Parameter[] params = view.getViewAndExhibitParameters();
                AnimationLimitsDialog.showDialog(view.getDisplay(), I18n.tr("vmm3d.core.dialogtitle.SetAnimationParameters"), params);
            }
        };
        AbstractActionVMM setNumberOfFramesAction = new AbstractActionVMM(I18n.tr("vmm3d.core.commands.SetNumberOfFrames")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().stopAnimation();
                SetNumberOfFramesDialog.showDialog(view);
            }
        };
        AbstractActionVMM setXYLimitsAction = new AbstractActionVMM(I18n.tr("vmm3d.core.commands.SetXYWindow")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().stopAnimation();
                SetXYWindowDialog.showDialog(view);
            }
        };
        Parameter[] params = view.getViewAndExhibitParameters();
        boolean animated = false;
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof Animateable)) continue;
            animated = true;
            break;
        }
        setParametersAction.setEnabled(params.length > 0);
        setAnimationParametersAction.setEnabled(animated);
        setNumberOfFramesAction.setEnabled(animated);
        commands.add(setParametersAction);
        commands.add(setAnimationParametersAction);
        commands.add(setNumberOfFramesAction);
        commands.add(setXYLimitsAction);
        return commands;
    }

    public ActionList getAdditionalAnimationsForView(View view) {
        return new ActionList();
    }

    public void addView(View view) {
        if (view == null) {
            return;
        }
        if (this.views == null) {
            this.views = new ArrayList();
        }
        if (!this.views.contains(view)) {
            this.views.add(view);
        }
    }

    public void removeView(View view) {
        if (this.views != null) {
            this.views.remove(view);
        }
    }

    public ArrayList<View> getViews() {
        return this.views;
    }

    @Override
    public void addDecoration(Decoration d) {
        if (d == null) {
            return;
        }
        if (this.decorations == null) {
            this.decorations = new ArrayList();
        }
        if (this.decorations.contains(d)) {
            return;
        }
        this.decorations.add(d);
        d.addChangeListener(this);
        this.fireExhibitChangeEvent();
    }

    @Override
    public void removeDecoration(Decoration d) {
        if (this.decorations != null && d != null && this.decorations.contains(d)) {
            this.decorations.remove(d);
            d.removeChangeListener(this);
            if (this.decorations.size() == 0) {
                this.decorations = null;
            }
            this.fireExhibitChangeEvent();
        }
    }

    public void clearDecorations() {
        if (this.decorations != null) {
            for (int i = 0; i < this.decorations.size(); ++i) {
                this.decorations.get(i).removeChangeListener(this);
            }
            this.decorations = null;
            this.fireExhibitChangeEvent();
        }
    }

    public Decoration[] getDecorations() {
        if (this.decorations == null) {
            return new Decoration[0];
        }
        Decoration[] decs = new Decoration[this.decorations.size()];
        this.decorations.toArray(decs);
        return decs;
    }

    public View getDefaultView() {
        return new View();
    }

    public View[] getAlternativeViews() {
        return null;
    }

    public double[] getDefaultWindow() {
        if (this.defaultWindow != null) {
            return this.defaultWindow;
        }
        return new double[]{-5.0, 5.0, -5.0, 5.0};
    }

    public void setDefaultWindow(double xmin, double xmax, double ymin, double ymax) {
        this.defaultWindow = new double[]{xmin, xmax, ymin, ymax};
    }

    public void setDefaultWindow(double[] window) {
        this.setDefaultWindow(window[0], window[1], window[2], window[3]);
    }

    public Transform getDefaultTransform(View view) {
        double[] window = this.getDefaultWindow();
        return new Transform(window[0], window[1], window[2], window[3]);
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void setDefaultBackground(Color c) {
        this.defaultBackground = c == null ? Color.white : c;
        if (this.defaultBackground.getRed() < 150 && this.defaultBackground.getGreen() < 120 && this.defaultBackground.getBlue() < 150) {
            this.setDefaultForeground(Color.white);
        } else {
            this.setDefaultForeground(Color.black);
        }
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public void setDefaultForeground(Color c) {
        this.defaultForeground = c == null ? Color.black : c;
    }

    public Animation getCreateAnimation(View view) {
        return null;
    }

    public BasicAnimator getMorphingAnimation(final View view, int looping) {
        Parameter[] parameters = view.getViewAndExhibitParameters();
        if (parameters == null) {
            return null;
        }
        boolean animated = false;
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof Animateable) || !((Animateable)((Object)parameters[i])).reallyAnimated()) continue;
            animated = true;
            break;
        }
        if (!animated) {
            return null;
        }
        BasicAnimator anim = new BasicAnimator(this.framesForMorphing){

            @Override
            public void animationStarting() {
                Exhibit.this.morphingView = view;
                Exhibit.this.isMorphing = true;
            }

            @Override
            public void animationEnding() {
                Exhibit.this.morphingView = null;
                Exhibit.this.isMorphing = false;
            }
        };
        if (this.useFilmstripForMorphing) {
            anim.setUseFilmstrip(true);
            anim.setMillisecondsPerFrame(100);
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof Animateable)) continue;
            anim.addAnimatedItem((Animateable)((Object)parameters[i]));
        }
        anim.setLooping(looping);
        return anim;
    }

    public Animation getBuildAnimation(View view) {
        return null;
    }

    public void forceRedraw() {
        this.exhibitNeedsRedraw = true;
        this.fireExhibitChangeEvent();
    }

    public void render(VectorGraphics g, View view, Transform transform, ArrayList<Decoration> extraDecorations) {
        int i;
        int decorationCount = (this.decorations == null ? 0 : this.decorations.size()) + (extraDecorations == null ? 0 : extraDecorations.size());
        Decoration[] decs = null;
        if (decorationCount > 0) {
            int k;
            int j;
            Decoration d;
            int decsIndex = 0;
            decs = new Decoration[decorationCount];
            if (this.decorations != null) {
                for (i = 0; i < this.decorations.size(); ++i) {
                    d = this.decorations.get(i);
                    for (j = 0; j < decsIndex && d.getLayer() >= decs[j].getLayer(); ++j) {
                    }
                    for (k = decsIndex; k > j; --k) {
                        decs[k] = decs[k - 1];
                    }
                    decs[j] = d;
                    ++decsIndex;
                }
            }
            if (extraDecorations != null) {
                for (i = 0; i < extraDecorations.size(); ++i) {
                    d = extraDecorations.get(i);
                    for (j = 0; j < decsIndex && d.getLayer() >= decs[j].getLayer(); ++j) {
                    }
                    for (k = decsIndex; k > j; --k) {
                        decs[k] = decs[k - 1];
                    }
                    decs[j] = d;
                    ++decsIndex;
                }
            }
        }
        Animation builder = null;
        if (!view.getFastDrawing() && view.getDisplay() != null && view.getDisplay().getStatus() != "running" && view.getDisplay().getStatus() != "paused") {
            builder = this.getBuildAnimation(view);
        }
        this.computeDrawDataHook(view, transform);
        if (decs != null) {
            for (i = 0; i < decs.length; ++i) {
                decs[i].computeDrawData(view, this.exhibitNeedsRedraw, this.previousTransform, transform);
                decs[i].decorationNeedsRedraw = false;
            }
        }
        this.exhibitNeedsRedraw = false;
        if (decs != null) {
            for (i = 0; i < decs.length && decs[i].getLayer() < 0; ++i) {
                decs[i].doDraw(g, view, transform);
            }
        }
        if (builder == null) {
            this.doDrawHook(g, view, transform);
            if (decs != null) {
                while (i < decs.length) {
                    decs[i].doDraw(g, view, transform);
                    ++i;
                }
            }
        } else {
            final Animation buildAnim = builder;
            final View theView = view;
            Decoration[] remainingDecs = null;
            if (decs != null && i < decs.length) {
                remainingDecs = new Decoration[decs.length - i];
                for (int j = i; j < decs.length; ++j) {
                    remainingDecs[j - i] = decs[j];
                }
            }
            final Decoration[] theDecs = remainingDecs;
            view.installBuildAnimation(builder);
            builder.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (!buildAnim.isRunning() && buildAnim == theView.getBuildAnimation()) {
                        theView.installBuildAnimation(null);
                        if (theDecs != null && theView.beginDrawToOffscreenImage()) {
                            for (int i = 0; i < theDecs.length; ++i) {
                                theDecs[i].doDraw(theView.getTransform().getGraphics(), theView, theView.getTransform());
                            }
                            theView.endDrawToOffscreenImage();
                            theView.getDisplay().repaint();
                        }
                    }
                }
            });
        }
    }

    protected void computeDrawDataHook(View view, Transform transform) {
        this.computeDrawData(view, this.exhibitNeedsRedraw, this.previousTransform, transform);
        this.previousTransform = (Transform)transform.clone();
    }

    protected void doDrawHook(VectorGraphics g, View view, Transform transform) {
        this.doDraw(g, view, transform);
    }

    protected void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
    }

    protected void doDraw(VectorGraphics g, View view, Transform transform) {
    }
}

