/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Animation;
import vmm3d.core.Exhibit;
import vmm3d.core.Filmstrip;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.TimerAnimation;
import vmm3d.core.View;

public class Display
extends JPanel {
    private View mainView;
    private Animation animation;
    private MouseTask mouseTask;
    private MouseTask oneShotMouseTask;
    private View auxiliaryView;
    private int auxiliaryViewPosition;
    private MouseTask auxiliaryMouseTask;
    private boolean oneShotMouseTaskIsForMainView;
    private double auxiliaryViewFraction;
    private boolean auxiliaryViewIsResizable;
    private Rectangle mainViewRect;
    private Rectangle auxViewRect;
    private Rectangle dividingBarRect;
    private Rectangle basisUsedForComputingRects;
    private MouseTask dragTask;
    private boolean draggingInMainView;
    private boolean mouseInMainView = true;
    private boolean mouseInAuxView = false;
    private double timeDilationForAnimations = 1.0;
    private boolean stopAnimationsOnResize = true;
    private Filmstrip savedFilmstrip;
    private int savedFilmstripLooping;
    private String status;
    private Font saveOriginalFont;
    private DisplayHolder holder;
    private boolean showStatusBar = true;
    private Timer resizeTimer;
    private VectorGraphics vectorg;
    private static int drawnumber = 0;
    public static final String FILMSTRIP_AVAILABLE_PROPERTY = "FilmstripAvailable";
    public static final String STATUS_PROPERTY = "Status";
    public static final String STATUS_EMPTY = "empty";
    public static final String STATUS_IDLE = "idle";
    public static final String STATUS_ANIMATION_RUNNING = "running";
    public static final String STATUS_ANIMATION_PAUSED = "paused";
    public static final String STATUS_ONE_SHOT_MOUSE_TASK = "mouse task";
    public static final int AUX_VIEW_ON_LEFT = 0;
    public static final int AUX_VIEW_ON_RIGHT = 1;
    public static final int AUX_VIEW_ON_TOP = 2;
    public static final int AUX_VIEW_ON_BOTTOM = 3;
    private Dimension previousSize;

    public Display() {
        this.enableEvents(1L);
        MouseHandler listener = new MouseHandler();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
        this.status = STATUS_EMPTY;
        this.saveOriginalFont = this.getFont();
    }

    public VectorGraphics getVectorGraphics() {
        return this.vectorg;
    }

    public String getStatus() {
        return this.status;
    }

    private void setStatus(String status) {
        if (status == STATUS_IDLE && this.getExhibit() == null) {
            status = STATUS_EMPTY;
        }
        if (status != this.status) {
            String oldVal = this.status;
            this.status = status;
            this.firePropertyChange(STATUS_PROPERTY, oldVal, status);
        }
        this.setStatusText(null);
    }

    private void setSavedFilmstrip(Filmstrip filmstrip, int looping) {
        boolean newVal;
        if (this.savedFilmstrip == filmstrip && this.savedFilmstripLooping == looping) {
            return;
        }
        boolean prevVal = this.savedFilmstrip != null;
        this.savedFilmstrip = filmstrip;
        this.savedFilmstripLooping = looping;
        boolean bl = newVal = this.savedFilmstrip != null;
        if (newVal != prevVal) {
            this.firePropertyChange(FILMSTRIP_AVAILABLE_PROPERTY, new Boolean(prevVal), new Boolean(newVal));
        }
    }

    public Filmstrip getSavedFilmstrip() {
        return this.savedFilmstrip;
    }

    public int getSavedFilmstripLooping() {
        if (this.savedFilmstrip == null) {
            return -1;
        }
        return this.savedFilmstripLooping;
    }

    public synchronized void install(View view, Exhibit exhibit) {
        this.stopAnimation();
        this.cancelMouseTasks();
        this.resetHolder();
        this.auxiliaryView = null;
        this.mouseInMainView = true;
        this.mainViewRect = null;
        if (this.auxiliaryView != null) {
            this.auxiliaryView.setExhibit(null);
            this.auxiliaryView.finish();
        }
        this.setFont(this.saveOriginalFont);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setStopAnimationsOnResize(true);
        if (exhibit != null && view == null) {
            view = exhibit.getDefaultView();
        }
        if (this.mainView != null && view != this.mainView) {
            this.mainView.setExhibit(null);
            this.mainView.finish();
        }
        if (this.mainView != null) {
            this.mainView.setDisplay(null);
        }
        if (view == null) {
            this.mainView = null;
            this.repaint();
            this.setStatus(STATUS_EMPTY);
            this.setSavedFilmstrip(null, 0);
            return;
        }
        if (exhibit != null) {
            view.setExhibit(exhibit);
        } else {
            exhibit = view.getExhibit();
        }
        this.mainView = view;
        view.setDisplay(this);
        this.installMouseTask(view.getDefaultMouseTask());
        this.setStatus(exhibit == null ? STATUS_EMPTY : STATUS_IDLE);
        this.setSavedFilmstrip(null, 0);
        this.repaint();
    }

    public View getView() {
        return this.mainView;
    }

    public synchronized boolean installAuxiliaryView(View mainView, View auxiliaryView) {
        return this.installAuxiliaryView(mainView, auxiliaryView, 0, 0.5, false);
    }

    public synchronized boolean installAuxiliaryView(View mainView, View auxliaryView, int auxViewPosition, double fractionOfDisplay, boolean resizable) {
        if (this.mainView != mainView) {
            return false;
        }
        this.stopAnimation();
        if (auxViewPosition < 0 || auxViewPosition > 4) {
            throw new IllegalArgumentException("Illegal auxiliary view positon.");
        }
        if (fractionOfDisplay < 0.0 || fractionOfDisplay > 1.0) {
            throw new IllegalArgumentException("Illegal fractional size for view.");
        }
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, mainView);
            this.oneShotMouseTask = null;
        }
        if (this.auxiliaryView != null && this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.finish(this, this.auxiliaryView);
            this.auxiliaryMouseTask = null;
        }
        if (this.auxiliaryView != null) {
            this.auxiliaryView.setDisplay(null);
            this.auxiliaryView.finish();
        }
        this.auxiliaryView = auxliaryView;
        if (this.auxiliaryView != null) {
            this.auxiliaryView.setDisplay(this);
            this.installAuxiliaryMouseTask(this.auxiliaryView.getDefaultMouseTask());
        }
        this.auxiliaryViewPosition = auxViewPosition;
        this.auxiliaryViewIsResizable = resizable;
        this.auxiliaryViewFraction = fractionOfDisplay;
        this.setStatus(STATUS_IDLE);
        this.setStatusText(null);
        this.mainViewRect = null;
        this.repaint();
        return true;
    }

    private void makeViewRects() {
        int mainViewPixels;
        int auxViewPixels;
        Insets insets = this.getInsets();
        this.mainViewRect = insets == null ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        if (this.auxiliaryView == null) {
            this.dividingBarRect = null;
            this.auxViewRect = null;
            return;
        }
        this.auxViewRect = new Rectangle(this.mainViewRect);
        if (this.auxiliaryViewPosition == 3 || this.auxiliaryViewPosition == 2) {
            auxViewPixels = (int)(this.auxiliaryViewFraction * (double)(this.mainViewRect.height - 7));
            mainViewPixels = this.mainViewRect.height - 7 - auxViewPixels;
        } else {
            auxViewPixels = (int)(this.auxiliaryViewFraction * (double)(this.mainViewRect.width - 7));
            mainViewPixels = this.mainViewRect.width - 7 - auxViewPixels;
        }
        auxViewPixels = Math.max(auxViewPixels, 0);
        mainViewPixels = Math.max(mainViewPixels, 0);
        if (auxViewPixels == 0 && mainViewPixels == 0) {
            this.dividingBarRect = this.mainViewRect;
            this.mainViewRect = this.auxViewRect = new Rectangle(0, 0, 0, 0);
            return;
        }
        switch (this.auxiliaryViewPosition) {
            case 0: {
                this.mainViewRect.x = this.mainViewRect.x + 7 + auxViewPixels;
                this.mainViewRect.width = mainViewPixels;
                this.auxViewRect.width = auxViewPixels;
                this.dividingBarRect = new Rectangle(this.auxViewRect.x + this.auxViewRect.width, this.auxViewRect.y, 7, this.auxViewRect.height);
                break;
            }
            case 1: {
                this.auxViewRect.x = this.auxViewRect.x + 7 + mainViewPixels;
                this.mainViewRect.width = mainViewPixels;
                this.auxViewRect.width = auxViewPixels;
                this.dividingBarRect = new Rectangle(this.mainViewRect.x + this.mainViewRect.width, this.mainViewRect.y, 7, this.mainViewRect.height);
                break;
            }
            case 2: {
                this.mainViewRect.y = this.mainViewRect.y + 7 + auxViewPixels;
                this.mainViewRect.height = mainViewPixels;
                this.auxViewRect.height = auxViewPixels;
                this.dividingBarRect = new Rectangle(this.auxViewRect.x, this.auxViewRect.y + this.auxViewRect.height, this.auxViewRect.width, 7);
                break;
            }
            case 3: {
                this.auxViewRect.y = this.auxViewRect.y + 7 + mainViewPixels;
                this.mainViewRect.height = mainViewPixels;
                this.auxViewRect.height = auxViewPixels;
                this.dividingBarRect = new Rectangle(this.mainViewRect.x, this.mainViewRect.y + this.mainViewRect.height, this.mainViewRect.width, 7);
            }
        }
    }

    public Exhibit getExhibit() {
        return this.mainView == null ? null : this.mainView.getExhibit();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ++drawnumber;
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        this.vectorg = VectorGraphics.create((Graphics)g);
        if (this.mainView == null) {
            this.vectorg.setColor(this.getBackground());
            this.vectorg.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Rectangle sizeRect = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        if (this.mainViewRect == null || !sizeRect.equals(this.basisUsedForComputingRects)) {
            this.makeViewRects();
            this.basisUsedForComputingRects = sizeRect;
        }
        if (this.dividingBarRect != null) {
            this.vectorg.setColor(Color.GRAY);
            this.vectorg.fillRect(this.dividingBarRect.x, this.dividingBarRect.y, this.dividingBarRect.width, this.dividingBarRect.height);
            this.vectorg.setColor(Color.DARK_GRAY);
            this.vectorg.drawRect(this.dividingBarRect.x, this.dividingBarRect.y, this.dividingBarRect.width - 1, this.dividingBarRect.height - 1);
            this.vectorg.setColor(this.mainView.getForeground());
        }
        this.vectorg.setBackground(this.mainView.getBackground());
        this.vectorg.setColor(this.mainView.getForeground());
        if (this.mainViewRect == null) {
            return;
        }
        this.vectorg.create(this.mainViewRect.x, this.mainViewRect.y, this.mainViewRect.width, this.mainViewRect.height);
        this.mainView.render(this.vectorg, this.mainViewRect.width, this.mainViewRect.height);
        if (this.auxiliaryView != null) {
            this.vectorg.create(this.auxViewRect.x, this.auxViewRect.y, this.auxViewRect.width, this.auxViewRect.height);
            this.auxiliaryView.render(this.vectorg, this.auxViewRect.width, this.auxViewRect.height);
        }
    }

    protected void chooseCursor() {
        Cursor cursor = null;
        if (this.animation != null && this.animation.isRunning()) {
            cursor = Cursor.getPredefinedCursor(3);
        } else if (this.oneShotMouseTask != null) {
            if (this.mouseInMainView && this.oneShotMouseTaskIsForMainView) {
                cursor = this.oneShotMouseTask.getCursor(this, this.mainView);
            } else if (this.mouseInAuxView && !this.oneShotMouseTaskIsForMainView) {
                cursor = this.oneShotMouseTask.getCursor(this, this.auxiliaryView);
            }
        } else if (this.mouseInMainView && this.mouseTask != null) {
            cursor = this.mouseTask.getCursor(this, this.mainView);
        } else if (this.mouseInAuxView && this.auxiliaryMouseTask != null) {
            cursor = this.auxiliaryMouseTask.getCursor(this, this.auxiliaryView);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    public synchronized void installAnimation(Animation anim) {
    }

    public synchronized void stopAnimation() {
        if (this.animation != null) {
            if (this.animation.isRunning()) {
                this.animation.cancel();
            }
            if (this.animation instanceof TimerAnimation) {
                ((TimerAnimation)this.animation).setDisplay(null);
                Filmstrip f = ((TimerAnimation)this.animation).getFilmstrip();
                if (f != null) {
                    f.stripNullFrames();
                    int loop = ((TimerAnimation)this.animation).getLooping();
                    if (loop == 1) {
                        f.setFrame(f.getFrameCount() + 1, null);
                    }
                    if (f.getFrameCount() > 1) {
                        this.setSavedFilmstrip(f, loop);
                    }
                }
            }
            this.animation = null;
            this.setStatus(STATUS_IDLE);
            this.repaint();
        }
        this.chooseCursor();
    }

    public synchronized void toggleAnimationPaused() {
        if (this.animation != null && this.animation.isRunning()) {
            this.animation.setPaused(!this.animation.isPaused());
            this.setStatus(this.animation.isPaused() ? STATUS_ANIMATION_PAUSED : STATUS_ANIMATION_RUNNING);
        }
    }

    public synchronized void setTimeDilationForAnimations(double dilationFactor) {
        if (dilationFactor < 0.2) {
            dilationFactor = 0.2;
        } else if (dilationFactor > 100.0) {
            dilationFactor = 100.0;
        }
        this.timeDilationForAnimations = dilationFactor;
        if (this.animation != null) {
            this.animation.setTimeDilation(dilationFactor);
        }
    }

    public double getTimeDilationForAnimations() {
        return this.timeDilationForAnimations;
    }

    public void discardFilmstrip() {
        this.setSavedFilmstrip(null, 0);
    }

    public void playFilmstrip(final Filmstrip filmstrip, int looping, Dimension preferredSize) {
        if (filmstrip == null) {
            return;
        }
        final View dummyView = this.mainView == null ? new View() : null;
        final boolean saveStopOnResize = this.getStopAnimationsOnResize();
        final Dimension saveSize = preferredSize == null ? null : this.getSize();
        this.setStopAnimationsOnResize(false);
        if (preferredSize != null && !preferredSize.equals(this.getSize())) {
            if (preferredSize.equals(this.getPreferredSize())) {
                ++preferredSize.height;
            }
            this.setPreferredSize(preferredSize);
        }
        TimerAnimation player = new TimerAnimation(){

            @Override
            protected void drawFrame() {
                Display.this.repaint();
            }

            @Override
            BufferedImage getCurrentFilmstripFrame() {
                return filmstrip.getFrame(this.frameNumber);
            }

            @Override
            protected void animationStarting() {
                if (dummyView != null) {
                    Display.this.mainView = dummyView;
                }
            }

            @Override
            protected void animationEnding() {
                if (dummyView != null) {
                    Display.this.mainView = null;
                }
                if (saveSize != null) {
                    Display.this.setPreferredSize(saveSize);
                }
                Display.this.setStopAnimationsOnResize(saveStopOnResize);
            }
        };
        player.setFrames(filmstrip.getFrameCount() - 1);
        player.setLooping(looping);
        player.setMillisecondsPerFrame(100);
        this.installAnimation(player);
    }

    public void playFilmstrip() {
        if (this.savedFilmstrip == null) {
            return;
        }
        TimerAnimation player = new TimerAnimation(){

            @Override
            protected void drawFrame() {
            }
        };
        player.setFilmstrip(this.savedFilmstrip);
        player.setLooping(this.savedFilmstripLooping);
        player.setMillisecondsPerFrame(100);
        this.installAnimation(player);
    }

    public boolean getStopAnimationsOnResize() {
        return this.stopAnimationsOnResize;
    }

    public void setStopAnimationsOnResize(boolean stopAnimationsOnResize) {
        this.stopAnimationsOnResize = stopAnimationsOnResize;
    }

    public synchronized void installMouseTask(MouseTask task) {
        if (this.oneShotMouseTask != null && this.oneShotMouseTaskIsForMainView) {
            this.oneShotMouseTask.finish(this, this.mainView);
            this.setStatus(STATUS_IDLE);
            this.oneShotMouseTask = null;
        }
        this.dragTask = null;
        if (this.mouseTask != null) {
            this.mouseTask.finish(this, this.mainView);
        }
        this.mouseTask = task;
        if (this.mouseTask != null) {
            this.mouseTask.start(this, this.mainView);
        }
        this.chooseCursor();
        this.setStatusText(null);
    }

    public MouseTask getMouseTask() {
        return this.mouseTask;
    }

    public synchronized void installAuxiliaryMouseTask(MouseTask task) {
        if (this.auxiliaryView == null) {
            return;
        }
        if (this.oneShotMouseTask != null && !this.oneShotMouseTaskIsForMainView) {
            this.oneShotMouseTask.finish(this, this.auxiliaryView);
            this.setStatus(STATUS_IDLE);
            this.oneShotMouseTask = null;
        }
        this.dragTask = null;
        if (this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.finish(this, this.auxiliaryView);
        }
        this.auxiliaryMouseTask = task;
        if (this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.start(this, this.auxiliaryView);
        }
        this.chooseCursor();
        this.setStatusText(null);
    }

    public synchronized void installOneShotMouseTask(MouseTask task) {
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.mainView);
        }
        this.oneShotMouseTaskIsForMainView = true;
        this.dragTask = null;
        this.oneShotMouseTask = task;
        if (this.oneShotMouseTask != null) {
            this.stopAnimation();
            this.oneShotMouseTask.start(this, this.mainView);
            this.setStatus(STATUS_ONE_SHOT_MOUSE_TASK);
        } else {
            this.setStatus(STATUS_IDLE);
        }
        this.chooseCursor();
    }

    public synchronized void installAuxiliaryOneShotMouseTask(MouseTask task) {
        if (this.auxiliaryView == null) {
            return;
        }
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.oneShotMouseTaskIsForMainView ? this.mainView : this.auxiliaryView);
        }
        this.dragTask = null;
        this.oneShotMouseTaskIsForMainView = false;
        this.oneShotMouseTask = task;
        if (this.oneShotMouseTask != null) {
            this.stopAnimation();
            this.oneShotMouseTask.start(this, this.auxiliaryView);
            this.setStatus(STATUS_ONE_SHOT_MOUSE_TASK);
        } else {
            this.setStatus(STATUS_IDLE);
        }
        this.chooseCursor();
    }

    protected synchronized void cancelMouseTasks() {
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.oneShotMouseTaskIsForMainView ? this.mainView : this.auxiliaryView);
        }
        if (this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.finish(this, this.auxiliaryView);
        }
        if (this.mouseTask != null) {
            this.mouseTask.finish(this, this.mainView);
        }
        this.auxiliaryMouseTask = null;
        this.mouseTask = null;
        this.oneShotMouseTask = null;
        this.dragTask = null;
        this.chooseCursor();
    }

    public void setShowStatusBar(boolean show) {
        if (show == this.showStatusBar) {
            return;
        }
        if (this.holder != null) {
            if (show) {
                this.holder.add((Component)this.holder.statusBar, "South");
            } else {
                this.holder.remove(this.holder.statusBar);
            }
            this.validate();
        }
        this.showStatusBar = show;
    }

    public boolean getShowStatusBar() {
        return this.showStatusBar;
    }

    public String getStatusText() {
        if (this.holder == null) {
            return null;
        }
        return this.holder.statusBar.getText();
    }

    public void setStatusText() {
        this.setStatusText(null);
    }

    public synchronized void setStatusText(String message) {
        if (this.holder != null) {
            if (message == null) {
                if (this.status == STATUS_EMPTY || this.getExhibit() == null) {
                    message = I18n.tr("vmm3d.core.Display.statusbar.noExhibit");
                } else if (this.status == STATUS_ANIMATION_RUNNING) {
                    message = this.animation.getStatusText(true);
                    if (message == null) {
                        message = I18n.tr("vmm3d.core.Display.statusbar.animationRunning");
                    }
                } else if (this.status == STATUS_ANIMATION_PAUSED) {
                    message = this.animation.getStatusText(false);
                    if (message == null) {
                        message = I18n.tr("vmm3d.core.Display.statusbar.animationPaused");
                    }
                } else if (this.status == STATUS_ONE_SHOT_MOUSE_TASK) {
                    message = this.oneShotMouseTask.getStatusText();
                    if (message == null) {
                        message = I18n.tr("vmm3d.core.Display.statusbar.oneShotMouseTask");
                    }
                } else {
                    if (this.mouseTask != null) {
                        message = this.mouseTask.getStatusText();
                    }
                    if (message == null) {
                        message = this.mainView.getStatusText();
                    }
                    if (message == null) {
                        message = this.getExhibit().getTitle();
                    }
                }
            }
            this.holder.statusBar.setText(message);
        }
    }

    public void addBorderComponent(Component c, Object position) {
        if (position != "North" && position != "East" && position != "West" && position != "South") {
            throw new IllegalArgumentException("Internal Error:  Border component position must be north, south, east, or west.");
        }
        if (this.holder != null) {
            if (position == "South" && this.showStatusBar) {
                this.holder.remove(this.holder.statusBar);
                this.showStatusBar = false;
            }
            this.holder.add(c, position);
            this.holder.validate();
        }
    }

    public void removeBorderComponent(Component c) {
        if (this.holder != null) {
            this.holder.remove(c);
            this.holder.validate();
        }
    }

    public JSplitPane split(Component newComponent) {
        return this.split(newComponent, false, false);
    }

    public JSplitPane split(Component newComponent, boolean splitVertically, boolean displayIsSecondComponent) {
        if (this.holder != null) {
            if (this.holder.splitPane != null) {
                this.holder.remove(this.holder.splitPane);
            } else {
                this.holder.remove(this);
            }
            Component first = displayIsSecondComponent ? newComponent : this;
            Component secnd = displayIsSecondComponent ? this : newComponent;
            JSplitPane pane = splitVertically ? new JSplitPane(0, first, secnd) : new JSplitPane(1, first, secnd);
            pane.setBorder(null);
            this.holder.add((Component)pane, "Center");
            this.holder.validate();
            pane.setDividerLocation(0.5);
            pane.setResizeWeight(0.5);
            this.holder.splitPane = pane;
            return this.holder.splitPane;
        }
        return null;
    }

    public void unsplit() {
        if (this.holder != null && this.holder.splitPane != null) {
            this.holder.remove(this.holder.splitPane);
            this.holder.splitPane = null;
            this.holder.add((Component)this, "Center");
            this.holder.validate();
        }
    }

    public void resetHolder() {
        if (this.holder != null) {
            this.holder.reset();
        }
    }

    public Container getHolder() {
        if (this.holder == null) {
            this.holder = new DisplayHolder();
        }
        return this.holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processComponentEvent(ComponentEvent evt) {
        super.processComponentEvent(evt);
        if (evt.getID() == 101) {
            if (!this.stopAnimationsOnResize) {
                Display display = this;
                synchronized (display) {
                    if (this.animation == null || !(this.animation instanceof TimerAnimation) || !((TimerAnimation)this.animation).getUseFilmstrip()) {
                        return;
                    }
                }
            }
            if (this.previousSize != null && this.previousSize.equals(this.getSize())) {
                return;
            }
            this.previousSize = this.getSize();
            this.stopAnimation();
            if (this.getView() != null && this.getExhibit() != null) {
                final View view = this.getView();
                this.getView().setFastDrawing(true, false);
                if (this.resizeTimer != null) {
                    this.resizeTimer.stop();
                }
                this.resizeTimer = new Timer(0, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        view.setFastDrawing(false, false);
                        Display.this.resizeTimer.stop();
                        Display.this.resizeTimer = null;
                    }
                });
                this.resizeTimer.setInitialDelay(500);
                this.resizeTimer.setRepeats(false);
                this.resizeTimer.start();
            }
        }
    }

    private class DisplayHolder
    extends JPanel {
        private JLabel statusBar;
        private JSplitPane splitPane;

        private DisplayHolder() {
            this.setLayout(new BorderLayout(1, 1));
            this.setBackground(Color.BLACK);
            this.statusBar = new JLabel(I18n.tr("vmm3d.core.Display.statusbar.noExhibit"));
            this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 1));
            this.statusBar.setBackground(Color.LIGHT_GRAY);
            this.statusBar.setForeground(Color.BLACK);
            this.statusBar.setOpaque(true);
            if (Display.this.showStatusBar) {
                this.add((Component)this.statusBar, "South");
            }
            this.add((Component)Display.this, "Center");
        }

        private void reset() {
            this.removeAll();
            this.setLayout(new BorderLayout(1, 1));
            this.setBackground(Color.BLACK);
            if (Display.this.showStatusBar) {
                this.add((Component)this.statusBar, "South");
            }
            this.add((Component)Display.this, "Center");
            this.statusBar.setText(I18n.tr("vmm3d.core.Display.statusbar.noExhibit"));
            this.validate();
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        Rectangle rect;
        boolean draggingDividingBar;
        int barOffset;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (Display.this.dragTask != null) {
                return;
            }
            this.draggingDividingBar = false;
            if (Display.this.animation != null && Display.this.animation.isRunning()) {
                Display.this.stopAnimation();
                return;
            }
            if (Display.this.mainViewRect == null) {
                Display.this.makeViewRects();
            }
            if (Display.this.mainViewRect.contains(evt.getX(), evt.getY())) {
                this.rect = Display.this.mainViewRect;
                Display.this.mouseInMainView = (Display.this.draggingInMainView = true);
                Display.this.mouseInAuxView = false;
            } else if (Display.this.auxViewRect != null && Display.this.auxViewRect.contains(evt.getX(), evt.getY())) {
                this.rect = Display.this.auxViewRect;
                Display.this.mouseInMainView = (Display.this.draggingInMainView = false);
                Display.this.mouseInAuxView = true;
            } else {
                if (Display.this.dividingBarRect != null && Display.this.auxiliaryViewIsResizable && Display.this.dividingBarRect.contains(evt.getX(), evt.getY())) {
                    this.draggingDividingBar = true;
                    this.barOffset = Display.this.auxiliaryViewPosition == 0 || Display.this.auxiliaryViewPosition == 1 ? evt.getX() - ((Display)Display.this).dividingBarRect.x : evt.getY() - ((Display)Display.this).dividingBarRect.y;
                    Display.this.mainView.setFastDrawing(true);
                    Display.this.auxiliaryView.setFastDrawing(true);
                    return;
                }
                Display.this.mouseInMainView = (Display.this.mouseInAuxView = false);
                return;
            }
            evt.translatePoint(-this.rect.x, -this.rect.y);
            if (Display.this.oneShotMouseTask != null) {
                if (Display.this.auxiliaryView != null && Display.this.draggingInMainView != Display.this.oneShotMouseTaskIsForMainView) {
                    JOptionPane.showMessageDialog(Display.this, Display.this.oneShotMouseTaskIsForMainView ? I18n.tr("vmm3d.core.Display.PleaseClickRight") : I18n.tr("vmm3d.core.Display.PleaseClickLeft"));
                    return;
                }
                if (Display.this.oneShotMouseTask.doMouseDown(evt, Display.this, Display.this.oneShotMouseTaskIsForMainView ? Display.this.mainView : Display.this.auxiliaryView, this.rect.width, this.rect.height)) {
                    Display.this.dragTask = Display.this.oneShotMouseTask;
                } else if (!Display.this.oneShotMouseTask.wantsMoreClicks(Display.this, Display.this.oneShotMouseTaskIsForMainView ? Display.this.mainView : Display.this.auxiliaryView)) {
                    Display.this.oneShotMouseTask.finish(Display.this, Display.this.oneShotMouseTaskIsForMainView ? Display.this.mainView : Display.this.auxiliaryView);
                    Display.this.oneShotMouseTask = null;
                    Display.this.setStatus(Display.STATUS_IDLE);
                }
            } else if (Display.this.draggingInMainView) {
                if (Display.this.mouseTask != null && Display.this.mouseTask.doMouseDown(evt, Display.this, Display.this.mainView, this.rect.width, this.rect.height)) {
                    Display.this.dragTask = Display.this.mouseTask;
                }
            } else if (Display.this.auxiliaryMouseTask != null && Display.this.auxiliaryMouseTask.doMouseDown(evt, Display.this, Display.this.auxiliaryView, this.rect.width, this.rect.height)) {
                Display.this.dragTask = Display.this.auxiliaryMouseTask;
            }
            Cursor cursor = null;
            if (Display.this.dragTask != null) {
                cursor = Display.this.dragTask.getCursorForDragging(evt, Display.this, Display.this.draggingInMainView ? Display.this.mainView : Display.this.auxiliaryView);
                if (cursor != null) {
                    Display.this.setCursor(cursor);
                } else {
                    Display.this.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                Display.this.chooseCursor();
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (this.draggingDividingBar) {
                Display.this.mainView.setFastDrawing(false);
                Display.this.auxiliaryView.setFastDrawing(false);
                this.draggingDividingBar = false;
                Display.this.repaint();
            } else if (Display.this.dragTask != null) {
                evt.translatePoint(-this.rect.x, -this.rect.y);
                View dragView = Display.this.draggingInMainView ? Display.this.mainView : Display.this.auxiliaryView;
                Display.this.dragTask.doMouseUp(evt, Display.this, dragView, this.rect.width, this.rect.height);
                if (Display.this.dragTask == Display.this.oneShotMouseTask && Display.this.oneShotMouseTask != null && !Display.this.oneShotMouseTask.wantsMoreClicks(Display.this, dragView)) {
                    Display.this.oneShotMouseTask.finish(Display.this, dragView);
                    Display.this.oneShotMouseTask = null;
                    Display.this.setStatus(Display.STATUS_IDLE);
                }
                Display.this.dragTask = null;
                Display.this.chooseCursor();
                Display.this.mainView.setNeedRedraw(true);
                Display.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (this.draggingDividingBar) {
                Insets insets = Display.this.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                if (Display.this.auxiliaryViewPosition == 0 || Display.this.auxiliaryViewPosition == 1) {
                    int newLeft = evt.getX() - this.barOffset;
                    if (newLeft < insets.left) {
                        newLeft = insets.left;
                    } else if (newLeft > Display.this.getWidth() - insets.right - 7) {
                        newLeft = Display.this.getWidth() - insets.right - 7;
                    }
                    if (newLeft != ((Display)Display.this).dividingBarRect.x) {
                        double ratio = (double)(newLeft - insets.left) / (double)(Display.this.getWidth() - insets.left - insets.right - 7);
                        if (ratio < 0.0) {
                            ratio = 0.0;
                        }
                        Display.this.auxiliaryViewFraction = Display.this.auxiliaryViewPosition == 0 ? ratio : 1.0 - ratio;
                        Display.this.mainViewRect = null;
                        Display.this.repaint();
                    }
                } else {
                    int newTop = evt.getY() - this.barOffset;
                    if (newTop < insets.top) {
                        newTop = insets.top;
                    } else if (newTop > Display.this.getHeight() - insets.bottom - 7) {
                        newTop = Display.this.getHeight() - insets.bottom - 7;
                    }
                    if (newTop != ((Display)Display.this).dividingBarRect.y) {
                        double ratio = (double)(newTop - insets.top) / (double)(Display.this.getHeight() - insets.top - insets.bottom - 7);
                        if (ratio < 0.0) {
                            ratio = 0.0;
                        }
                        Display.this.auxiliaryViewFraction = Display.this.auxiliaryViewPosition == 2 ? ratio : 1.0 - ratio;
                        Display.this.mainViewRect = null;
                        Display.this.mainView.setNeedRedraw(true);
                        Display.this.repaint();
                    }
                }
            } else if (Display.this.dragTask != null) {
                evt.translatePoint(-this.rect.x, -this.rect.y);
                View dragView = Display.this.draggingInMainView ? Display.this.mainView : Display.this.auxiliaryView;
                Display.this.dragTask.doMouseDrag(evt, Display.this, dragView, this.rect.width, this.rect.height);
                Cursor cursor = Display.this.dragTask.getCursorForDragging(evt, Display.this, dragView);
                if (cursor != null) {
                    Display.this.setCursor(cursor);
                } else {
                    Display.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            this.checkCursor(evt.getX(), evt.getY());
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            this.checkCursor(evt.getX(), evt.getY());
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            this.checkCursor(evt.getX(), evt.getY());
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        private void checkCursor(int x, int y) {
            if (Display.this.mainViewRect == null) {
                Display.this.makeViewRects();
            }
            Display.this.mouseInMainView = Display.this.mainViewRect.contains(x, y);
            Display.this.mouseInAuxView = Display.this.auxViewRect != null && Display.this.auxViewRect.contains(x, y);
            if (Display.this.auxiliaryView == null || Display.this.animation != null) {
                return;
            }
            if (Display.this.dividingBarRect.contains(x, y)) {
                if (!Display.this.auxiliaryViewIsResizable) {
                    Display.this.setCursor(Cursor.getDefaultCursor());
                } else if (Display.this.auxiliaryViewPosition == 0 || Display.this.auxiliaryViewPosition == 1) {
                    Display.this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    Display.this.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else {
                Display.this.chooseCursor();
            }
        }
    }
}

