/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import vmm3d.core.Complex;

public class ComplexODE {
    Complex[] polyCoeff;
    int polyDegree;
    Complex wv = new Complex();
    Complex w;
    Complex app;
    Complex aux;
    double newSub = 0.0;
    Complex dz;
    Complex pVal = new Complex();
    Complex d1Val = new Complex();
    Complex d2Val = new Complex();
    Complex d3Val = new Complex();
    Complex d4Val = new Complex();
    Complex wThird = new Complex();
    Complex d4Third = new Complex();

    public ComplexODE(Complex a0, Complex a1, Complex a2, Complex a3, Complex a4) {
        this.polyCoeff = new Complex[]{a0, a1, a2, a3, a4};
        this.polyDegree = this.polyCoeff.length - 1;
    }

    public Complex[] setPoly(Complex[] a) {
        this.polyCoeff = a;
        return this.polyCoeff;
    }

    public Complex[] setPoly(Complex a0, Complex a1, Complex a2, Complex a3, Complex a4) {
        this.polyCoeff = new Complex[]{a0, a1, a2, a3, a4};
        return this.polyCoeff;
    }

    public Complex valueOfPoly(Complex z) {
        this.wv.assign(this.polyCoeff[4]);
        for (int i = 0; i < 4; ++i) {
            this.wv.assignTimesPlus(z, this.polyCoeff[3 - i]);
        }
        return this.wv;
    }

    public Complex firstDerivOfPoly(Complex z) {
        this.wv.assignTimes(this.polyCoeff[4], 4.0);
        this.wv.assignTimes_PlusTimes(z, this.polyCoeff[3], 3.0);
        this.wv.assignTimes_PlusTimes(z, this.polyCoeff[2], 2.0);
        this.wv.assignTimesPlus(z, this.polyCoeff[1]);
        return this.wv;
    }

    public Complex secondDerivOfPoly(Complex z) {
        this.wv.assignTimes(this.polyCoeff[4], 12.0);
        this.wv.assignTimes_PlusTimes(z, this.polyCoeff[3], 6.0);
        this.wv.assignTimes_PlusTimes(z, this.polyCoeff[2], 2.0);
        return this.wv;
    }

    public Complex thirdDerivOfPoly(Complex z) {
        this.wv.assignTimes(this.polyCoeff[4], 24.0);
        this.wv.assignTimes_PlusTimes(z, this.polyCoeff[3], 6.0);
        return this.wv;
    }

    public Complex[] ODEstep2_2(Complex zInitial, Complex zFinal, Complex initialVal, Complex approxInitDeriv, int numSubdivision) {
        Complex w = new Complex(initialVal);
        Complex aux = new Complex(zFinal.minus(zInitial));
        double newSub = Math.floor(1.0 + aux.r()) * (double)numSubdivision;
        Complex dz = new Complex(zFinal.minus(zInitial).times(1.0 / newSub));
        int i = 0;
        while ((double)i < newSub) {
            Complex pVal = this.valueOfPoly(w);
            Complex d1Val = pVal.squareRootNearer(approxInitDeriv);
            Complex d2Val = this.firstDerivOfPoly(w).times(0.5);
            aux = d2Val.times(dz.power(2.0)).times(0.125);
            Complex midVal = w.plus(dz.times(d1Val.times(0.5))).plus(aux);
            Complex d2MidVal = this.firstDerivOfPoly(midVal).times(0.5);
            Complex d2Averag = d2MidVal.times(2.0).plus(d2Val).times(0.3333333333333333);
            w = w.plus(dz.times(d1Val)).plus(d2Averag.times(dz.power(2.0)).times(0.5));
            zInitial = zInitial.plus(dz);
            approxInitDeriv = d1Val.plus(dz.times(d2MidVal));
            ++i;
        }
        Complex[] val = new Complex[]{w, approxInitDeriv};
        return val;
    }

    public Complex[] ODEstep4(Complex zInitial, Complex zFinal, Complex initialVal, Complex approxInitDeriv, int numSubdivision) {
        this.w = new Complex(initialVal);
        this.app = new Complex(approxInitDeriv);
        this.aux = zFinal.minus(zInitial);
        this.newSub = Math.floor(1.0 + this.aux.r()) * (double)numSubdivision;
        this.dz = zFinal.minus(zInitial);
        this.dz.assignTimes(1.0 / this.newSub);
        int i = 0;
        while ((double)i < this.newSub) {
            this.pVal.assign(this.valueOfPoly(this.w));
            this.d1Val.assign(this.pVal.squareRootNearer(this.app));
            this.d2Val.assignTimes(this.firstDerivOfPoly(this.w), 0.5);
            this.d3Val.assignTimes(this.secondDerivOfPoly(this.w), 0.5);
            this.d3Val.assignTimes(this.d1Val);
            this.d4Val.assignTimes(this.thirdDerivOfPoly(this.w), 0.5);
            this.d4Val.assignTimes(this.pVal);
            this.d4Val.assign_PlusTimes(this.d2Val, this.d1Val);
            this.aux.assignTimes(this.d4Val, 0.013888888888888888);
            this.aux.assignTimes(this.dz);
            this.aux.assign_PlusTimes(this.d3Val, 0.05555555555555555);
            this.aux.assignTimes(this.dz);
            this.aux.assign_PlusTimes(this.d2Val, 0.16666666666666666);
            this.aux.assignTimesPlus(this.dz, this.d1Val);
            this.aux.assignTimesTimes(this.dz, 0.3333333333333333);
            this.wThird.assignPlus(this.w, this.aux);
            this.d4Third.assign(this.valueOfPoly(this.wThird));
            this.d4Third.assignTimesTimes(this.thirdDerivOfPoly(this.wThird), 0.5);
            this.aux.assignTimes(this.secondDerivOfPoly(this.wThird), 0.25);
            this.d4Third.assign_PlusTimes(this.aux, this.firstDerivOfPoly(this.wThird));
            this.d4Third.assignTimes(0.6);
            this.d4Third.assign_PlusTimes(this.d4Val, 0.4);
            this.d4Third.assignTimesTimes(this.dz, 0.041666666666666664);
            this.d4Third.assign_PlusTimes(this.d3Val, 0.16666666666666666);
            this.aux.assignTimes(this.d4Third, this.dz);
            this.aux.assign_PlusTimes(this.d2Val, 0.5);
            this.aux.assignTimes(this.dz);
            this.aux.assignPlusTimes(this.d1Val, this.dz);
            this.w.assignPlus(this.aux);
            this.d3Val.assignTimesTimes(this.dz, 0.3333333333333333);
            this.d3Val.assignPlusTimes(this.d2Val, this.dz);
            this.app.assignPlus(this.d1Val, this.d3Val);
            ++i;
        }
        Complex[] val = new Complex[]{this.w, this.app};
        return val;
    }

    public Complex RootOfPolynomial(Complex f, Complex approxInitDeriv) {
        Complex w = this.valueOfPoly(f);
        return w.squareRootNearer(approxInitDeriv);
    }

    public Complex RootOfPolynomialInverse(Complex f, Complex approxInitDerivInv) {
        Complex w = this.valueOfPoly(f);
        w.assignInvert();
        return w.squareRootNearer(approxInitDerivInv);
    }

    public Complex[] ComplexMultiStepIntegrator(Complex zInitial, Complex zFinal, Complex valInitial, Complex approxInitDeriv, double subs) {
        Complex uPrime = this.RootOfPolynomialInverse(zInitial, approxInitDeriv.invert());
        Complex w = new Complex();
        double weight1 = 0.35555555555555557;
        double weight2 = 0.1;
        double weight3 = 0.5444444444444444;
        double sqrtOf3Over28 = Math.sqrt(0.10714285714285714);
        Complex dz = zFinal.minus(zInitial);
        dz.assignTimes(1.0 / subs);
        Complex zIni = new Complex(zInitial);
        Complex zFin = new Complex(zFinal);
        Complex zMiddle = new Complex();
        Complex zGaussLeft = new Complex();
        Complex zGaussRight = new Complex();
        int j = 0;
        while ((double)j < subs) {
            zFin.assignPlus(zIni, dz);
            zMiddle.assignPlus(zIni, zFin);
            zMiddle.assignTimes(0.5);
            zGaussLeft.assignTimes(dz, -sqrtOf3Over28);
            zGaussLeft.assignPlus(zMiddle);
            zGaussRight.assignTimes(dz, sqrtOf3Over28);
            zGaussRight.assignPlus(zMiddle);
            uPrime = this.RootOfPolynomialInverse(zIni, uPrime);
            w.assign_PlusTimes(uPrime, 0.05);
            uPrime = this.RootOfPolynomialInverse(zGaussLeft, uPrime);
            w.assign_PlusTimes(uPrime, 0.2722222222222222);
            uPrime = this.RootOfPolynomialInverse(zMiddle, uPrime);
            w.assign_PlusTimes(uPrime, 0.35555555555555557);
            uPrime = this.RootOfPolynomialInverse(zGaussRight, uPrime);
            w.assign_PlusTimes(uPrime, 0.2722222222222222);
            uPrime = this.RootOfPolynomialInverse(zFin, uPrime);
            w.assign_PlusTimes(uPrime, 0.05);
            zIni.assign(zFin);
            ++j;
        }
        uPrime.assignInvert();
        return new Complex[]{uPrime, w.times(dz).plus(valInitial)};
    }
}

