/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.conformalmap;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.conformalmap.ConformalMap;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Complex;
import vmm3d.core.ComplexParamAnimateable;
import vmm3d.core.I18n;
import vmm3d.core.View;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;

public class HyperbolicIsometry
extends ConformalMap {
    private ComplexParamAnimateable c = new ComplexParamAnimateable("c", "0.5", "-0.9", "0.9");
    private boolean in2ndMorph = false;
    private Vector3D[] equator;
    private Point2D[] unitCircle;

    public HyperbolicIsometry() {
        this.addParameter(this.c);
        this.setGridType(1);
        this.umin.reset(0.0);
        this.umax.reset(0.7);
        this.vmin.reset(0.0);
        this.vmax.reset("2 pi");
        this.ures.reset(6);
        this.vres.reset(36);
        this.setDefaultWindow2D(-1.0, 1.0, -1.0, 1.0);
        this.equator = new Vector3D[121];
        this.unitCircle = new Point2D[121];
        for (int i = 0; i <= 120; ++i) {
            double angle = (double)(i * 3) / 180.0 * Math.PI;
            this.equator[i] = new Vector3D(Math.cos(angle), Math.sin(angle), 0.0);
            this.unitCircle[i] = new Point2D.Double(Math.cos(angle), Math.sin(angle));
        }
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.conformalmap.HyperbolicIsometry.Rotation")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(1);
                animation.setUseFilmstrip(HyperbolicIsometry.this.getUseFilmstripForMorphing());
                animation.setFrames(HyperbolicIsometry.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomValue(HyperbolicIsometry.this.ures, 6);
                animation.addWithCustomValue(HyperbolicIsometry.this.vres, 12);
                animation.addWithCustomValue(HyperbolicIsometry.this.umin, 0.0);
                animation.addWithCustomValue(HyperbolicIsometry.this.umax, 0.7);
                animation.addWithCustomLimits(HyperbolicIsometry.this.vmin, 0.0, Math.PI * 2);
                animation.addWithCustomLimits(HyperbolicIsometry.this.vmax, 1.5707963267948966, 7.853981633974483);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        if (((BasicAnimator)evt.getSource()).isRunning()) {
                            HyperbolicIsometry.this.in2ndMorph = true;
                        } else {
                            HyperbolicIsometry.this.in2ndMorph = false;
                        }
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    @Override
    protected Complex function(Complex argument) {
        Complex x = this.c.getValue();
        return argument.plus(x).dividedBy(argument.times(x.conj()).plus(1.0));
    }

    @Override
    protected void doDraw3D(VectorGraphics g, View3D view, Transform3D transform) {
        super.doDraw3D(g, view, transform);
        view.setColor(null);
        if (view.getEnableThreeD()) {
            view.drawCurve(this.equator);
        } else {
            view.drawCurve(this.unitCircle);
        }
    }
}

