/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.GridPattern;
import org.stathissideris.ascii2image.text.GridPatternGroup;
import org.stathissideris.ascii2image.text.StringUtils;

public class TextGrid {
    private static final boolean DEBUG = false;
    private ArrayList<StringBuffer> rows;
    private static char[] boundaries = new char[]{'/', '\\', '|', '-', '*', '=', ':'};
    private static char[] undisputableBoundaries = new char[]{'|', '-', '*', '=', ':'};
    private static char[] horizontalLines = new char[]{'-', '='};
    private static char[] verticalLines = new char[]{'|', ':'};
    private static char[] arrowHeads = new char[]{'<', '>', '^', 'v', 'V'};
    private static char[] cornerChars = new char[]{'\\', '/', '+'};
    private static char[] pointMarkers = new char[]{'*'};
    private static char[] dashedLines = new char[]{':', '~', '='};
    private static char[] entryPoints1 = new char[]{'\\'};
    private static char[] entryPoints2 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints3 = new char[]{'/'};
    private static char[] entryPoints4 = new char[]{'-', '=', '+', '\\', '/'};
    private static char[] entryPoints5 = new char[]{'\\'};
    private static char[] entryPoints6 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints7 = new char[]{'/'};
    private static char[] entryPoints8 = new char[]{'-', '=', '+', '\\', '/'};
    private static HashMap<String, String> humanColorCodes = new HashMap();
    private static HashSet<String> markupTags;

    public void addToMarkupTags(Collection<String> tags) {
        markupTags.addAll(tags);
    }

    public static void main(String[] args) throws Exception {
        TextGrid grid = new TextGrid();
        grid.loadFrom("tests/text/art10.txt");
        TextGrid textGrid = grid;
        textGrid.getClass();
        grid.writeStringTo(textGrid.new Cell(28, 1), "testing");
        grid.findMarkupTags();
        grid.printDebug();
    }

    public TextGrid() {
        this.rows = new ArrayList();
    }

    public TextGrid(int width, int height) {
        String space = StringUtils.repeatString(" ", width);
        this.rows = new ArrayList();
        for (int i = 0; i < height; ++i) {
            this.rows.add(new StringBuffer(space));
        }
    }

    public static TextGrid makeSameSizeAs(TextGrid grid) {
        return new TextGrid(grid.getWidth(), grid.getHeight());
    }

    public TextGrid(TextGrid otherGrid) {
        this.rows = new ArrayList();
        for (StringBuffer row : otherGrid.getRows()) {
            this.rows.add(new StringBuffer(row));
        }
    }

    public void clear() {
        String blank = StringUtils.repeatString(" ", this.getWidth());
        int height = this.getHeight();
        this.rows.clear();
        for (int i = 0; i < height; ++i) {
            this.rows.add(new StringBuffer(blank));
        }
    }

    public char get(int x, int y) {
        if (x > this.getWidth() - 1 || y > this.getHeight() - 1 || x < 0 || y < 0) {
            return '\u0000';
        }
        return this.rows.get(y).charAt(x);
    }

    public char get(Cell cell2) {
        if (cell2.x > this.getWidth() - 1 || cell2.y > this.getHeight() - 1 || cell2.x < 0 || cell2.y < 0) {
            return '\u0000';
        }
        return this.rows.get(cell2.y).charAt(cell2.x);
    }

    public StringBuffer getRow(int y) {
        return this.rows.get(y);
    }

    public TextGrid getSubGrid(int x, int y, int width, int height) {
        TextGrid grid = new TextGrid(width, height);
        for (int i = 0; i < height; ++i) {
            grid.setRow(i, new StringBuffer(this.getRow(y + i).subSequence(x, x + width)));
        }
        return grid;
    }

    public TextGrid getTestingSubGrid(Cell cell2) {
        return this.getSubGrid(cell2.x - 1, cell2.y - 1, 3, 3);
    }

    public String getStringAt(int x, int y, int length) {
        return this.getStringAt(new Cell(x, y), length);
    }

    public String getStringAt(Cell cell2, int length) {
        int x = cell2.x;
        int y = cell2.y;
        if (x > this.getWidth() - 1 || y > this.getHeight() - 1 || x < 0 || y < 0) {
            return null;
        }
        return this.rows.get(y).substring(x, x + length);
    }

    public char getNorthOf(int x, int y) {
        return this.get(x, y - 1);
    }

    public char getSouthOf(int x, int y) {
        return this.get(x, y + 1);
    }

    public char getEastOf(int x, int y) {
        return this.get(x + 1, y);
    }

    public char getWestOf(int x, int y) {
        return this.get(x - 1, y);
    }

    public char getNorthOf(Cell cell2) {
        return this.getNorthOf(cell2.x, cell2.y);
    }

    public char getSouthOf(Cell cell2) {
        return this.getSouthOf(cell2.x, cell2.y);
    }

    public char getEastOf(Cell cell2) {
        return this.getEastOf(cell2.x, cell2.y);
    }

    public char getWestOf(Cell cell2) {
        return this.getWestOf(cell2.x, cell2.y);
    }

    public void writeStringTo(int x, int y, String str) {
        this.writeStringTo(new Cell(x, y), str);
    }

    public void writeStringTo(Cell cell2, String str) {
        if (this.isOutOfBounds(cell2)) {
            return;
        }
        this.rows.get(cell2.y).replace(cell2.x, cell2.x + str.length(), str);
    }

    public void set(Cell cell2, char c) {
        this.set(cell2.x, cell2.y, c);
    }

    public void set(int x, int y, char c) {
        if (x > this.getWidth() - 1 || y > this.getHeight() - 1) {
            return;
        }
        StringBuffer row = this.rows.get(y);
        row.setCharAt(x, c);
    }

    public void setRow(int y, String row) {
        if (y > this.getHeight() || row.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(y, new StringBuffer(row));
    }

    public void setRow(int y, StringBuffer row) {
        if (y > this.getHeight() || row.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(y, row);
    }

    public int getWidth() {
        if (this.rows.size() == 0) {
            return 0;
        }
        return this.rows.get(0).length();
    }

    public int getHeight() {
        return this.rows.size();
    }

    public void printDebug() {
        Iterator<StringBuffer> it = this.rows.iterator();
        int i = 0;
        System.out.println("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1));
        while (it.hasNext()) {
            String row = it.next().toString();
            String index = new Integer(i).toString();
            if (i < 10) {
                index = " " + index;
            }
            System.out.println(index + " (" + row + ")");
            ++i;
        }
    }

    public String getDebugString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<StringBuffer> it = this.rows.iterator();
        int i = 0;
        buffer.append("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1) + "\n");
        while (it.hasNext()) {
            String row = it.next().toString();
            String index = new Integer(i).toString();
            if (i < 10) {
                index = " " + index;
            }
            row = row.replaceAll("\n", "\\\\n");
            row = row.replaceAll("\r", "\\\\r");
            buffer.append(index + " (" + row + ")\n");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getDebugString();
    }

    public boolean add(TextGrid grid) {
        if (this.getWidth() != grid.getWidth() || this.getHeight() != grid.getHeight()) {
            return false;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                if (this.get(xi, yi) != ' ') continue;
                this.set(xi, yi, grid.get(xi, yi));
            }
        }
        return true;
    }

    public void replaceTypeOnLine() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                if (!Character.isLetterOrDigit(c)) continue;
                boolean isOnHorizontalLine = this.isOnHorizontalLine(xi, yi);
                boolean isOnVerticalLine = this.isOnVerticalLine(xi, yi);
                if (isOnHorizontalLine && isOnVerticalLine) {
                    this.set(xi, yi, '+');
                    continue;
                }
                if (isOnHorizontalLine) {
                    this.set(xi, yi, '-');
                    continue;
                }
                if (!isOnVerticalLine) continue;
                this.set(xi, yi, '|');
            }
        }
    }

    public void replacePointMarkersOnLine() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                Cell cell2 = new Cell(xi, yi);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(cell2)) continue;
                boolean isOnHorizontalLine = false;
                if (StringUtils.isOneOf(this.get(cell2.getEast()), horizontalLines)) {
                    isOnHorizontalLine = true;
                }
                if (StringUtils.isOneOf(this.get(cell2.getWest()), horizontalLines)) {
                    isOnHorizontalLine = true;
                }
                boolean isOnVerticalLine = false;
                if (StringUtils.isOneOf(this.get(cell2.getNorth()), verticalLines)) {
                    isOnVerticalLine = true;
                }
                if (StringUtils.isOneOf(this.get(cell2.getSouth()), verticalLines)) {
                    isOnVerticalLine = true;
                }
                if (isOnHorizontalLine && isOnVerticalLine) {
                    this.set(xi, yi, '+');
                    continue;
                }
                if (isOnHorizontalLine) {
                    this.set(xi, yi, '-');
                    continue;
                }
                if (!isOnVerticalLine) continue;
                this.set(xi, yi, '|');
            }
        }
    }

    public CellSet getPointMarkersOnLine() {
        CellSet result = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(new Cell(xi, yi))) continue;
                result.add(new Cell(xi, yi));
            }
        }
        return result;
    }

    public void replaceHumanColorCodes() {
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            String row = this.rows.get(y).toString();
            for (String humanCode : humanColorCodes.keySet()) {
                String hexCode = humanColorCodes.get(humanCode);
                if (hexCode == null) continue;
                humanCode = "c" + humanCode;
                hexCode = "c" + hexCode;
                row = row.replaceAll(humanCode, hexCode);
                this.rows.set(y, new StringBuffer(row));
                row = this.rows.get(y).toString();
            }
        }
    }

    public void replaceAll(char c1, char c2) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                if (c != c1) continue;
                this.set(xi, yi, c2);
            }
        }
    }

    public boolean hasBlankCells() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell2 = new Cell(x, y);
                if (!this.isBlank(cell2)) continue;
                return true;
            }
        }
        return false;
    }

    public CellSet getAllNonBlank() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell2 = new Cell(x, y);
                if (this.isBlank(cell2)) continue;
                set.add(cell2);
            }
        }
        return set;
    }

    public CellSet getAllBoundaries() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell2 = new Cell(x, y);
                if (!this.isBoundary(cell2)) continue;
                set.add(cell2);
            }
        }
        return set;
    }

    public CellSet getAllBlanksBetweenCharacters() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell2 = new Cell(x, y);
                if (!this.isBlankBetweenCharacters(cell2)) continue;
                set.add(cell2);
            }
        }
        return set;
    }

    public ArrayList<CellStringPair> findStrings() {
        ArrayList<CellStringPair> result = new ArrayList<CellStringPair>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (this.isBlank(x, y)) continue;
                Cell start = new Cell(x, y);
                String str = String.valueOf(this.get(x, y));
                char c = this.get(++x, y);
                boolean finished = false;
                while (!finished) {
                    str = str + String.valueOf(c);
                    c = this.get(++x, y);
                    char next = this.get(x + 1, y);
                    if (c != ' ' && c != '\u0000' || next != ' ' && next != '\u0000') continue;
                    finished = true;
                }
                result.add(new CellStringPair(start, str));
            }
        }
        return result;
    }

    public boolean hasEntryPoint(Cell cell2, int entryPointId) {
        String result = "";
        char c = this.get(cell2);
        if (entryPointId == 1) {
            return StringUtils.isOneOf(c, entryPoints1);
        }
        if (entryPointId == 2) {
            return StringUtils.isOneOf(c, entryPoints2);
        }
        if (entryPointId == 3) {
            return StringUtils.isOneOf(c, entryPoints3);
        }
        if (entryPointId == 4) {
            return StringUtils.isOneOf(c, entryPoints4);
        }
        if (entryPointId == 5) {
            return StringUtils.isOneOf(c, entryPoints5);
        }
        if (entryPointId == 6) {
            return StringUtils.isOneOf(c, entryPoints6);
        }
        if (entryPointId == 7) {
            return StringUtils.isOneOf(c, entryPoints7);
        }
        if (entryPointId == 8) {
            return StringUtils.isOneOf(c, entryPoints8);
        }
        return false;
    }

    public boolean isBlankBetweenCharacters(Cell cell2) {
        return this.isBlank(cell2) && !this.isBlank(cell2.getEast()) && !this.isBlank(cell2.getWest());
    }

    public void removeNonText() {
        this.removeArrowheads();
        this.removeColorCodes();
        this.removeBoundaries();
        this.removeMarkupTags();
    }

    public void removeArrowheads() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell2 = new Cell(xi, yi);
                if (!this.isArrowhead(cell2)) continue;
                this.set(cell2, ' ');
            }
        }
    }

    public void removeColorCodes() {
        Iterator<CellColorPair> cells = this.findColorCodes().iterator();
        while (cells.hasNext()) {
            Cell cell2 = cells.next().cell;
            this.set(cell2, ' ');
            cell2 = cell2.getEast();
            this.set(cell2, ' ');
            cell2 = cell2.getEast();
            this.set(cell2, ' ');
            cell2 = cell2.getEast();
            this.set(cell2, ' ');
        }
    }

    public void removeBoundaries() {
        ArrayList<Cell> toBeRemoved = new ArrayList<Cell>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell2 = new Cell(xi, yi);
                if (!this.isBoundary(cell2)) continue;
                toBeRemoved.add(cell2);
            }
        }
        for (Cell cell3 : toBeRemoved) {
            this.set(cell3, ' ');
        }
    }

    public ArrayList findArrowheads() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell2 = new Cell(xi, yi);
                if (!this.isArrowhead(cell2)) continue;
                result.add(cell2);
            }
        }
        return result;
    }

    public ArrayList<CellColorPair> findColorCodes() {
        Pattern colorCodePattern = Pattern.compile("c[A-F0-9]{3}");
        ArrayList<CellColorPair> result = new ArrayList<CellColorPair>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width - 3; ++xi) {
                Cell cell2 = new Cell(xi, yi);
                String s = this.getStringAt(cell2, 4);
                Matcher matcher = colorCodePattern.matcher(s);
                if (!matcher.matches()) continue;
                char cR = s.charAt(1);
                char cG = s.charAt(2);
                char cB = s.charAt(3);
                int r = Integer.valueOf(String.valueOf(cR), 16) * 17;
                int g = Integer.valueOf(String.valueOf(cG), 16) * 17;
                int b = Integer.valueOf(String.valueOf(cB), 16) * 17;
                result.add(new CellColorPair(cell2, new Color(r, g, b)));
            }
        }
        return result;
    }

    public ArrayList<CellTagPair> findMarkupTags() {
        Pattern tagPattern = Pattern.compile("\\{(.+?)\\}");
        ArrayList<CellTagPair> result = new ArrayList<CellTagPair>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width - 3; ++x) {
                String tagName;
                String rowPart;
                Matcher matcher;
                Cell cell2 = new Cell(x, y);
                char c = this.get(cell2);
                if (c != '{' || !(matcher = tagPattern.matcher(rowPart = this.rows.get(y).substring(x))).find() || !markupTags.contains(tagName = matcher.group(1))) continue;
                result.add(new CellTagPair(new Cell(x, y), tagName));
            }
        }
        return result;
    }

    public void removeMarkupTags() {
        for (CellTagPair pair3 : this.findMarkupTags()) {
            String tagName = pair3.tag;
            if (tagName == null) continue;
            int length = 2 + tagName.length();
            this.writeStringTo(pair3.cell, StringUtils.repeatString(" ", length));
        }
    }

    public boolean matchesAny(GridPatternGroup criteria) {
        return criteria.isAnyMatchedBy(this);
    }

    public boolean matchesAll(GridPatternGroup criteria) {
        return criteria.areAllMatchedBy(this);
    }

    public boolean matches(GridPattern criteria) {
        return criteria.isMatchedBy(this);
    }

    public boolean isOnHorizontalLine(Cell cell2) {
        return this.isOnHorizontalLine(cell2.x, cell2.y);
    }

    private boolean isOnHorizontalLine(int x, int y) {
        char c1 = this.get(x - 1, y);
        char c2 = this.get(x + 1, y);
        return TextGrid.isHorizontalLine(c1) && TextGrid.isHorizontalLine(c2);
    }

    public boolean isOnVerticalLine(Cell cell2) {
        return this.isOnVerticalLine(cell2.x, cell2.y);
    }

    private boolean isOnVerticalLine(int x, int y) {
        char c1 = this.get(x, y - 1);
        char c2 = this.get(x, y + 1);
        return TextGrid.isVerticalLine(c1) && TextGrid.isVerticalLine(c2);
    }

    public static boolean isBoundary(char c) {
        return StringUtils.isOneOf(c, boundaries);
    }

    public boolean isBoundary(int x, int y) {
        return this.isBoundary(new Cell(x, y));
    }

    public boolean isBoundary(Cell cell2) {
        char c = this.get(cell2.x, cell2.y);
        if ('\u0000' == c) {
            return false;
        }
        if ('+' == c || '\\' == c || '/' == c) {
            return this.isIntersection(cell2) || this.isCorner(cell2) || this.isStub(cell2) || this.isCrossOnLine(cell2);
        }
        return StringUtils.isOneOf(c, boundaries) && !this.isLoneDiagonal(cell2);
    }

    public boolean isLine(Cell cell2) {
        return this.isHorizontalLine(cell2) || this.isVerticalLine(cell2);
    }

    public static boolean isHorizontalLine(char c) {
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public boolean isHorizontalLine(Cell cell2) {
        return this.isHorizontalLine(cell2.x, cell2.y);
    }

    public boolean isHorizontalLine(int x, int y) {
        char c = this.get(x, y);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public static boolean isVerticalLine(char c) {
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isVerticalLine(Cell cell2) {
        return this.isVerticalLine(cell2.x, cell2.y);
    }

    public boolean isVerticalLine(int x, int y) {
        char c = this.get(x, y);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isLinesEnd(int x, int y) {
        return this.isLinesEnd(new Cell(x, y));
    }

    public boolean isLinesEnd(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.linesEndCriteria);
    }

    public boolean isVerticalLinesEnd(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.verticalLinesEndCriteria);
    }

    public boolean isHorizontalLinesEnd(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.horizontalLinesEndCriteria);
    }

    public boolean isPointCell(Cell cell2) {
        return this.isCorner(cell2) || this.isIntersection(cell2) || this.isStub(cell2) || this.isLinesEnd(cell2);
    }

    public boolean containsAtLeastOneDashedLine(CellSet set) {
        for (Cell cell2 : set) {
            if (!StringUtils.isOneOf(this.get(cell2), dashedLines)) continue;
            return true;
        }
        return false;
    }

    public boolean exactlyOneNeighbourIsBoundary(Cell cell2) {
        int howMany = 0;
        if (this.isBoundary(cell2.getNorth())) {
            ++howMany;
        }
        if (this.isBoundary(cell2.getSouth())) {
            ++howMany;
        }
        if (this.isBoundary(cell2.getEast())) {
            ++howMany;
        }
        if (this.isBoundary(cell2.getWest())) {
            ++howMany;
        }
        return howMany == 1;
    }

    public boolean isStub(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.stubCriteria);
    }

    public boolean isCrossOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.crossOnLineCriteria);
    }

    public boolean isHorizontalCrossOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.horizontalCrossOnLineCriteria);
    }

    public boolean isVerticalCrossOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.verticalCrossOnLineCriteria);
    }

    public boolean isStarOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.starOnLineCriteria);
    }

    public boolean isLoneDiagonal(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.loneDiagonalCriteria);
    }

    public boolean isHorizontalStarOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.horizontalStarOnLineCriteria);
    }

    public boolean isVerticalStarOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.verticalStarOnLineCriteria);
    }

    public boolean isArrowhead(Cell cell2) {
        return this.isNorthArrowhead(cell2) || this.isSouthArrowhead(cell2) || this.isWestArrowhead(cell2) || this.isEastArrowhead(cell2);
    }

    public boolean isNorthArrowhead(Cell cell2) {
        return this.get(cell2) == '^';
    }

    public boolean isEastArrowhead(Cell cell2) {
        return this.get(cell2) == '>';
    }

    public boolean isWestArrowhead(Cell cell2) {
        return this.get(cell2) == '<';
    }

    public boolean isSouthArrowhead(Cell cell2) {
        return (this.get(cell2) == 'v' || this.get(cell2) == 'V') && this.isVerticalLine(cell2.getNorth());
    }

    public boolean isBullet(int x, int y) {
        return this.isBullet(new Cell(x, y));
    }

    public boolean isBullet(Cell cell2) {
        char c = this.get(cell2);
        return (c == 'o' || c == '*') && this.isBlank(cell2.getEast()) && this.isBlank(cell2.getWest()) && Character.isLetterOrDigit(this.get(cell2.getEast().getEast()));
    }

    public void replaceBullets() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell2 = new Cell(xi, yi);
                if (!this.isBullet(cell2)) continue;
                this.set(cell2, ' ');
                this.set(cell2.getEast(), '\u2022');
            }
        }
    }

    public boolean isStringsStart(Cell cell2) {
        return !this.isBlank(cell2) && this.isBlank(cell2.getWest());
    }

    public boolean isStringsEnd(Cell cell2) {
        return !this.isBlank(cell2) && this.isBlank(cell2.getEast());
    }

    public int otherStringsStartInTheSameColumn(Cell cell2) {
        if (!this.isStringsStart(cell2)) {
            return 0;
        }
        int result = 0;
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            Cell cCell = new Cell(cell2.x, y);
            if (cCell.equals(cell2) || !this.isStringsStart(cCell)) continue;
            ++result;
        }
        return result;
    }

    public int otherStringsEndInTheSameColumn(Cell cell2) {
        if (!this.isStringsEnd(cell2)) {
            return 0;
        }
        int result = 0;
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            Cell cCell = new Cell(cell2.x, y);
            if (cCell.equals(cell2) || !this.isStringsEnd(cCell)) continue;
            ++result;
        }
        return result;
    }

    public boolean isColumnBlank(int x) {
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            if (this.isBlank(x, y)) continue;
            return false;
        }
        return true;
    }

    public CellSet followLine(int x, int y) {
        return this.followLine(new Cell(x, y));
    }

    public CellSet followIntersection(Cell cell2) {
        return this.followIntersection(cell2, null);
    }

    public CellSet followIntersection(Cell cell2, Cell blocked) {
        if (!this.isIntersection(cell2)) {
            return null;
        }
        CellSet result = new CellSet();
        Cell cN = cell2.getNorth();
        Cell cS = cell2.getSouth();
        Cell cE = cell2.getEast();
        Cell cW = cell2.getWest();
        if (this.hasEntryPoint(cN, 6)) {
            result.add(cN);
        }
        if (this.hasEntryPoint(cS, 2)) {
            result.add(cS);
        }
        if (this.hasEntryPoint(cE, 8)) {
            result.add(cE);
        }
        if (this.hasEntryPoint(cW, 4)) {
            result.add(cW);
        }
        if (result.contains(blocked)) {
            result.remove(blocked);
        }
        return result;
    }

    public CellSet followLine(Cell cell2) {
        if (this.isHorizontalLine(cell2)) {
            CellSet result = new CellSet();
            if (this.isBoundary(cell2.getEast())) {
                result.add(cell2.getEast());
            }
            if (this.isBoundary(cell2.getWest())) {
                result.add(cell2.getWest());
            }
            return result;
        }
        if (this.isVerticalLine(cell2)) {
            CellSet result = new CellSet();
            if (this.isBoundary(cell2.getNorth())) {
                result.add(cell2.getNorth());
            }
            if (this.isBoundary(cell2.getSouth())) {
                result.add(cell2.getSouth());
            }
            return result;
        }
        return null;
    }

    public CellSet followLine(Cell cell2, Cell blocked) {
        CellSet nextCells = this.followLine(cell2);
        if (nextCells.contains(blocked)) {
            nextCells.remove(blocked);
        }
        return nextCells;
    }

    public CellSet followCorner(Cell cell2) {
        return this.followCorner(cell2, null);
    }

    public CellSet followCorner(Cell cell2, Cell blocked) {
        if (!this.isCorner(cell2)) {
            return null;
        }
        if (this.isCorner1(cell2)) {
            return this.followCorner1(cell2, blocked);
        }
        if (this.isCorner2(cell2)) {
            return this.followCorner2(cell2, blocked);
        }
        if (this.isCorner3(cell2)) {
            return this.followCorner3(cell2, blocked);
        }
        if (this.isCorner4(cell2)) {
            return this.followCorner4(cell2, blocked);
        }
        return null;
    }

    public CellSet followCorner1(Cell cell2) {
        return this.followCorner1(cell2, null);
    }

    public CellSet followCorner1(Cell cell2, Cell blocked) {
        if (!this.isCorner1(cell2)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell2.getSouth().equals(blocked)) {
            result.add(cell2.getSouth());
        }
        if (!cell2.getEast().equals(blocked)) {
            result.add(cell2.getEast());
        }
        return result;
    }

    public CellSet followCorner2(Cell cell2) {
        return this.followCorner2(cell2, null);
    }

    public CellSet followCorner2(Cell cell2, Cell blocked) {
        if (!this.isCorner2(cell2)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell2.getSouth().equals(blocked)) {
            result.add(cell2.getSouth());
        }
        if (!cell2.getWest().equals(blocked)) {
            result.add(cell2.getWest());
        }
        return result;
    }

    public CellSet followCorner3(Cell cell2) {
        return this.followCorner3(cell2, null);
    }

    public CellSet followCorner3(Cell cell2, Cell blocked) {
        if (!this.isCorner3(cell2)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell2.getNorth().equals(blocked)) {
            result.add(cell2.getNorth());
        }
        if (!cell2.getWest().equals(blocked)) {
            result.add(cell2.getWest());
        }
        return result;
    }

    public CellSet followCorner4(Cell cell2) {
        return this.followCorner4(cell2, null);
    }

    public CellSet followCorner4(Cell cell2, Cell blocked) {
        if (!this.isCorner4(cell2)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell2.getNorth().equals(blocked)) {
            result.add(cell2.getNorth());
        }
        if (!cell2.getEast().equals(blocked)) {
            result.add(cell2.getEast());
        }
        return result;
    }

    public CellSet followStub(Cell cell2) {
        return this.followStub(cell2, null);
    }

    public CellSet followStub(Cell cell2, Cell blocked) {
        if (!this.isStub(cell2)) {
            return null;
        }
        CellSet result = new CellSet();
        if (this.isBoundary(cell2.getEast())) {
            result.add(cell2.getEast());
        } else if (this.isBoundary(cell2.getWest())) {
            result.add(cell2.getWest());
        } else if (this.isBoundary(cell2.getNorth())) {
            result.add(cell2.getNorth());
        } else if (this.isBoundary(cell2.getSouth())) {
            result.add(cell2.getSouth());
        }
        if (result.contains(blocked)) {
            result.remove(blocked);
        }
        return result;
    }

    public CellSet followCell(Cell cell2) {
        return this.followCell(cell2, null);
    }

    public CellSet followCell(Cell cell2, Cell blocked) {
        if (this.isIntersection(cell2)) {
            return this.followIntersection(cell2, blocked);
        }
        if (this.isCorner(cell2)) {
            return this.followCorner(cell2, blocked);
        }
        if (this.isLine(cell2)) {
            return this.followLine(cell2, blocked);
        }
        if (this.isStub(cell2)) {
            return this.followStub(cell2, blocked);
        }
        if (this.isCrossOnLine(cell2)) {
            return this.followCrossOnLine(cell2, blocked);
        }
        System.err.println("Umbiguous input at position " + cell2 + ":");
        TextGrid subGrid = this.getTestingSubGrid(cell2);
        subGrid.printDebug();
        throw new RuntimeException("Cannot follow cell " + cell2 + ": cannot determine cell type");
    }

    public String getCellTypeAsString(Cell cell2) {
        if (this.isK(cell2)) {
            return "K";
        }
        if (this.isT(cell2)) {
            return "T";
        }
        if (this.isInverseK(cell2)) {
            return "inverse K";
        }
        if (this.isInverseT(cell2)) {
            return "inverse T";
        }
        if (this.isCorner1(cell2)) {
            return "corner 1";
        }
        if (this.isCorner2(cell2)) {
            return "corner 2";
        }
        if (this.isCorner3(cell2)) {
            return "corner 3";
        }
        if (this.isCorner4(cell2)) {
            return "corner 4";
        }
        if (this.isLine(cell2)) {
            return "line";
        }
        if (this.isStub(cell2)) {
            return "stub";
        }
        if (this.isCrossOnLine(cell2)) {
            return "crossOnLine";
        }
        return "unrecognisable type";
    }

    public CellSet followCrossOnLine(Cell cell2, Cell blocked) {
        CellSet result = new CellSet();
        if (this.isHorizontalCrossOnLine(cell2)) {
            result.add(cell2.getEast());
            result.add(cell2.getWest());
        } else if (this.isVerticalCrossOnLine(cell2)) {
            result.add(cell2.getNorth());
            result.add(cell2.getSouth());
        }
        if (result.contains(blocked)) {
            result.remove(blocked);
        }
        return result;
    }

    public boolean isOutOfBounds(Cell cell2) {
        return cell2.x > this.getWidth() - 1 || cell2.y > this.getHeight() - 1 || cell2.x < 0 || cell2.y < 0;
    }

    public boolean isOutOfBounds(int x, int y) {
        char c = this.get(x, y);
        return '\u0000' == c;
    }

    public boolean isBlank(Cell cell2) {
        char c = this.get(cell2);
        if ('\u0000' == c) {
            return false;
        }
        return c == ' ';
    }

    public boolean isBlank(int x, int y) {
        char c = this.get(x, y);
        if ('\u0000' == c) {
            return true;
        }
        return c == ' ';
    }

    public boolean isCorner(Cell cell2) {
        return this.isCorner(cell2.x, cell2.y);
    }

    public boolean isCorner(int x, int y) {
        return this.isNormalCorner(x, y) || this.isRoundCorner(x, y);
    }

    public boolean matchesAny(Cell cell2, GridPatternGroup criteria) {
        TextGrid subGrid = this.getTestingSubGrid(cell2);
        return subGrid.matchesAny(criteria);
    }

    public boolean isCorner1(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner1Criteria);
    }

    public boolean isCorner2(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner2Criteria);
    }

    public boolean isCorner3(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner3Criteria);
    }

    public boolean isCorner4(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner4Criteria);
    }

    public boolean isCross(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.crossCriteria);
    }

    public boolean isK(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.KCriteria);
    }

    public boolean isInverseK(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.inverseKCriteria);
    }

    public boolean isT(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.TCriteria);
    }

    public boolean isInverseT(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.inverseTCriteria);
    }

    public boolean isNormalCorner(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.normalCornerCriteria);
    }

    public boolean isNormalCorner(int x, int y) {
        return this.isNormalCorner(new Cell(x, y));
    }

    public boolean isRoundCorner(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.roundCornerCriteria);
    }

    public boolean isRoundCorner(int x, int y) {
        return this.isRoundCorner(new Cell(x, y));
    }

    public boolean isIntersection(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.intersectionCriteria);
    }

    public boolean isIntersection(int x, int y) {
        return this.isIntersection(new Cell(x, y));
    }

    public void copyCellsTo(CellSet cells, TextGrid grid) {
        for (Cell cell2 : cells) {
            grid.set(cell2, this.get(cell2));
        }
    }

    public boolean equals(TextGrid grid) {
        if (grid.getHeight() != this.getHeight() || grid.getWidth() != this.getWidth()) {
            return false;
        }
        int height = grid.getHeight();
        for (int i = 0; i < height; ++i) {
            String row2;
            String row1 = this.getRow(i).toString();
            if (row1.equals(row2 = grid.getRow(i).toString())) continue;
            return false;
        }
        return true;
    }

    public void fillCellsWith(Iterable cells, char c) {
        for (Cell cell2 : cells) {
            this.set(cell2.x, cell2.y, c);
        }
    }

    public CellSet fillContinuousArea(int x, int y, char c) {
        return this.fillContinuousArea(new Cell(x, y), c);
    }

    public CellSet fillContinuousArea(Cell cell2, char c) {
        if (this.isOutOfBounds(cell2)) {
            throw new IllegalArgumentException("Attempted to fill area out of bounds: " + cell2);
        }
        return this.seedFillOld(cell2, c);
    }

    private CellSet seedFill(Cell seed, char newChar) {
        CellSet cellsFilled = new CellSet();
        char oldChar = this.get(seed);
        if (oldChar == newChar) {
            return cellsFilled;
        }
        if (this.isOutOfBounds(seed)) {
            return cellsFilled;
        }
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(seed);
        while (!stack2.isEmpty()) {
            Cell cell2 = (Cell)stack2.pop();
            cellsFilled.add(cell2);
            Cell nCell = cell2.getNorth();
            Cell sCell = cell2.getSouth();
            Cell eCell = cell2.getEast();
            Cell wCell = cell2.getWest();
            if (this.get(nCell) == oldChar && !cellsFilled.contains(nCell)) {
                stack2.push(nCell);
            }
            if (this.get(sCell) == oldChar && !cellsFilled.contains(sCell)) {
                stack2.push(sCell);
            }
            if (this.get(eCell) == oldChar && !cellsFilled.contains(eCell)) {
                stack2.push(eCell);
            }
            if (this.get(wCell) != oldChar || cellsFilled.contains(wCell)) continue;
            stack2.push(wCell);
        }
        return cellsFilled;
    }

    private CellSet seedFillOld(Cell seed, char newChar) {
        CellSet cellsFilled = new CellSet();
        char oldChar = this.get(seed);
        if (oldChar == newChar) {
            return cellsFilled;
        }
        if (this.isOutOfBounds(seed)) {
            return cellsFilled;
        }
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(seed);
        while (!stack2.isEmpty()) {
            Cell cell2 = (Cell)stack2.pop();
            this.set(cell2, newChar);
            cellsFilled.add(cell2);
            Cell nCell = cell2.getNorth();
            Cell sCell = cell2.getSouth();
            Cell eCell = cell2.getEast();
            Cell wCell = cell2.getWest();
            if (this.get(nCell) == oldChar) {
                stack2.push(nCell);
            }
            if (this.get(sCell) == oldChar) {
                stack2.push(sCell);
            }
            if (this.get(eCell) == oldChar) {
                stack2.push(eCell);
            }
            if (this.get(wCell) != oldChar) continue;
            stack2.push(wCell);
        }
        return cellsFilled;
    }

    public CellSet findBoundariesExpandingFrom(Cell seed) {
        CellSet boundaries = new CellSet();
        char oldChar = this.get(seed);
        if (this.isOutOfBounds(seed)) {
            return boundaries;
        }
        char newChar = '\u0001';
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(seed);
        while (!stack2.isEmpty()) {
            Cell cell2 = (Cell)stack2.pop();
            this.set(cell2, newChar);
            Cell nCell = cell2.getNorth();
            Cell sCell = cell2.getSouth();
            Cell eCell = cell2.getEast();
            Cell wCell = cell2.getWest();
            if (this.get(nCell) == oldChar) {
                stack2.push(nCell);
            } else if (this.get(nCell) == '*') {
                boundaries.add(nCell);
            }
            if (this.get(sCell) == oldChar) {
                stack2.push(sCell);
            } else if (this.get(sCell) == '*') {
                boundaries.add(sCell);
            }
            if (this.get(eCell) == oldChar) {
                stack2.push(eCell);
            } else if (this.get(eCell) == '*') {
                boundaries.add(eCell);
            }
            if (this.get(wCell) == oldChar) {
                stack2.push(wCell);
                continue;
            }
            if (this.get(wCell) != '*') continue;
            boundaries.add(wCell);
        }
        return boundaries;
    }

    private CellSet seedFillLine(Cell cell2, char newChar) {
        CellSet cellsFilled = new CellSet();
        Stack<LineSegment> stack2 = new Stack<LineSegment>();
        char oldChar = this.get(cell2);
        if (oldChar == newChar) {
            return cellsFilled;
        }
        if (this.isOutOfBounds(cell2)) {
            return cellsFilled;
        }
        stack2.push(new LineSegment(cell2.x, cell2.x, cell2.y, 1));
        stack2.push(new LineSegment(cell2.x, cell2.x, cell2.y + 1, -1));
        while (!stack2.isEmpty()) {
            boolean skip;
            int x;
            LineSegment segment2 = (LineSegment)stack2.pop();
            for (x = segment2.x1; x >= 0 && this.get(x, segment2.y) == oldChar; --x) {
                this.set(x, segment2.y, newChar);
                cellsFilled.add(new Cell(x, segment2.y));
            }
            int left = cell2.getEast().x;
            boolean bl = skip = x > segment2.x1;
            if (left < segment2.x1) {
                stack2.push(new LineSegment(x, left, segment2.y - 1, -segment2.dy));
            }
            x = segment2.x1 + 1;
            do {
                if (!skip) {
                    while (x < this.getWidth() && this.get(x, segment2.y) == oldChar) {
                        this.set(x, segment2.y, newChar);
                        cellsFilled.add(new Cell(x, segment2.y));
                        ++x;
                    }
                    stack2.push(new LineSegment(left, x - 1, segment2.y, segment2.dy));
                    if (x > segment2.x2 + 1) {
                        stack2.push(new LineSegment(segment2.x2 + 1, x - 1, segment2.y, -segment2.dy));
                    }
                }
                skip = false;
                ++x;
                while (x <= segment2.x2 && this.get(x, segment2.y) != oldChar) {
                    ++x;
                }
                left = x;
            } while (x < segment2.x2);
        }
        return cellsFilled;
    }

    public boolean cellContainsDashedLineChar(Cell cell2) {
        char c = this.get(cell2);
        return StringUtils.isOneOf(c, dashedLines);
    }

    public boolean loadFrom(String filename) throws FileNotFoundException, IOException {
        return this.loadFrom(filename, null);
    }

    public boolean loadFrom(String filename, ProcessingOptions options) throws IOException {
        String encoding = options == null ? null : options.getCharacterEncoding();
        ArrayList<StringBuffer> lines = new ArrayList<StringBuffer>();
        String[] linesArray = FileUtils.readFile(new File(filename), encoding).split("(\r)?\n");
        for (int i = 0; i < linesArray.length; ++i) {
            lines.add(new StringBuffer(linesArray[i]));
        }
        return this.initialiseWithLines(lines, options);
    }

    public boolean initialiseWithText(String text, ProcessingOptions options) throws UnsupportedEncodingException {
        ArrayList<StringBuffer> lines = new ArrayList<StringBuffer>();
        String[] linesArray = text.split("(\r)?\n");
        for (int i = 0; i < linesArray.length; ++i) {
            lines.add(new StringBuffer(linesArray[i]));
        }
        return this.initialiseWithLines(lines, options);
    }

    public boolean initialiseWithLines(ArrayList<StringBuffer> lines, ProcessingOptions options) throws UnsupportedEncodingException {
        boolean done = false;
        int i = lines.size() - 1;
        while (!done) {
            StringBuffer row = lines.get(i);
            if (!StringUtils.isBlank(row.toString())) {
                done = true;
            }
            --i;
        }
        this.rows = new ArrayList<StringBuffer>(lines.subList(0, i + 2));
        if (options != null) {
            this.fixTabs(options.getTabSize());
        } else {
            this.fixTabs(8);
        }
        int blankBorderSize = 2;
        int maxLength = 0;
        int index = 0;
        String encoding = null;
        Iterator<StringBuffer> it = this.rows.iterator();
        while (it.hasNext()) {
            String row = it.next().toString();
            if (encoding != null) {
                byte[] bytes = row.getBytes();
                row = new String(bytes, encoding);
            }
            if (row.length() > maxLength) {
                maxLength = row.length();
            }
            this.rows.set(index, new StringBuffer(row));
            ++index;
        }
        it = this.rows.iterator();
        ArrayList<StringBuffer> newRows = new ArrayList<StringBuffer>();
        StringBuffer topBottomRow = new StringBuffer(StringUtils.repeatString(" ", maxLength + blankBorderSize * 2));
        newRows.add(topBottomRow);
        newRows.add(topBottomRow);
        while (it.hasNext()) {
            StringBuffer row = it.next();
            if (row.length() < maxLength) {
                String borderString = StringUtils.repeatString(" ", blankBorderSize);
                StringBuffer newRow = new StringBuffer();
                newRow.append(borderString);
                newRow.append(row);
                newRow.append(StringUtils.repeatString(" ", maxLength - row.length()));
                newRow.append(borderString);
                newRows.add(newRow);
                continue;
            }
            newRows.add(new StringBuffer("  ").append(row).append("  "));
        }
        newRows.add(topBottomRow);
        newRows.add(topBottomRow);
        this.rows = newRows;
        this.replaceBullets();
        this.replaceHumanColorCodes();
        return true;
    }

    private void fixTabs(int tabSize) {
        int rowIndex = 0;
        Iterator<StringBuffer> it = this.rows.iterator();
        while (it.hasNext()) {
            String row = it.next().toString();
            StringBuffer newRow = new StringBuffer();
            char[] chars = row.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\t') {
                    int spacesLeft = tabSize - newRow.length() % tabSize;
                    String spaces = StringUtils.repeatString(" ", spacesLeft);
                    newRow.append(spaces);
                    continue;
                }
                String character = Character.toString(chars[i]);
                newRow.append(character);
            }
            this.rows.set(rowIndex, newRow);
            ++rowIndex;
        }
    }

    protected ArrayList<StringBuffer> getRows() {
        return this.rows;
    }

    static {
        humanColorCodes.put("GRE", "9D9");
        humanColorCodes.put("BLU", "55B");
        humanColorCodes.put("PNK", "FAA");
        humanColorCodes.put("RED", "E32");
        humanColorCodes.put("YEL", "FF3");
        humanColorCodes.put("BLK", "000");
        markupTags = new HashSet();
        markupTags.add("d");
        markupTags.add("s");
        markupTags.add("io");
        markupTags.add("c");
        markupTags.add("mo");
        markupTags.add("tr");
        markupTags.add("o");
    }

    private class LineSegment {
        int x1;
        int x2;
        int y;
        int dy;

        public LineSegment(int x1, int x2, int y, int dy) {
            this.x1 = x1;
            this.x2 = x2;
            this.y = y;
            this.dy = dy;
        }
    }

    public class Cell {
        public int x;
        public int y;

        public Cell(Cell cell2) {
            this(cell2.x, cell2.y);
        }

        public Cell(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Cell getNorth() {
            return new Cell(this.x, this.y - 1);
        }

        public Cell getSouth() {
            return new Cell(this.x, this.y + 1);
        }

        public Cell getEast() {
            return new Cell(this.x + 1, this.y);
        }

        public Cell getWest() {
            return new Cell(this.x - 1, this.y);
        }

        public Cell getNW() {
            return new Cell(this.x - 1, this.y - 1);
        }

        public Cell getNE() {
            return new Cell(this.x + 1, this.y - 1);
        }

        public Cell getSW() {
            return new Cell(this.x - 1, this.y + 1);
        }

        public Cell getSE() {
            return new Cell(this.x + 1, this.y + 1);
        }

        public CellSet getNeighbours4() {
            CellSet result = new CellSet();
            result.add(this.getNorth());
            result.add(this.getSouth());
            result.add(this.getWest());
            result.add(this.getEast());
            return result;
        }

        public CellSet getNeighbours8() {
            CellSet result = new CellSet();
            result.add(this.getNorth());
            result.add(this.getSouth());
            result.add(this.getWest());
            result.add(this.getEast());
            result.add(this.getNW());
            result.add(this.getNE());
            result.add(this.getSW());
            result.add(this.getSE());
            return result;
        }

        public boolean isNorthOf(Cell cell2) {
            return this.y < cell2.y;
        }

        public boolean isSouthOf(Cell cell2) {
            return this.y > cell2.y;
        }

        public boolean isWestOf(Cell cell2) {
            return this.x < cell2.x;
        }

        public boolean isEastOf(Cell cell2) {
            return this.x > cell2.x;
        }

        public boolean equals(Object o) {
            Cell cell2 = (Cell)o;
            if (cell2 == null) {
                return false;
            }
            return this.x == cell2.x && this.y == cell2.y;
        }

        public int hashCode() {
            return this.x << 16 | this.y;
        }

        public boolean isNextTo(int x2, int y2) {
            if (Math.abs(x2 - this.x) == 1 && Math.abs(y2 - this.y) == 1) {
                return false;
            }
            if (Math.abs(x2 - this.x) == 1 && y2 == this.y) {
                return true;
            }
            return Math.abs(y2 - this.y) == 1 && x2 == this.x;
        }

        public boolean isNextTo(Cell cell2) {
            if (cell2 == null) {
                throw new IllegalArgumentException("cell cannot be null");
            }
            return this.isNextTo(cell2.x, cell2.y);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public void scale(int s) {
            this.x *= s;
            this.y *= s;
        }
    }

    public class CellTagPair {
        public Cell cell;
        public String tag;

        public CellTagPair(Cell cell2, String tag) {
            this.cell = cell2;
            this.tag = tag;
        }
    }

    public class CellStringPair {
        public Cell cell;
        public String string;

        public CellStringPair(Cell cell2, String string) {
            this.cell = cell2;
            this.string = string;
        }
    }

    public class CellColorPair {
        public Color color;
        public Cell cell;

        public CellColorPair(Cell cell2, Color color) {
            this.cell = cell2;
            this.color = color;
        }
    }
}

