/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.TextGrid;

public class CellSet
implements Iterable<TextGrid.Cell> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    public static final int TYPE_CLOSED = 0;
    public static final int TYPE_OPEN = 1;
    public static final int TYPE_MIXED = 2;
    public static final int TYPE_HAS_CLOSED_AREA = 3;
    public static final int TYPE_UNDETERMINED = 4;
    Set<TextGrid.Cell> internalSet = new HashSet<TextGrid.Cell>();
    private int type = 4;
    private boolean typeIsValid = false;
    private static final Object FAKE = new Object();

    public CellSet() {
    }

    public CellSet(CellSet other) {
        this.addAll(other);
    }

    @Override
    public Iterator<TextGrid.Cell> iterator() {
        return this.internalSet.iterator();
    }

    public Object add(TextGrid.Cell cell2) {
        return this.internalSet.add(cell2);
    }

    public void addAll(CellSet set) {
        this.internalSet.addAll(set.internalSet);
    }

    void clear() {
        this.internalSet.clear();
    }

    public int size() {
        return this.internalSet.size();
    }

    public TextGrid.Cell getFirst() {
        return this.internalSet.iterator().next();
    }

    public void printAsGrid() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        grid.printDebug();
    }

    public void printDebug() {
        Iterator<TextGrid.Cell> it = this.iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell2 = it.next();
            System.out.print(cell2);
            if (!it.hasNext()) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    public String getCellsAsString() {
        StringBuffer str = new StringBuffer();
        Iterator<TextGrid.Cell> it = this.iterator();
        while (it.hasNext()) {
            str.append(it.next().toString());
            if (!it.hasNext()) continue;
            str.append("/");
        }
        return str.toString();
    }

    public String toString() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        return grid.getDebugString();
    }

    public static CellSet copyCellSet(CellSet set) {
        TextGrid grid = new TextGrid();
        CellSet newSet = new CellSet();
        for (TextGrid.Cell cell2 : set) {
            TextGrid textGrid = grid;
            textGrid.getClass();
            TextGrid.Cell newCell = new TextGrid.Cell(textGrid, cell2);
            newSet.add(newCell);
        }
        return newSet;
    }

    public int getType(TextGrid grid) {
        if (this.typeIsValid) {
            return this.type;
        }
        this.typeIsValid = true;
        if (this.size() == 1) {
            this.type = 1;
            return 1;
        }
        int typeTrace = this.getTypeAccordingToTraceMethod(grid);
        if (typeTrace == 1) {
            this.type = 1;
            return 1;
        }
        if (typeTrace == 0) {
            this.type = 0;
            return 0;
        }
        if (typeTrace == 4) {
            int typeFill = this.getTypeAccordingToFillMethod(grid);
            if (typeFill == 3) {
                this.type = 2;
                return 2;
            }
            if (typeFill == 1) {
                this.type = 1;
                return 1;
            }
        }
        this.type = 4;
        return 4;
    }

    private int getTypeAccordingToTraceMethod(TextGrid grid) {
        TextGrid.Cell cell22;
        if (this.size() < 2) {
            return 1;
        }
        TextGrid workGrid = TextGrid.makeSameSizeAs(grid);
        grid.copyCellsTo(this, workGrid);
        TextGrid.Cell start = null;
        for (TextGrid.Cell cell22 : this) {
            if (!workGrid.isLinesEnd(cell22)) continue;
            start = cell22;
        }
        if (start == null) {
            start = this.getFirst();
        }
        TextGrid.Cell previous = start;
        cell22 = null;
        CellSet nextCells = workGrid.followCell(previous);
        if (nextCells.size() == 0) {
            return 1;
        }
        cell22 = nextCells.getFirst();
        while (!cell22.equals(start)) {
            nextCells = workGrid.followCell(cell22, previous);
            if (nextCells.size() == 0) {
                return 1;
            }
            if (nextCells.size() == 1) {
                previous = cell22;
                cell22 = nextCells.getFirst();
                continue;
            }
            if (nextCells.size() <= 1) continue;
            return 4;
        }
        return 0;
    }

    private int getTypeAccordingToFillMethod(TextGrid grid) {
        if (this.size() == 0) {
            return 1;
        }
        CellSet tempSet = CellSet.copyCellSet(this);
        tempSet.translate(-this.getMinX() + 1, -this.getMinY() + 1);
        TextGrid subGrid = grid.getSubGrid(this.getMinX() - 1, this.getMinY() - 1, this.getWidth() + 3, this.getHeight() + 3);
        AbstractionGrid abstraction = new AbstractionGrid(subGrid, tempSet);
        TextGrid temp = abstraction.getCopyOfInternalBuffer();
        Object cell1 = null;
        Object cell2 = null;
        int width = temp.getWidth();
        int height = temp.getHeight();
        TextGrid.Cell fillCell = null;
        block0: for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                TextGrid textGrid = temp;
                textGrid.getClass();
                TextGrid.Cell cCell = new TextGrid.Cell(textGrid, x, y);
                if (!temp.isBlank(cCell)) continue;
                fillCell = cCell;
                continue block0;
            }
        }
        if (fillCell == null) {
            System.err.println("Unexpected error: fill method cannot fill anywhere");
            return 4;
        }
        temp.fillContinuousArea(fillCell, '*');
        if (temp.hasBlankCells()) {
            return 3;
        }
        return 1;
    }

    public void translate(int dx, int dy) {
        this.typeIsValid = false;
        for (TextGrid.Cell cCell : this) {
            cCell.x += dx;
            cCell.y += dy;
        }
    }

    public TextGrid.Cell find(TextGrid.Cell cell2) {
        for (TextGrid.Cell cCell : this) {
            if (!cCell.equals(cell2)) continue;
            return cCell;
        }
        return null;
    }

    public boolean contains(TextGrid.Cell cell2) {
        if (cell2 == null) {
            return false;
        }
        return this.internalSet.contains(cell2);
    }

    public void addSet(CellSet set) {
        this.typeIsValid = false;
        this.addAll(set);
    }

    public boolean hasCommonCells(CellSet otherSet) {
        for (TextGrid.Cell cell2 : this) {
            if (!otherSet.contains(cell2)) continue;
            return true;
        }
        return false;
    }

    public TextGrid.Cell find(int x, int y) {
        for (TextGrid.Cell cCell : this) {
            if (cCell.x != x || cCell.y != y) continue;
            return cCell;
        }
        return null;
    }

    public CellSet getFilledEquivalent(TextGrid textGrid) {
        if (this.getType(textGrid) == 1) {
            return new CellSet(this);
        }
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        TextGrid.Cell cell2 = null;
        boolean finished = false;
        for (int y = 0; y < grid.getHeight() && !finished; ++y) {
            for (int x = 0; x < grid.getWidth() && !finished; ++x) {
                TextGrid textGrid2 = grid;
                textGrid2.getClass();
                cell2 = new TextGrid.Cell(textGrid2, x, y);
                if (grid.isBlank(cell2) || !grid.isBlank(cell2.getEast()) || !grid.isBlank(cell2.getWest())) continue;
                finished = true;
            }
        }
        if (cell2 != null) {
            if (grid.isOutOfBounds(cell2 = cell2.getEast())) {
                return new CellSet(this);
            }
            grid.fillContinuousArea(cell2, '*');
            return grid.getAllNonBlank();
        }
        System.err.println("Unexpected error, cannot find the filled equivalent of CellSet");
        return null;
    }

    public TextGrid.Cell findCellNextTo(TextGrid.Cell cell2) {
        for (TextGrid.Cell cCell : this) {
            if (!cCell.isNextTo(cell2)) continue;
            return cCell;
        }
        return null;
    }

    public CellSet findCellsNextTo(TextGrid.Cell cell2) {
        if (cell2 == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        CellSet set = new CellSet();
        for (TextGrid.Cell cCell : this) {
            if (!cCell.isNextTo(cell2)) continue;
            set.add(cCell);
        }
        return set;
    }

    public void appendSet(CellSet set) {
        this.typeIsValid = false;
        for (TextGrid.Cell cell2 : set) {
            if (this.find(cell2) != null) continue;
            this.add(cell2);
        }
    }

    public void subtractSet(CellSet set) {
        this.typeIsValid = false;
        for (TextGrid.Cell cell2 : set) {
            TextGrid.Cell thisCell = this.find(cell2);
            if (thisCell == null) continue;
            this.remove(thisCell);
        }
    }

    public int getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public int getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public int getMaxX() {
        int result = 0;
        for (TextGrid.Cell cell2 : this) {
            if (cell2.x <= result) continue;
            result = cell2.x;
        }
        return result;
    }

    public int getMinX() {
        int result = Integer.MAX_VALUE;
        for (TextGrid.Cell cell2 : this) {
            if (cell2.x >= result) continue;
            result = cell2.x;
        }
        return result;
    }

    public int getMaxY() {
        int result = 0;
        for (TextGrid.Cell cell2 : this) {
            if (cell2.y <= result) continue;
            result = cell2.y;
        }
        return result;
    }

    public int getMinY() {
        int result = Integer.MAX_VALUE;
        for (TextGrid.Cell cell2 : this) {
            if (cell2.y >= result) continue;
            result = cell2.y;
        }
        return result;
    }

    public Object remove(TextGrid.Cell cell2) {
        this.typeIsValid = false;
        if ((cell2 = this.find(cell2)) != null) {
            return this.internalSet.remove(cell2);
        }
        return null;
    }

    public boolean equals(Object o) {
        CellSet otherSet = (CellSet)o;
        return this.internalSet.equals(otherSet.internalSet);
    }

    public static ArrayList removeDuplicateSets(ArrayList list) {
        ArrayList<CellSet> uniqueSets = new ArrayList<CellSet>();
        for (CellSet set : list) {
            boolean isOriginal = true;
            for (CellSet uniqueSet : uniqueSets) {
                if (!set.equals(uniqueSet)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            uniqueSets.add(set);
        }
        return uniqueSets;
    }

    public ArrayList breakIntoDistinctBoundaries(TextGrid grid) {
        AbstractionGrid temp = new AbstractionGrid(grid, this);
        ArrayList result = temp.getDistinctShapes();
        return result;
    }

    public ArrayList breakIntoDistinctBoundaries() {
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        TextGrid boundaryGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        boundaryGrid.fillCellsWith(this, '*');
        for (TextGrid.Cell cell2 : this) {
            if (boundaryGrid.isBlank(cell2.x, cell2.y)) continue;
            CellSet boundarySet = boundaryGrid.fillContinuousArea(cell2.x, cell2.y, ' ');
            result.add(boundarySet);
        }
        return result;
    }

    public ArrayList breakTrulyMixedBoundaries(TextGrid grid) {
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        CellSet visitedEnds = new CellSet();
        TextGrid workGrid = TextGrid.makeSameSizeAs(grid);
        grid.copyCellsTo(this, workGrid);
        for (TextGrid.Cell start : this) {
            if (!workGrid.isLinesEnd(start) || visitedEnds.contains(start)) continue;
            CellSet set = new CellSet();
            set.add(start);
            TextGrid.Cell previous = start;
            TextGrid.Cell cell2 = null;
            CellSet nextCells = workGrid.followCell(previous);
            if (nextCells.size() == 0) {
                throw new IllegalArgumentException("This shape is either open but multipart or has only one cell, and cannot be processed by this method");
            }
            cell2 = nextCells.getFirst();
            set.add(cell2);
            boolean finished = false;
            if (workGrid.isLinesEnd(cell2)) {
                visitedEnds.add(cell2);
                finished = true;
            }
            while (!finished) {
                nextCells = workGrid.followCell(cell2, previous);
                if (nextCells.size() == 1) {
                    set.add(cell2);
                    previous = cell2;
                    cell2 = nextCells.getFirst();
                    if (!workGrid.isLinesEnd(cell2)) continue;
                    visitedEnds.add(cell2);
                    finished = true;
                    continue;
                }
                if (nextCells.size() <= 1) continue;
                finished = true;
            }
            result.add(set);
        }
        CellSet whatsLeft = new CellSet(this);
        for (CellSet set : result) {
            whatsLeft.subtractSet(set);
        }
        result.add(whatsLeft);
        return result;
    }

    public TextGrid makeIntoGrid() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        return grid;
    }

    public CellSet makeScaledOneThirdEquivalent() {
        TextGrid gridBig = this.makeIntoGrid();
        gridBig.fillCellsWith(this, '*');
        TextGrid gridSmall = new TextGrid((this.getMaxX() + 2) / 3, (this.getMaxY() + 2) / 3);
        for (int y = 0; y < gridBig.getHeight(); ++y) {
            for (int x = 0; x < gridBig.getWidth(); ++x) {
                TextGrid textGrid = gridBig;
                textGrid.getClass();
                TextGrid.Cell cell2 = new TextGrid.Cell(textGrid, x, y);
                if (gridBig.isBlank(cell2)) continue;
                gridSmall.set(x / 3, y / 3, '*');
            }
        }
        return gridSmall.getAllNonBlank();
    }
}

