/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tikz;

import java.awt.Color;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.version.Version;

public class TikzGraphics {
    private final List<String> cmd = new ArrayList<String>();
    private final boolean withPreamble;
    private Color color = Color.BLACK;
    private Color fillcolor = Color.BLACK;
    private Color fillcolorGradient2 = null;
    private char gradientPolicy;
    private double thickness = 1.0;
    private final double scale;
    private String dash = null;
    private final Map<Color, String> colornames = new LinkedHashMap<Color, String>();
    private final Map<String, Integer> styles = new LinkedHashMap<String, Integer>();
    private final Map<String, String> stylesID = new HashMap<String, String>();
    private String pendingUrl = null;
    private boolean urlIgnoreText = false;
    private boolean hasUrl = false;

    public TikzGraphics(double scale, boolean withPreamble) {
        this.withPreamble = withPreamble;
        this.scale = scale;
    }

    private void addCommand(StringBuilder sb) {
        int end;
        String s = sb.toString();
        this.cmd.add(s);
        if ((s.startsWith("\\draw[") || s.startsWith("\\shade[")) && (end = s.indexOf(93)) != -1) {
            int start = s.indexOf(91);
            String style = s.substring(start + 1, end);
            Integer count = this.styles.get(style);
            if (count == null) {
                count = 1;
                this.stylesID.put(style, "pstyle" + this.stylesID.size());
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            this.styles.put(style, count);
        }
    }

    private String getColorName(Color c) {
        if (c.equals(Color.WHITE)) {
            return "white";
        }
        if (c.equals(Color.BLACK)) {
            return "black";
        }
        String result = this.colornames.get(c);
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public void createData(OutputStream os) throws IOException {
        if (this.withPreamble) {
            this.out(os, "\\documentclass{standalone}");
            this.out(os, "\\usepackage{tikz}");
            this.out(os, "\\usepackage{aeguill}");
            if (this.hasUrl) {
                this.out(os, "\\usetikzlibrary{calc}");
                this.out(os, "\\usepackage{hyperref}");
            }
            this.out(os, "\\begin{document}");
        }
        this.out(os, "% generated by Plantuml " + Version.versionString(15));
        if (this.hasUrl && this.withPreamble) {
            this.out(os, "\\tikzset{");
            this.out(os, "    href node/.style={");
            this.out(os, "        alias=sourcenode,");
            this.out(os, "        append after command={");
            this.out(os, "            let \\p1 = (sourcenode.north west),");
            this.out(os, "                \\p2=(sourcenode.south east),");
            this.out(os, "                \\n1={\\x2-\\x1},");
            this.out(os, "                \\n2={\\y2-\\y1} in");
            this.out(os, "            node [inner sep=0pt, outer sep=0pt,anchor=north west,at=(\\p1)] {\\href{#1}{\\XeTeXLinkBox{\\phantom{\\rule{\\n1}{\\n2}}}}}");
            this.out(os, "                    %xelatex needs \\XeTeXLinkBox, won't create a link unless it");
            this.out(os, "                    %finds text --- rules don't work without \\XeTeXLinkBox.");
            this.out(os, "                    %Still builds correctly with pdflatex and lualatex");
            this.out(os, "        }");
            this.out(os, "    }");
            this.out(os, "}");
            this.out(os, "\\tikzset{");
            this.out(os, "    hyperref node/.style={");
            this.out(os, "        alias=sourcenode,");
            this.out(os, "        append after command={");
            this.out(os, "            let \\p1 = (sourcenode.north west),");
            this.out(os, "                \\p2=(sourcenode.south east),");
            this.out(os, "                \\n1={\\x2-\\x1},");
            this.out(os, "                \\n2={\\y2-\\y1} in");
            this.out(os, "            node [inner sep=0pt, outer sep=0pt,anchor=north west,at=(\\p1)] {\\hyperref [#1]{\\XeTeXLinkBox{\\phantom{\\rule{\\n1}{\\n2}}}}}");
            this.out(os, "                    %xelatex needs \\XeTeXLinkBox, won't create a link unless it");
            this.out(os, "                    %finds text --- rules don't work without \\XeTeXLinkBox.");
            this.out(os, "                    %Still builds correctly with pdflatex and lualatex");
            this.out(os, "        }");
            this.out(os, "    }");
            this.out(os, "}");
        }
        for (Map.Entry<Color, String> ent : this.colornames.entrySet()) {
            this.out(os, this.definecolor(ent.getValue(), ent.getKey()));
        }
        if (this.scale != 1.0) {
            this.out(os, "\\scalebox{" + this.format(this.scale) + "}{");
        }
        this.out(os, "\\begin{tikzpicture}[yscale=-1");
        this.purgeStyles();
        for (String style : this.styles.keySet()) {
            this.out(os, "," + this.stylesID.get(style) + "/.style={" + style + "}");
        }
        this.out(os, "]");
        for (String s : this.cmd) {
            this.out(os, this.useStyle(s));
        }
        this.out(os, "\\end{tikzpicture}");
        if (this.scale != 1.0) {
            this.out(os, "}");
        }
        if (this.withPreamble) {
            this.out(os, "\\end{document}");
        }
    }

    private String useStyle(String s) {
        for (String style : this.styles.keySet()) {
            String start1 = "\\draw[" + style + "]";
            if (s.startsWith(start1)) {
                String newStart = "\\draw[" + this.stylesID.get(style) + "]";
                return newStart + s.substring(start1.length());
            }
            String start2 = "\\shade[" + style + "]";
            if (!s.startsWith(start2)) continue;
            String newStart = "\\shade[" + this.stylesID.get(style) + "]";
            return newStart + s.substring(start2.length());
        }
        return s;
    }

    private void purgeStyles() {
        Iterator<Map.Entry<String, Integer>> it = this.styles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Integer> ent = it.next();
            if (ent.getValue() != 1) continue;
            it.remove();
        }
    }

    private String definecolor(String name, Color color) {
        return "\\definecolor{" + name + "}{RGB}{" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "}";
    }

    public void rectangle(double x, double y, double width, double height) {
        StringBuilder sb = new StringBuilder();
        if (this.pendingUrl == null) {
            this.appendShadeOrDraw(sb);
            sb.append("line width=" + this.thickness + "pt] ");
            sb.append(this.couple(x, y) + " rectangle " + this.couple(x + width, y + height));
            sb.append(";");
        } else {
            sb.append("\\node at " + this.couple(x, y) + "[draw, ");
            if (this.color != null) {
                sb.append("color=" + this.getColorName(this.color) + ",");
            }
            if (this.fillcolor != null) {
                sb.append("fill=" + this.getColorName(this.fillcolor) + ",");
                if (this.color == null) {
                    sb.append("color=" + this.getColorName(this.fillcolor) + ",");
                }
            }
            sb.append("line width=" + this.thickness + "pt,");
            sb.append("below right,");
            sb.append("inner sep=2ex,");
            sb.append("minimum width=" + this.format(width) + "pt,");
            sb.append("minimum height=" + this.format(height) + "pt,");
            if (Url.isLatex(this.pendingUrl)) {
                sb.append("hyperref node=" + TikzGraphics.extractInternalHref(this.pendingUrl));
            } else {
                sb.append("href node=" + this.pendingUrl);
            }
            sb.append("] ");
            sb.append(" {};");
            this.urlIgnoreText = true;
        }
        this.addCommand(sb);
    }

    private String getAngleFromGradientPolicy() {
        if (this.gradientPolicy == '-') {
            return "0";
        }
        if (this.gradientPolicy == '|') {
            return "90";
        }
        if (this.gradientPolicy == '/') {
            return "45";
        }
        if (this.gradientPolicy == '\\') {
            return "135";
        }
        throw new IllegalArgumentException();
    }

    private String couple(double x, double y) {
        return "(" + this.format(x) + "pt," + this.format(y) + "pt)";
    }

    private String format(double x) {
        return EpsGraphics.format(x);
    }

    private void out(OutputStream os, String s) throws IOException {
        os.write(s.getBytes("UTF-8"));
        os.write("\n".getBytes("UTF-8"));
    }

    public void text(double x, double y, String text, boolean underline, boolean italic, boolean bold) {
        StringBuilder sb = new StringBuilder("\\node at " + this.couple(x, y));
        sb.append("[below right");
        if (this.color != null) {
            sb.append(",color=");
            sb.append(this.getColorName(this.color));
        }
        sb.append("]{");
        if (this.pendingUrl == null || this.urlIgnoreText) {
            if (underline) {
                sb.append("\\underline{");
            }
            if (italic) {
                sb.append("\\textit{");
            }
            if (bold) {
                sb.append("\\textbf{");
            }
            sb.append(this.protectText(text));
            if (bold) {
                sb.append("}");
            }
            if (italic) {
                sb.append("}");
            }
            if (underline) {
                sb.append("}");
            }
        } else {
            this.appendPendingUrl(sb);
            sb.append("{");
            sb.append(this.protectText(text));
            sb.append("}");
        }
        sb.append("};");
        this.addCommand(sb);
    }

    private void appendPendingUrl(StringBuilder sb) {
        if (Url.isLatex(this.pendingUrl)) {
            sb.append("\\hyperref[");
            sb.append(TikzGraphics.extractInternalHref(this.pendingUrl));
            sb.append("]");
        } else {
            sb.append("\\href{");
            sb.append(this.pendingUrl);
            sb.append("}");
        }
    }

    private static String extractInternalHref(String pendingUrl) {
        if (!Url.isLatex(pendingUrl)) {
            throw new IllegalArgumentException();
        }
        return pendingUrl.substring("latex://".length());
    }

    private String protectText(String text) {
        text = text.replaceAll("\\\\", "\\\\\\\\");
        text = text.replaceAll("_", "\\\\_");
        text = text.replaceAll("\u00ab", "\\\\guillemotleft ");
        text = text.replaceAll("\u00bb", "\\\\guillemotright ");
        text = text.replaceAll("<", "\\\\textless ");
        text = text.replaceAll(">", "\\\\textgreater ");
        text = text.replaceAll("&", "\\\\&");
        text = text.replaceAll("~", "\\\\~{}");
        return text;
    }

    public void line(double x1, double y1, double x2, double y2) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\draw[");
        if (this.color != null) {
            sb.append("color=" + this.getColorName(this.color) + ",");
        }
        sb.append("line width=" + this.thickness + "pt");
        if (this.dash != null) {
            sb.append(",dash pattern=" + this.dash);
        }
        sb.append("] ");
        sb.append(this.couple(x1, y1));
        sb.append(" -- ");
        sb.append(this.couple(x2, y2));
        sb.append(";");
        this.addCommand(sb);
    }

    public void polygon(double[] points) {
        StringBuilder sb = new StringBuilder();
        this.appendShadeOrDraw(sb);
        sb.append("line width=" + this.thickness + "pt]");
        sb.append(" ");
        for (int i = 0; i < points.length; i += 2) {
            sb.append(this.couple(points[i], points[i + 1]));
            sb.append(" -- ");
        }
        sb.append("cycle;");
        this.addCommand(sb);
    }

    private void round(double r, double[] points) {
        StringBuilder sb = new StringBuilder();
        this.appendShadeOrDraw(sb);
        sb.append("line width=" + this.thickness + "pt]");
        sb.append(" ");
        int i = 0;
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" arc (180:270:" + this.format(r) + "pt) -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" arc (270:360:" + this.format(r) + "pt) -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" arc (0:90:" + this.format(r) + "pt) -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" arc (90:180:" + this.format(r) + "pt) -- ");
        sb.append(this.couple(points[i++], points[i++]));
        sb.append(" -- ");
        sb.append("cycle;");
        this.addCommand(sb);
    }

    private void appendShadeOrDraw(StringBuilder sb) {
        boolean gradient = this.fillcolorGradient2 != null;
        sb.append(gradient ? "\\shade[" : "\\draw[");
        if (this.color != null) {
            sb.append(gradient ? "draw=" : "color=");
            sb.append(this.getColorName(this.color) + ",");
        }
        if (gradient) {
            sb.append("top color=" + this.getColorName(this.fillcolor) + ",");
            sb.append("bottom color=" + this.getColorName(this.fillcolorGradient2) + ",");
            sb.append("shading=axis,shading angle=" + this.getAngleFromGradientPolicy() + ",");
        } else if (this.fillcolor != null) {
            sb.append("fill=" + this.getColorName(this.fillcolor) + ",");
            if (this.color == null) {
                sb.append("color=" + this.getColorName(this.fillcolor) + ",");
            }
        }
    }

    public void rectangleRound(double x, double y, double width, double height, double r) {
        double[] points = new double[]{x, y + r, x + r, y, x + width - r, y, x + width, y + r, x + width, y + height - r, x + width - r, y + height, x + r, y + height, x, y + height - r};
        this.round(r, points);
    }

    public void upath(double x, double y, UPath path2) {
        StringBuilder sb = new StringBuilder();
        this.appendShadeOrDraw(sb);
        sb.append("line width=" + this.thickness + "pt");
        if (this.dash != null) {
            sb.append(",dash pattern=" + this.dash);
        }
        sb.append("] ");
        for (USegment seg : path2) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                sb.append(this.couple(coord[0] + x, coord[1] + y));
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                sb.append(" -- ");
                sb.append(this.couple(coord[0] + x, coord[1] + y));
                continue;
            }
            if (type == USegmentType.SEG_QUADTO) {
                throw new UnsupportedOperationException();
            }
            if (type == USegmentType.SEG_CUBICTO) {
                sb.append(" ..controls ");
                sb.append(this.couple(coord[0] + x, coord[1] + y));
                sb.append(" and ");
                sb.append(this.couple(coord[2] + x, coord[3] + y));
                sb.append(" .. ");
                sb.append(this.couple(coord[4] + x, coord[5] + y));
                continue;
            }
            if (type == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + seg);
        }
        sb.append(";");
        this.addCommand(sb);
    }

    public void ellipse(double x, double y, double width, double height) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\draw[");
        if (this.color != null) {
            sb.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            sb.append("fill=" + this.getColorName(this.fillcolor) + ",");
        }
        sb.append("line width=" + this.thickness + "pt] " + this.couple(x, y) + " ellipse (" + this.format(width) + "pt and " + this.format(height) + "pt);");
        this.addCommand(sb);
    }

    public void drawSingleCharacter(double x, double y, char c) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\node at ");
        sb.append(this.couple(x, y));
        sb.append("[]{\\textbf{\\Large " + c + "}};");
        this.addCommand(sb);
    }

    public void drawPathIterator(double x, double y, PathIterator path2) {
        StringBuilder sb = new StringBuilder("\\draw[color=" + this.getColorName(this.color) + ",fill=" + this.getColorName(this.color) + "] ");
        double[] coord = new double[6];
        while (!path2.isDone()) {
            int code = path2.currentSegment(coord);
            if (code == 0) {
                sb.append(this.couple(coord[0] + x, coord[1] + y));
            } else if (code == 1) {
                sb.append(" -- ");
                sb.append(this.couple(coord[0] + x, coord[1] + y));
            } else if (code == 4) {
                sb.append(";");
                this.addCommand(sb);
                sb.setLength(0);
                sb.append("\\draw ");
            } else if (code == 3) {
                sb.append(" ..controls ");
                sb.append(this.couple(coord[0] + x, coord[1] + y));
                sb.append(" and ");
                sb.append(this.couple(coord[2] + x, coord[3] + y));
                sb.append(" .. ");
                sb.append(this.couple(coord[4] + x, coord[5] + y));
            } else if (code == 2) {
                sb.append(" ..controls ");
                sb.append(this.couple(coord[0] + x, coord[1] + y));
                sb.append(" .. ");
                sb.append(this.couple(coord[2] + x, coord[3] + y));
            } else {
                throw new UnsupportedOperationException("code=" + code);
            }
            path2.next();
        }
    }

    public void setFillColor(Color c) {
        this.fillcolor = c;
        this.fillcolorGradient2 = null;
        this.addColor(c);
    }

    public void setGradientColor(Color c1, Color c2, char policy) {
        this.fillcolor = c1;
        this.fillcolorGradient2 = c2;
        this.gradientPolicy = policy;
        this.addColor(c1);
        this.addColor(c2);
    }

    public void setStrokeColor(Color c) {
        this.color = c;
        this.addColor(c);
    }

    private void addColor(Color c) {
        if (c == null) {
            return;
        }
        if (this.colornames.containsKey(c)) {
            return;
        }
        String name = "plantucolor" + String.format("%04d", this.colornames.size());
        this.colornames.put(c, name);
    }

    public void setStrokeWidth(double thickness, String dash) {
        this.thickness = thickness;
        this.dash = dash;
    }

    public void openLink(String url, String title) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        this.hasUrl = true;
        this.urlIgnoreText = false;
        this.pendingUrl = url;
    }

    public void closeLink() {
        this.pendingUrl = null;
    }
}

