/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class MessageArrow
extends Arrow {
    private final LivingParticipantBox p1;
    private final LivingParticipantBox p2;
    private final Component compAliveBox;

    public MessageArrow(double startingY, Skin skin, Component arrow, LivingParticipantBox p1, LivingParticipantBox p2, Url url, Component compAliveBox) {
        super(startingY, skin, arrow, url);
        if (p1 == p2) {
            throw new IllegalArgumentException();
        }
        if (p1 == null || p2 == null) {
            throw new IllegalArgumentException();
        }
        this.p1 = p1;
        this.p2 = p2;
        this.compAliveBox = compAliveBox;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        double r = this.getRightEndInternal(stringBounder) - this.getLeftStartInternal(stringBounder);
        assert (r > 0.0);
        return r;
    }

    private double getLeftStartInternal(StringBounder stringBounder) {
        return this.getParticipantAt(stringBounder, NotePosition.LEFT).getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
    }

    private double getRightEndInternal(StringBounder stringBounder) {
        Segment segment2 = this.getParticipantAt(stringBounder, NotePosition.RIGHT).getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment();
        if (segment2.getLength() == 0.0) {
            return segment2.getPos1();
        }
        double rectWidth = this.compAliveBox.getPreferredWidth(stringBounder);
        return segment2.getPos2() - rectWidth;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        double x2;
        double x1 = this.p1.getParticipantBox().getCenterX(stringBounder);
        if (x1 < (x2 = this.p2.getParticipantBox().getCenterX(stringBounder))) {
            return 1;
        }
        return -1;
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        int direction = this.getDirection(stringBounder);
        if (direction == 1 && position == NotePosition.RIGHT) {
            return this.p2;
        }
        if (direction == 1 && position == NotePosition.LEFT) {
            return this.p1;
        }
        if (direction == -1 && position == NotePosition.RIGHT) {
            return this.p1;
        }
        if (direction == -1 && position == NotePosition.LEFT) {
            return this.p2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredWidth(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UTranslate(this.getStartingX(stringBounder), this.getStartingY()));
        this.startUrl(ug);
        this.getArrowComponent().drawU(ug, new Area(this.getActualDimension(stringBounder)), context);
        this.endUrl(ug);
    }

    private Dimension2D getActualDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getActualWidth(stringBounder) - this.getPaddingArrowHead(), this.getArrowComponent().getPreferredHeight(stringBounder));
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dim = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dim).getY();
        }
        return this.getStartingY();
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dim = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dim).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getRightEndInternal(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.getMinX(stringBounder) + "-" + this.getMaxX(stringBounder);
    }
}

