/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class SymbolContext {
    private final HtmlColor backColor;
    private final HtmlColor foreColor;
    private final UStroke stroke;
    private final boolean shadowing;
    private final double deltaShadow;
    private final double roundCorner;

    private SymbolContext(HtmlColor backColor, HtmlColor foreColor, UStroke stroke, boolean shadowing, double deltaShadow, double roundCorner) {
        this.backColor = backColor;
        this.foreColor = foreColor;
        this.stroke = stroke;
        this.shadowing = shadowing;
        this.deltaShadow = deltaShadow;
        this.roundCorner = roundCorner;
    }

    public String toString() {
        return super.toString() + " backColor=" + this.backColor + " foreColor=" + this.foreColor;
    }

    public final UGraphic apply(UGraphic ug) {
        ug = this.applyColors(ug);
        ug = this.applyStroke(ug);
        return ug;
    }

    public UGraphic applyColors(UGraphic ug) {
        ug = ug.apply(new UChangeColor(this.foreColor));
        ug = ug.apply(new UChangeBackColor(this.backColor));
        return ug;
    }

    public UGraphic applyStroke(UGraphic ug) {
        return ug.apply(this.stroke);
    }

    public SymbolContext transparentBackColorToNull() {
        if (this.backColor instanceof HtmlColorTransparent) {
            return new SymbolContext(null, this.foreColor, this.stroke, this.shadowing, this.deltaShadow, this.roundCorner);
        }
        return this;
    }

    public SymbolContext(HtmlColor backColor, HtmlColor foreColor) {
        this(backColor, foreColor, new UStroke(), false, 0.0, 0.0);
    }

    public SymbolContext withShadow(boolean newShadow) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, newShadow, this.deltaShadow, this.roundCorner);
    }

    public SymbolContext withDeltaShadow(double deltaShadow) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, this.shadowing, deltaShadow, this.roundCorner);
    }

    public SymbolContext withStroke(UStroke newStroke) {
        return new SymbolContext(this.backColor, this.foreColor, newStroke, this.shadowing, this.deltaShadow, this.roundCorner);
    }

    public SymbolContext withBackColor(HtmlColor backColor) {
        return new SymbolContext(backColor, this.foreColor, this.stroke, this.shadowing, this.deltaShadow, this.roundCorner);
    }

    public SymbolContext withForeColor(HtmlColor foreColor) {
        return new SymbolContext(this.backColor, foreColor, this.stroke, this.shadowing, this.deltaShadow, this.roundCorner);
    }

    public SymbolContext withRoundCorner(double roundCorner) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, this.shadowing, this.deltaShadow, roundCorner);
    }

    public HtmlColor getBackColor() {
        return this.backColor;
    }

    public HtmlColor getForeColor() {
        return this.foreColor;
    }

    public UStroke getStroke() {
        return this.stroke;
    }

    public boolean isShadowing() {
        return this.shadowing || this.deltaShadow > 0.0;
    }

    public double getDeltaShadow() {
        return this.deltaShadow;
    }

    public double getRoundCorner() {
        return this.roundCorner;
    }
}

