/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomTable;
import net.sourceforge.plantuml.creole.AtomWithMargin;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;

public class StripeTable
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTable table;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');

    public StripeTable(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        this.table = new AtomTable(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.table, 2.0, 2.0);
        this.analyzeAndAddInternal(line, Mode.HEADER);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    static Atom asAtom(List<StripeSimple> cells, double padding) {
        Sheet sheet = new Sheet(HorizontalAlignment.LEFT);
        for (StripeSimple cell2 : cells) {
            sheet.add(cell2);
        }
        return new SheetBlock1(sheet, LineBreakStrategy.NONE, padding);
    }

    private HtmlColor getBackColor(String line) {
        if (CreoleParser.doesStartByColor(line)) {
            int idx1 = line.indexOf(35);
            int idx2 = line.indexOf(62);
            if (idx2 == -1) {
                throw new IllegalStateException();
            }
            String color = line.substring(idx1, idx2);
            return this.skinParam.getIHtmlColorSet().getColorIfValid(color);
        }
        return null;
    }

    private String withouBackColor(String line) {
        int idx2 = line.indexOf(62);
        if (idx2 == -1) {
            throw new IllegalStateException();
        }
        return line.substring(idx2 + 1);
    }

    private void analyzeAndAddInternal(String line, Mode mode) {
        HtmlColor lineBackColor = this.getBackColor(line);
        if (lineBackColor != null) {
            line = this.withouBackColor(line);
        }
        this.table.newLine(lineBackColor);
        StringTokenizer st = new StringTokenizer(line, "|");
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            HtmlColor cellBackColor = this.getBackColor(v);
            if (cellBackColor != null) {
                v = this.withouBackColor(v);
            }
            if (mode == Mode.HEADER && v.startsWith("=")) {
                v = v.substring(1);
            }
            List<String> lines = StripeTable.getWithNewlinesInternal(v);
            ArrayList<StripeSimple> cells = new ArrayList<StripeSimple>();
            for (String s : lines) {
                StripeSimple cell2 = new StripeSimple(this.getFontConfiguration(mode), this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
                if (s.startsWith("<r>")) {
                    cell2.setCellAlignment(HorizontalAlignment.RIGHT);
                    s = s.substring("<r>".length());
                }
                cell2.analyzeAndAdd(s);
                cells.add(cell2);
            }
            this.table.addCell(StripeTable.asAtom(cells, this.skinParam.getPadding()), cellBackColor);
        }
    }

    static List<String> getWithNewlinesInternal(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < s.length() - 1) {
                char c2 = s.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return result;
    }

    private FontConfiguration getFontConfiguration(Mode mode) {
        if (mode == Mode.NORMAL) {
            return this.fontConfiguration;
        }
        return this.fontConfiguration.bold();
    }

    public void analyzeAndAddNormal(String line) {
        this.analyzeAndAddInternal(line, Mode.NORMAL);
    }

    static enum Mode {
        HEADER,
        NORMAL;

    }
}

