/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.bpm.BpmBranch;
import net.sourceforge.plantuml.bpm.BpmElement;
import net.sourceforge.plantuml.bpm.BpmElementType;
import net.sourceforge.plantuml.bpm.BpmEvent;
import net.sourceforge.plantuml.bpm.BpmEventAdd;
import net.sourceforge.plantuml.bpm.BpmEventGoto;
import net.sourceforge.plantuml.bpm.BpmEventResume;
import net.sourceforge.plantuml.bpm.Cell;
import net.sourceforge.plantuml.bpm.CleanerEmptyLine;
import net.sourceforge.plantuml.bpm.CleanerInterleavingLines;
import net.sourceforge.plantuml.bpm.CleanerMoveBlock;
import net.sourceforge.plantuml.bpm.Col;
import net.sourceforge.plantuml.bpm.Coord;
import net.sourceforge.plantuml.bpm.Grid;
import net.sourceforge.plantuml.bpm.GridArray;
import net.sourceforge.plantuml.bpm.Line;
import net.sourceforge.plantuml.bpm.Navigator;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class BpmDiagram
extends UmlDiagram {
    private final BpmElement start = new BpmElement(null, BpmElementType.START);
    private List<BpmEvent> events = new ArrayList<BpmEvent>();
    private Deque<BpmBranch> branches = new ArrayDeque<BpmBranch>();
    private Coord current;
    private Cell last;

    private void cleanGrid(Grid grid) {
        boolean v3;
        boolean v2;
        boolean v1;
        do {
            v1 = new CleanerEmptyLine().clean(grid);
            v2 = new CleanerInterleavingLines().clean(grid);
            v3 = new CleanerMoveBlock().clean(grid);
        } while (v1 || v2 || v3);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Bpm Diagram)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.BPM;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        double dpiFactor = 1.0;
        double margin = 10.0;
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.setUDrawable(this.getUDrawable());
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private UDrawable getUDrawable() {
        Grid grid = this.createGrid();
        this.cleanGrid(grid);
        GridArray gridArray = grid.toArray(SkinParam.create(this.getUmlDiagramType()));
        System.err.println("gridArray=" + gridArray);
        return gridArray;
    }

    public CommandExecutionResult addEvent(BpmEvent event) {
        this.events.add(event);
        return CommandExecutionResult.ok();
    }

    private Grid createGrid() {
        Grid grid = new Grid();
        this.current = grid.getRoot();
        this.last = grid.getCell(this.current);
        grid.getCell(this.current).setData(this.start);
        for (BpmEvent event : this.events) {
            BpmEvent tmp;
            if (event instanceof BpmEventAdd) {
                tmp = (BpmEventAdd)event;
                this.addInGrid(grid, ((BpmEventAdd)tmp).getElement());
                continue;
            }
            if (event instanceof BpmEventResume) {
                String idDestination = ((BpmEventResume)event).getId();
                this.current = grid.getById(idDestination);
                this.last = grid.getCell(this.current);
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                Navigator<Line> nav = grid.linesOf(this.current);
                Line newLine = new Line();
                nav.insertAfter(newLine);
                Col row = this.current.getCol();
                this.current = new Coord(newLine, row);
                continue;
            }
            if (event instanceof BpmEventGoto) {
                tmp = (BpmEventGoto)event;
                String idDestination = ((BpmEventGoto)tmp).getId();
                this.current = grid.getById(idDestination);
                Cell src = this.last;
                this.last = grid.getCell(this.current);
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                Navigator<Line> nav = grid.linesOf(this.current);
                Line newLine = new Line();
                nav.insertAfter(newLine);
                Col row = this.current.getCol();
                this.current = new Coord(newLine, row);
                src.addConnectionTo2(this.last.getData());
                continue;
            }
            throw new IllegalStateException();
        }
        grid.addConnections();
        return grid;
    }

    private void addInGrid(Grid grid, BpmElement element) {
        Navigator<Col> nav = grid.colsOf(this.current);
        Col newRow = new Col();
        nav.insertAfter(newRow);
        this.current = new Coord(this.current.getLine(), newRow);
        grid.getCell(this.current).setData(element);
        this.last.addConnectionTo2(grid.getCell(this.current).getData());
        this.last = grid.getCell(this.current);
    }

    public CommandExecutionResult newBranch() {
        BpmBranch branch = new BpmBranch(this.events.size());
        this.branches.addLast(branch);
        return this.addEvent(new BpmEventAdd(branch.getEntryElement()));
    }

    public CommandExecutionResult elseBranch() {
        BpmBranch branch = this.branches.getLast();
        int counter = branch.incAndGetCounter();
        if (counter == 2) {
            this.addEvent(new BpmEventAdd(branch.getElseElement()));
            return this.addEvent(branch.getResumeEntryEvent());
        }
        this.addEvent(branch.getGoToEndEvent());
        return this.addEvent(branch.getResumeEntryEvent());
    }

    public CommandExecutionResult endBranch() {
        BpmBranch branch = this.branches.removeLast();
        return this.addEvent(branch.getGoToEndEvent());
    }
}

