/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.plot.Hint;
import jcckit.plot.PositionHint;
import jcckit.plot.Symbol;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class ErrorBarFactory
implements SymbolFactory {
    public static final String SYMBOL_FACTORY_KEY = "symbolFactory";
    private final SymbolFactory _symbolFactory;
    private final GraphicAttributes _attributes;
    private final double _size;

    public ErrorBarFactory(ConfigParameters config) {
        this._symbolFactory = (SymbolFactory)Factory.createOrGet(config.getNode(SYMBOL_FACTORY_KEY), null);
        this._size = config.getDouble("size", 0.0);
        this._attributes = (GraphicAttributes)Factory.createOrGet(config.getNode("attributes"), null);
    }

    @Override
    public GraphicalElement createLegendSymbol(GraphPoint centerPosition, double size) {
        return this._symbolFactory == null ? new GraphicalComposite(null) : this._symbolFactory.createLegendSymbol(centerPosition, size);
    }

    @Override
    public Symbol createSymbol(GraphPoint point2, Hint hintFromPreviousPoint, Hint hintFromPreviousCurve) {
        GraphPoint origin = new GraphPoint(null);
        GraphPoint position = null;
        if (hintFromPreviousCurve instanceof PositionHint) {
            origin = ((PositionHint)hintFromPreviousCurve).getOrigin();
            position = ((PositionHint)hintFromPreviousCurve).getPosition();
        }
        if (position == null) {
            if (this._symbolFactory == null) {
                return new Symbol(new GraphicalComposite(null), hintFromPreviousPoint, new PositionHint(origin, point2));
            }
            return this._symbolFactory.createSymbol(point2, hintFromPreviousPoint, new PositionHint(origin, point2));
        }
        double xError = point2.getX() - origin.getX();
        double yError = point2.getY() - origin.getY();
        GraphicalComposite errorBars = new GraphicalComposite(null);
        if (xError > 0.0) {
            errorBars.addElement(new Rectangle(position, 2.0 * xError, this._size, this._attributes));
        }
        if (yError > 0.0) {
            errorBars.addElement(new Rectangle(position, this._size, 2.0 * yError, this._attributes));
        }
        return new Symbol(errorBars, hintFromPreviousPoint, new PositionHint(origin, null));
    }
}

