/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.Constants;
import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.special.Erf;
import net.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class NormalDistribution
extends ContinuousDistribution {
    private double mean;
    private double standardDeviation;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double m, double s) {
        this.setMean(m);
        this.setStandardDeviation(s);
    }

    @Override
    public double cumulativeProbability(double x) throws NumericException {
        double ret = Double.isInfinite(x) ? (x < 0.0 ? 0.0 : 1.0) : 0.5 * (1.0 + Erf.erf((x - this.getMean()) / (this.getStandardDeviation() * Constants.SQRT_2)));
        return ret;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws NumericException {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : Constants.SQRT_2 * this.getStandardDeviation() * Erf.inverseErf(2.0 * p - 1.0) + this.getMean()));
        return ret;
    }

    public void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("Mean must be a valid number.");
        }
        this.mean = m;
    }

    public void setStandardDeviation(double std) {
        if (std <= 0.0 || Double.isNaN(std)) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        this.standardDeviation = std;
    }
}

