/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.special;

public final class Trigonometric {
    private Trigonometric() {
    }

    public static double acosh(double x) {
        double ret = x < 1.0 || Double.isNaN(x) ? Double.NaN : Math.log(x + Math.sqrt(x * x - 1.0));
        return ret;
    }

    public static double asinh(double x) {
        double ret = Double.isNaN(x) ? Double.NaN : Math.log(x + Math.sqrt(x * x + 1.0));
        return ret;
    }

    public static double atanh(double x) {
        double ret = x < -1.0 || x > 1.0 || Double.isNaN(x) ? Double.NaN : (x == 1.0 ? Double.POSITIVE_INFINITY : (x == -1.0 ? Double.NEGATIVE_INFINITY : 0.5 * (Math.log(1.0 + x) - Math.log(1.0 - x))));
        return ret;
    }

    public static double cosh(double x) {
        double e = Math.exp(x);
        return (e + 1.0 / e) / 2.0;
    }

    public static double sinh(double x) {
        double e = Math.exp(x);
        return (e - 1.0 / e) / 2.0;
    }

    public static double tanh(double x) {
        double e = Math.exp(x * 2.0);
        return (e - 1.0) / (e + 1.0);
    }
}

