/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.random;

import net.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.doodleproject.numerics4j.random.RNG;
import net.doodleproject.numerics4j.random.RandomRNG;

public class TRandomVariable
extends AbstractContinuousRandomVariable {
    private double degreesOfFreedom;

    public TRandomVariable() {
        this(1.0);
    }

    public TRandomVariable(double df) {
        this(df, new RandomRNG());
    }

    public TRandomVariable(double df, RNG source) {
        super(source);
        this.setDegreesOfFreedom(df);
    }

    public static double nextRandomVariable(double df, RNG source) {
        double x;
        double v;
        do {
            double u0 = source.nextRandomNumber();
            double u1 = source.nextRandomNumber();
            if (u0 < 0.5) {
                x = 1.0 / (4.0 * u0 - 1.0);
                v = u1 / (x * x);
                continue;
            }
            x = 4.0 * u0 - 3.0;
            v = u1;
        } while (v >= 1.0 - 0.5 * Math.abs(x) && v >= Math.pow(1.0 + x * x / df, -0.5 * (df + 1.0)));
        return x;
    }

    private double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double nextRandomVariable() {
        return TRandomVariable.nextRandomVariable(this.getDegreesOfFreedom(), this.getSource());
    }

    private void setDegreesOfFreedom(double df) {
        if (df <= 0.0 || Double.isNaN(df)) {
            throw new IllegalArgumentException("Degrees of freedom must be positive.");
        }
        this.degreesOfFreedom = df;
    }
}

