/*
 * Decompiled with CFR 0.152.
 */
package jmathlab.utils;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.StringTokenizer;

public class UtilsOptions {
    public HashMap<String, String> map;

    public UtilsOptions(String foo) {
        foo = foo.trim();
        this.map = new HashMap();
        if (foo.indexOf(";") == -1) {
            StringTokenizer st2 = new StringTokenizer(foo, "=");
            this.map.put(st2.nextToken().trim(), st2.nextToken().trim());
            return;
        }
        StringTokenizer st = new StringTokenizer(foo, ";");
        while (st.hasMoreTokens()) {
            String thisToken = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(thisToken, "=");
            this.map.put(st2.nextToken().trim(), st2.nextToken().trim());
        }
    }

    public String getStringValue(String key, String defo) {
        if (!this.map.containsKey(key)) {
            return defo;
        }
        return this.map.get(key).toString();
    }

    public Color getColorValue(String key, Color defo) {
        if (!this.map.containsKey(key)) {
            return defo;
        }
        String a = this.map.get(key).toString();
        return UtilsOptions.stringToColor(a);
    }

    public static Color stringToColor(String value) {
        if (value == null) {
            return Color.black;
        }
        try {
            return Color.decode(value);
        }
        catch (NumberFormatException nfe) {
            try {
                Field f = Color.class.getField(value);
                return (Color)f.get(null);
            }
            catch (Exception ce) {
                return Color.black;
            }
        }
    }

    public boolean getBooleanValue(String key, boolean defo) {
        if (!this.map.containsKey(key)) {
            return defo;
        }
        String aa = this.map.get(key).toString();
        if (aa.equals("false")) {
            return false;
        }
        if (aa.equals("true")) {
            return true;
        }
        return defo;
    }

    public int getIntValue(String key, int defo) {
        if (!this.map.containsKey(key)) {
            return defo;
        }
        String aa = this.map.get(key).toString();
        int out = defo;
        try {
            out = Integer.parseInt(aa);
        }
        catch (NumberFormatException e) {
            return defo;
        }
        return out;
    }

    public double getDoubleValue(String key, double defo) {
        if (!this.map.containsKey(key)) {
            return defo;
        }
        String aa = this.map.get(key).toString();
        double out = defo;
        try {
            out = Integer.parseInt(aa);
        }
        catch (NumberFormatException e) {
            return defo;
        }
        return out;
    }
}

