/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Environment;
import jasymca.ExpandConstants;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.SimpleVariable;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;

class UserFunction
extends LambdaAlgebraic {
    String fname;
    Algebraic body;
    SimpleVariable[] var;
    SimpleVariable result;
    Environment env = null;

    public UserFunction() throws ParseException, JasymcaException {
    }

    public UserFunction(String fname, SimpleVariable[] var, Algebraic body, SimpleVariable result, Environment env) {
        this.fname = fname;
        this.var = var;
        this.body = body;
        this.result = result;
        this.env = env;
    }

    @Override
    public Zahl f(Zahl x) throws JasymcaException {
        Algebraic y = this.f_exakt(x);
        if (y instanceof Zahl) {
            return (Zahl)y;
        }
        if ((y = new ExpandConstants().f_exakt(y)) instanceof Zahl) {
            return (Zahl)y;
        }
        throw new JasymcaException("Can not evaluate Function " + this.fname + " to number, got " + y + " for " + x);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (this.var.length != 1) {
            throw new JasymcaException("Wrong number of arguments.");
        }
        Algebraic y = this.body.value(this.var[0], x);
        return y;
    }

    @Override
    Algebraic f_exakt(Algebraic x, Algebraic y) throws JasymcaException {
        if (this.var.length != 2) {
            throw new JasymcaException("Wrong number of arguments.");
        }
        Algebraic z = this.body.value(this.var[0], y);
        z = z.value(this.var[1], x);
        return z;
    }

    @Override
    Algebraic f_exakt(Algebraic[] x) throws JasymcaException {
        if (this.var.length != x.length) {
            throw new JasymcaException("Wrong number of arguments.");
        }
        Algebraic y = this.body;
        for (int i = 0; i < x.length; ++i) {
            y = y.value(this.var[x.length - i - 1], x[i]);
        }
        return y;
    }

    Algebraic fv(Vektor x) throws JasymcaException {
        Environment global = UserFunction.pc.env;
        UserFunction.pc.env = this.env;
        Algebraic r = this.body;
        UserFunction.pc.env = global;
        for (int i = 0; i < this.var.length; ++i) {
            r = r.value(this.var[i], x.get(i));
        }
        return r;
    }

    @Override
    public Algebraic integrate(Algebraic arg, Variable x) throws JasymcaException {
        if (!(this.body instanceof Algebraic)) {
            throw new JasymcaException("Can not integrate function " + this.fname);
        }
        if (!arg.depends(x)) {
            throw new JasymcaException("Expression in function does not depend on Variable.");
        }
        if (this.var.length == 1) {
            return this.body.value(this.var[0], arg).integrate(x);
        }
        if (arg instanceof Vektor && ((Vektor)arg).length() == this.var.length) {
            return this.fv((Vektor)arg).integrate(x);
        }
        throw new JasymcaException("Wrong argument to function " + this.fname);
    }
}

