/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Exponential;
import jasymca.FunctionVariable;
import jasymca.GetExpVars2;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SimpleVariable;
import jasymca.Variable;
import jasymca.Zahl;
import java.util.Vector;

class SubstExp
extends LambdaAlgebraic {
    Zahl gcd;
    Variable var;
    Variable t = new SimpleVariable("t_exponential");

    public SubstExp(Zahl gcd, Variable var) {
        this.gcd = gcd;
        this.var = var;
    }

    public SubstExp(Variable var, Algebraic expr) throws JasymcaException {
        this.var = var;
        Vector v = new Vector();
        new GetExpVars2(v).f_exakt(expr);
        this.gcd = Exponential.exp_gcd(v, var);
        if (this.gcd.equals(Zahl.ZERO)) {
            this.t = var;
        }
    }

    public Algebraic ratsubst(Algebraic expr) throws JasymcaException {
        if (this.gcd.equals(Zahl.ZERO)) {
            return expr;
        }
        if (!expr.depends(this.var)) {
            return expr;
        }
        if (expr instanceof Rational) {
            return this.ratsubst(((Rational)expr).nom).div(this.ratsubst(((Rational)expr).den));
        }
        if (expr instanceof Polynomial && ((Polynomial)expr).var instanceof FunctionVariable && ((FunctionVariable)((Polynomial)expr).var).fname.equals("exp") && ((FunctionVariable)((Polynomial)expr).var).arg instanceof Polynomial && ((Polynomial)((FunctionVariable)((Polynomial)expr).var).arg).var.equals(this.var) && ((Polynomial)((FunctionVariable)((Polynomial)expr).var).arg).degree() == 1 && ((Polynomial)((FunctionVariable)((Polynomial)expr).var).arg).a[0].equals(Zahl.ZERO)) {
            Polynomial pexpr = (Polynomial)expr;
            int degree = pexpr.degree();
            Algebraic[] a = new Algebraic[degree + 1];
            for (int i = 0; i <= degree; ++i) {
                Algebraic cf = pexpr.a[i];
                if (cf.depends(this.var)) {
                    throw new JasymcaException("Rationalize failed: 2");
                }
                a[i] = cf;
            }
            return new Polynomial(this.t, a);
        }
        throw new JasymcaException("Could not rationalize " + expr);
    }

    public Algebraic rational(Algebraic expr) throws JasymcaException {
        return this.ratsubst(expr).div(this.gcd).div(new Polynomial(this.t)).reduce();
    }

    public Algebraic rat_reverse(Algebraic expr) throws JasymcaException {
        if (this.gcd.equals(Zahl.ZERO)) {
            return expr;
        }
        Zahl gc = this.gcd;
        Exponential s = new Exponential(Zahl.ONE, Zahl.ZERO, this.var, Zahl.ONE.mult(gc));
        return expr.value(this.t, s);
    }

    @Override
    Algebraic f_exakt(Algebraic f) throws JasymcaException {
        if (this.gcd.equals(Zahl.ZERO)) {
            return f;
        }
        if (f instanceof Polynomial) {
            Polynomial p = (Polynomial)f;
            if (p.var instanceof FunctionVariable && ((FunctionVariable)p.var).fname.equals("exp") && Poly.degree(((FunctionVariable)p.var).arg, this.var) == 1) {
                Algebraic arg = ((FunctionVariable)p.var).arg;
                Algebraic[] new_coef = new Algebraic[2];
                new_coef[1] = this.gcd.unexakt();
                new_coef[0] = Zahl.ZERO;
                Polynomial new_arg = new Polynomial(this.var, new_coef);
                Algebraic subst = FunctionVariable.create("exp", new_arg);
                Algebraic exp = Poly.coefficient(arg, this.var, 1).div(this.gcd);
                if (!(exp instanceof Zahl) && !((Zahl)exp).integerq()) {
                    throw new JasymcaException("Not integer exponent in exponential simplification.");
                }
                subst = subst.pow_n(((Zahl)exp).intval());
                subst = subst.mult(FunctionVariable.create("exp", Poly.coefficient(arg, this.var, 0)));
                int n = p.a.length;
                Algebraic r = this.f_exakt(p.a[n - 1]);
                for (int i = n - 2; i >= 0; --i) {
                    r = r.mult(subst).add(this.f_exakt(p.a[i]));
                }
                return r;
            }
        }
        return f.map(this);
    }
}

