/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Polynomial;
import jasymca.Root;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;

class SqrtExpand
extends LambdaAlgebraic {
    SqrtExpand() {
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        int i;
        Vektor cr;
        if (!(x instanceof Polynomial)) {
            return x.map(this);
        }
        Polynomial xp = (Polynomial)x;
        Variable var = xp.var;
        if (var instanceof Root && (cr = ((Root)var).poly).length() == xp.degree() + 1) {
            Algebraic[] xr = new Algebraic[xp.degree() + 1];
            Algebraic ratio = null;
            for (int i2 = xr.length - 1; i2 >= 0; --i2) {
                xr[i2] = xp.a[i2].map(this);
                if (i2 == xr.length - 1) {
                    ratio = xr[i2];
                    continue;
                }
                if (i2 <= 0 || ratio == null || cr.get(i2).mult(ratio).equals(xr[i2])) continue;
                ratio = null;
            }
            if (ratio != null) {
                return xr[0].sub(ratio.mult(cr.get(0)));
            }
            return new Polynomial(var, xr);
        }
        Algebraic xf = null;
        if (var instanceof FunctionVariable && ((FunctionVariable)var).fname.equals("sqrt") && ((FunctionVariable)var).arg instanceof Polynomial) {
            Polynomial arg = (Polynomial)((FunctionVariable)var).arg;
            Algebraic[] sqfr = arg.square_free_dec(arg.var);
            boolean issquare = true;
            if (sqfr.length > 0 && !sqfr[0].equals(arg.a[arg.a.length - 1])) {
                issquare = false;
            }
            for (i = 2; i < sqfr.length && issquare; ++i) {
                if ((i + 1) % 2 != 1 || sqfr[i].equals(Zahl.ONE)) continue;
                issquare = false;
            }
            if (issquare) {
                xf = Zahl.ONE;
                for (i = 1; i < sqfr.length; i += 2) {
                    if (sqfr[i].equals(Zahl.ZERO)) continue;
                    xf = xf.mult(sqfr[i].pow_n((i + 1) / 2));
                }
                Algebraic r = Zahl.ZERO;
                for (int i3 = xp.a.length - 1; i3 > 0; --i3) {
                    r = r.add(this.f_exakt(xp.a[i3])).mult(xf);
                }
                if (xp.a.length > 0) {
                    r = r.add(this.f_exakt(xp.a[0]));
                }
                return r;
            }
        }
        if (var instanceof FunctionVariable && ((FunctionVariable)var).fname.equals("sqrt") && xp.degree() > 1) {
            xf = ((FunctionVariable)var).arg;
            Polynomial sq = new Polynomial(var);
            Algebraic r = this.f_exakt(xp.a[0]);
            Algebraic xv = Zahl.ONE;
            for (i = 1; i < xp.a.length; ++i) {
                if (i % 2 == 1) {
                    r = r.add(this.f_exakt(xp.a[i]).mult(xv).mult(sq));
                    continue;
                }
                xv = xv.mult(xf);
                r = r.add(this.f_exakt(xp.a[i]).mult(xv));
            }
            return r;
        }
        return x.map(this);
    }
}

