/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.ExpandConstants;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Zahl;
import java.util.Stack;

class LambdaROMBERG
extends Lambda {
    LambdaROMBERG() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaROMBERG.getNarg(st);
        if (narg != 4) {
            throw new ParseException("Usage: ROMBERG (exp,var,ll,ul)");
        }
        Algebraic exp = LambdaROMBERG.getAlgebraic(st);
        Variable v = LambdaROMBERG.getVariable(st);
        Algebraic ll = LambdaROMBERG.getAlgebraic(st);
        Algebraic ul = LambdaROMBERG.getAlgebraic(st);
        ExpandConstants xc = new ExpandConstants();
        exp = ((LambdaAlgebraic)xc).f_exakt(exp);
        ll = ((LambdaAlgebraic)xc).f_exakt(ll);
        ul = ((LambdaAlgebraic)xc).f_exakt(ul);
        if (!(ll instanceof Zahl) || !(ul instanceof Zahl)) {
            throw new ParseException("Usage: ROMBERG (exp,var,ll,ul)");
        }
        double rombergtol = 1.0E-4;
        int rombergit = 11;
        Zahl a1 = LambdaROMBERG.pc.env.getnum("rombergit");
        if (a1 != null) {
            rombergit = a1.intval();
        }
        if ((a1 = LambdaROMBERG.pc.env.getnum("rombergtol")) != null) {
            rombergtol = a1.unexakt().real;
        }
        double a = ((Zahl)ll).unexakt().real;
        double b = ((Zahl)ul).unexakt().real;
        double[][] I = new double[rombergit][rombergit];
        int i = 0;
        int n = 1;
        Algebraic t = this.trapez(exp, v, n, a, b);
        if (!(t instanceof Zahl)) {
            throw new ParseException("Expression must evaluate to number");
        }
        I[0][0] = ((Zahl)t).unexakt().real;
        double epsa = 1.1 * rombergtol;
        while (epsa > rombergtol && i < rombergit - 1) {
            t = this.trapez(exp, v, n *= 2, a, b);
            I[0][++i] = ((Zahl)t).unexakt().real;
            double f = 1.0;
            for (int k = 1; k <= i; ++k) {
                I[k][i] = I[k - 1][i] + (I[k - 1][i] - I[k - 1][i - 1]) / ((f *= 4.0) - 1.0);
            }
            epsa = Math.abs((I[i][i] - I[i - 1][i - 1]) / I[i][i]);
        }
        st.push(new Unexakt(I[i][i]));
        return 0;
    }

    Algebraic trapez(Algebraic exp, Variable v, int n, double a, double b) throws JasymcaException {
        Algebraic sum = Zahl.ZERO;
        double step = (b - a) / (double)n;
        for (int i = 1; i < n; ++i) {
            Algebraic x = exp.value(v, new Unexakt(a + step * (double)i));
            sum = sum.add(x);
        }
        sum = exp.value(v, new Unexakt(a)).add(sum.mult(Zahl.TWO)).add(exp.value(v, new Unexakt(b)));
        return new Unexakt(b - a).mult(sum).div(new Unexakt(2.0 * (double)n));
    }
}

